/*
 * sort_methods.cpp
 *
 *  Created on: Apr 24, 2012
 *      Author: lc525
 */
#include <string>
#include <iostream>
#include "sort_methods.h"

using namespace alg1Impl;

/*
 * >>>>>>>>>>>>>>>>>>>>>>> YOUR IMPLEMENTATIONS HERE <<<<<<<<<<<<<<<<<<<<<<<<<
 *
 * general sort function prototype:
 *
 * void sort(int *const list, long n) where:
 *
 *   list: a pointer to the list of integers that needs to be sorted
 *         it is a const pointer, which means you can change the values
 *         inside the vector but you can't change the pointer itself.
 *         after the function's execution, list should be sorted.
 *   n: the number of elements in the list
 *
 */


/*
 * implementation for bubble sort with small optimizations
 */
void bubble_sort(int* const list, long n){

	bool swapped;
	int last_unsorted = n-1;
	int lswap = 0;

	do{
		swapped = false;
		for(int i = 0; i < last_unsorted; i++){
			if(list[i] > list[i+1]){
				int tmp = list[i];
				list[i] = list[i+1];
				list[i+1] = tmp;
				swapped = true;
				lswap = i;
			}
		}
		last_unsorted = lswap;
	} while(swapped);
}


/*
 * unoptimized bubble sort
 */
void bubble_sort2(int* const list, long n){

	bool swapped;

	do{
		swapped = false;
		for(int i = 0; i < n - 1 ; i++){
			if(list[i] > list[i+1]){
				int tmp = list[i];
				list[i] = list[i+1];
				list[i+1] = tmp;
				swapped = true;
			}
		}
	} while(swapped);
}

/*
 * >>>>>>>>>>>>>>>>>>>> PLEASE COMPLETE THE DATA BELOW <<<<<<<<<<<<<<<<<<<<<<
 *
 *  - set impl_Author to your CRSID
 *  - set noSortFunctions to the number of sorting functions you test
 *  - list the tested sorting functions in the mySortFunctions array
 *  - put strings representing the names of the tested sorting functions
 *    in the mySortFunctionNames array
 *
 */
std::string Sorting::impl_Author = "lc525";
int Sorting::noSortFunctions = 2;
sortFctType Sorting::mySortFunctions[] = {bubble_sort, bubble_sort2};
std::string Sorting::mySortFunctionNames[] = {"bubble_sort", "bubble_sort2"};
