/*
 * main.cpp
 *
 *  Created on: Apr 24, 2012
 *      Author: lc525
 */
#include <fstream>
#include <iostream>
#include <time.h>
#include <string>
#include <cstring> //for memcpy
#include <stdlib.h>
#include "sort_methods.h"


using namespace std;

timespec diff(timespec start, timespec end)
{
	timespec temp;
	if ((end.tv_nsec - start.tv_nsec) < 0) {
		temp.tv_sec = end.tv_sec - start.tv_sec - 1;
		temp.tv_nsec = 1000000000 + end.tv_nsec - start.tv_nsec;
	} else {
		temp.tv_sec = end.tv_sec - start.tv_sec;
		temp.tv_nsec = end.tv_nsec - start.tv_nsec;
	}
	return temp;
}


int main(int argc, char** argv){

	int n;
	int *vals;

	if(argc > 1 && argc != 3){
		cout<<"Usage: "<<argv[0]<<" [-gen <no-elements>]"<<endl;
		return 0;
	}
	if(argc == 3){
		if(strcmp(argv[1],"-gen") != 0){
			cout<<"Usage: "<<argv[0]<<" [-gen <no-elements>]"<<endl;
			return 0;
		}
		else{
			ofstream out;

			long n;
			out.open("data.in");
			n = atol(argv[2]);

			out<<n<<endl;

			srand(time(0));
			int random;
			for(long i = 0; i < n; i++){
				random = rand() % (90 * n);
				out<<random<<" ";
			}

			out.close();
			cout<<"Generated "<<n<<" random numbers in data.in. Now re-run without the -gen parameter."<<endl;
		}
	}
	else{

		ifstream in("data.in");
		if(!in.is_open()){
			cout<<"No input data found. Generate data.in by running "<<argv[0]<<" with the -gen parameter."<<endl;
			in.close();
			return 0;
		}
		in>>n;
		vals = new int[n];
		for(int i = 0; i < n; i++){
			in>>vals[i];
		}
		in.close();


		cout<<"Sorting "<<n<<" elements. timings are approximate"<<endl<<endl;
		int nf = alg1Impl::Sorting::noSortFunctions;
		for(int k = 0; k < nf; k++){

			// initialize input
			int* svect = new int[n];
			memcpy(svect, vals, n*sizeof(int));

			cout<<"running sort with "<<alg1Impl::Sorting::mySortFunctionNames[k]<<"() ...\t";
			cout.flush();

			// run the k'th sorting function on the data, with timing
			timespec start, end;
			clock_gettime(CLOCK_MONOTONIC, &start);
			alg1Impl::Sorting::mySortFunctions[k](svect, n);
			clock_gettime(CLOCK_MONOTONIC, &end);

			timespec tdif = diff(start, end);
			cout<<"done in "<<fixed<<tdif.tv_sec<<":"<<tdif.tv_nsec<<" (s:ns) ";

			//test if sorting is ok
			bool ok=true;
			for(int i = 0; i< n-1; i++){
				if(svect[i] > svect[i+1]) ok=false;
			}
			cout<<"... result: ";
			if(ok == false)
				cout<<"wrong";
			else
				cout<<"ok";
			cout<<endl;
			cout.flush();


			// write results to file
			string ofname = alg1Impl::Sorting::mySortFunctionNames[k]+".out";
			ofstream out(ofname.c_str());

			out<<"author:"<<alg1Impl::Sorting::impl_Author<<endl;
			out<<"exectime:"<<tdif.tv_sec<<":"<<tdif.tv_nsec<<"(s:ns)"<<endl;
			out<<n<<endl;
			for(int i = 0; i < n-1; i++){
				out<<svect[i]<<" ";
			}
			out<<svect[n-1];

			out.close();
			delete []svect;
		}

		cout<<endl<<"end.";
		delete []vals;

	}

	return 0;
}


