#!/usr/bin/perl -w

use strict;

use XML::SAX::ParserFactory;

my $fn = $ARGV[0] or die "Usage: $0 <filename>\n";

my $handler = My::Handler->new();
my $parser = XML::SAX::ParserFactory->parser( Handler => $handler );
$parser->parse_uri($fn);

# ---------------------------------------------------------------------

package My::Handler;

sub new {
  my $class = shift;
  my $self = {@_};
  $self->{indent} = 0;
  return bless($self,$class);
}

sub start_element {
  my $self = shift;
  my $data =  shift;
  print ' ' x $self->{indent};
  print $data->{Name}, "\n";
  $self->{indent} += 2;
}

sub end_element {
  my $self = shift;
  my $data =  shift;
  $self->{indent} -= 2;
}

sub characters {
  my $self = shift;
  my $data =  shift;
  my $text = normalise($data->{Data});
  if ($text !~ /^\s*$/) {
    print ' ' x $self->{indent};
    print '"', $text, '"', "\n" 
  }
}
  
# ---------------------------------------------------------------------

sub normalise {
  
  my ($text) = @_;
  
  $text =~ s/[\s\n]+/ /g;
  $text =~ s/^\s*//;
  $text =~ s/\s*$//;

  return $text;

}

# ---------------------------------------------------------------------
