<?xml version="1.0"?>

<xsl:stylesheet 
  version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format">

  <xsl:template match="institutions">
    <fo:root>
      <fo:layout-master-set>
        <fo:simple-page-master master-name="first"
          margin-right="10mm"  margin-left="10mm"
          margin-top="10mm"    margin-bottom="10mm"
          page-width="210mm"   page-height="297mm">
          <fo:region-body/>
        </fo:simple-page-master>
      </fo:layout-master-set>

      <fo:page-sequence master-reference="first">
        <fo:flow flow-name="xsl-region-body">
          <xsl:apply-templates/>
        </fo:flow>
      </fo:page-sequence>

    </fo:root>
  </xsl:template>

  <xsl:template match="institution">
    <fo:block font-family="sans-serif" font-size="10pt">
      <xsl:apply-templates select="name"/>
      <xsl:apply-templates select="contact"/>
      <xsl:apply-templates select="website/url"/>
    </fo:block>
  </xsl:template>

  <xsl:template match="name">
    <fo:block font-size="15pt" font-weight="bold" 
      space-before="15pt" space-after="8pt">
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>  

  <xsl:template match="contact">
    <fo:block>
      <xsl:choose>
        <xsl:when test="@method='tel'">
          Telephone: 
          <xsl:value-of select="."/>
        </xsl:when>
        <xsl:when test="@method='email'">
          Email: 
          <xsl:value-of select="."/>
        </xsl:when>
      </xsl:choose>
    </fo:block>
  </xsl:template>

  <xsl:template match="url">
    <fo:block>   
      URL: 
      <xsl:value-of select="."/>
    </fo:block>
  </xsl:template>
 
</xsl:stylesheet>
