<?xml version="1.0"?>

<xsl:stylesheet 
  version="1.0" 
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output 
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" 
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" 
    method="xml" 
    omit-xml-declaration="yes" 
    indent="yes" />
 
  <xsl:template match="institutions">
    <html lang="en">
      <head>
        <title>Institutions</title>
      </head>
      <body>
      <h1>
        A list of institutions
      </h1>
      <table border="1" cellpadding="5">
        <xsl:apply-templates select="institution"/>
      </table>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="institution">
    <tr valign="top">
      <td>
        <xsl:apply-templates select="name"/>
      </td>
      <td>
        <xsl:apply-templates select="contact"/>
      </td>
      <td>
        <xsl:apply-templates select="website/url"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="contact">
    <xsl:choose>
      <xsl:when test="@method='tel'">
        Telephone: 
        <xsl:value-of select="."/>
      </xsl:when>
      <xsl:when test="@method='email'">
        Email: 
        <a>
          <xsl:attribute name="href">
            mailto:<xsl:value-of select="."/>
          </xsl:attribute>
          <xsl:value-of select="."/>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
    <br/>
  </xsl:template>

  <xsl:template match="url">
    <a>
      <xsl:attribute name="href">
        <xsl:value-of select="."/>
      </xsl:attribute>
      <xsl:value-of select="."/>
    </a>
    <br/>
  </xsl:template>
 
</xsl:stylesheet>
