#!/usr/bin/perl -w

use strict;

use XML::LibXML;

my $fn = $ARGV[0] or die "Usage: $0 <filename>\n";
my $parser = XML::LibXML->new();
my $doc = $parser->parse_file($fn);

my $root = $doc->getDocumentElement;

do_process($root,0);

# ---------------------------------------------------------------------

sub do_process {

  my ($element,$indent) = @_;

  # Print out text values from text nodes

  if (ref($element) =~ /Text/) {
    my $text = normalise($element->nodeValue);
    if ($text !~ /^\s*$/) {
      print ' ' x $indent;
      print '"', $text, '"', "\n" 
    }
  }
  
  # Otherwise print the element name
  
  else {
    print ' ' x $indent;
    print $element->nodeName, "\n";
  }
  
  # Process any children
  
  foreach my $node ($element->getChildnodes) {
    do_process($node,$indent+2);
  }
  
}

# ---------------------------------------------------------------------

sub normalise {
  
  my ($text) = @_;
  
  $text =~ s/[\s\n]+/ /g;
  $text =~ s/^\s*//;
  $text =~ s/\s*$//;

  return $text;

}

# ---------------------------------------------------------------------
