#!/usr/bin/perl -Tw
use strict;

use CGI;

my %cgi = (SERVER_SOFTWARE => 1,
           SERVER_NAME => 1,
           GATEWAY_INTERFACE => 1,
           SERVER_PROTOCOL => 1,
           SERVER_PORT => 1,
           REQUEST_METHOD => 1,
           PATH_INFO => 1,
           PATH_TRANSLATED => 1,
           SCRIPT_NAME => 1,
           QUERY_STRING => 1,
           REMOTE_HOST => 1,
           REMOTE_ADDR => 1,
           AUTH_TYPE => 1,
           REMOTE_USER => 1,
           REMOTE_IDENT => 1,
           CONTENT_TYPE => 1,
           CONTENT_LENGTH => 1,
	  );



use vars '$q';
$q = new CGI;

print $q->header,
    $q->start_html('CGI execution environment'),
    $q->h1('CGI execution environment'),
    $q->start_table,
    $q->Tr(
      $q->th({-align=>"left",-colspan=>2},'Environment Variables')
    ),
    $q->Tr(
      $q->td({-align=>"left",-colspan=>2},'* marks variables defined in CGI')
    );

for my $var (sort keys %ENV) {
  my $encvar = $q->escapeHTML($var);
  my $star = '';
  if ($var =~ /^HTTP_/ or $cgi{$var}) {
    $star = $q->b('*');
  }
  print $q->Tr(
          $q->th({-align=>"right"},"$star$encvar:"),
          $q->td($q->escapeHTML($ENV{$var}))
        )
}

$ENV{PATH} = $ENV{BASH_ENV} = '';

print $q->Tr(
        $q->td('&nbsp')
      ),
      $q->Tr(
        $q->th({-align=>"left",-colspan=>2},'Other Environment')
      ),
      $q->Tr(
        $q->th({-align=>"right"},'CWD:'),
        $q->td($q->escapeHTML(`/bin/pwd`))
      ),
      $q->Tr(
        $q->th({-align=>"right"},'ID:'),
        $q->td($q->escapeHTML(`/usr/bin/id`))
      ),
      $q->Tr(
        $q->th({-align=>"right"},'CmdLine:'),
        $q->td($q->escapeHTML((map { '"' . $_ . '" ' } @ARGV)))
      ),
      $q->Tr(
        $q->th({-align=>"right"},'Script name:'),
        $q->td($q->escapeHTML($0))
      ),

      $q->end_table,
      $q->end_html;





