/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Matrix4f;
import org.joml.Matrix4x3f;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4d;

public class Vector4f
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;
    public float w = 1.0f;

    public Vector4f() {
    }

    public Vector4f(Vector4f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
    }

    public Vector4f(Vector3f v, float w) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = w;
    }

    public Vector4f(Vector2f v, float z, float w) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        this.w = w;
    }

    public Vector4f(float d) {
        this(d, d, d, d);
    }

    public Vector4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4f(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4f(int index, ByteBuffer buffer) {
        this.x = buffer.getFloat(index);
        this.y = buffer.getFloat(index + 4);
        this.z = buffer.getFloat(index + 8);
        this.w = buffer.getFloat(index + 12);
    }

    public Vector4f(FloatBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4f(int index, FloatBuffer buffer) {
        this.x = buffer.get(index);
        this.y = buffer.get(index + 1);
        this.z = buffer.get(index + 2);
        this.w = buffer.get(index + 3);
    }

    public Vector4f set(Vector4f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
        return this;
    }

    public Vector4f set(Vector4d v) {
        this.x = (float)v.x;
        this.y = (float)v.y;
        this.z = (float)v.z;
        this.w = (float)v.w;
        return this;
    }

    public Vector4f set(Vector3f v, float w) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = w;
        return this;
    }

    public Vector4f set(Vector2f v, float z, float w) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4f set(float d) {
        return this.set(d, d, d, d);
    }

    public Vector4f set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4f set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4f set(int index, ByteBuffer buffer) {
        this.x = buffer.getFloat(index);
        this.y = buffer.getFloat(index + 4);
        this.z = buffer.getFloat(index + 8);
        this.w = buffer.getFloat(index + 12);
        return this;
    }

    public Vector4f set(FloatBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4f set(int index, FloatBuffer buffer) {
        this.x = buffer.get(index);
        this.y = buffer.get(index + 1);
        this.z = buffer.get(index + 2);
        this.w = buffer.get(index + 3);
        return this;
    }

    public FloatBuffer get(FloatBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public FloatBuffer get(int index, FloatBuffer buffer) {
        buffer.put(index, this.x);
        buffer.put(index + 1, this.y);
        buffer.put(index + 2, this.z);
        buffer.put(index + 3, this.w);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        buffer.putFloat(index, this.x);
        buffer.putFloat(index + 4, this.y);
        buffer.putFloat(index + 8, this.z);
        buffer.putFloat(index + 12, this.w);
        return buffer;
    }

    public Vector4f sub(Vector4f v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        this.w -= v.w;
        return this;
    }

    public Vector4f sub(float x, float y, float z, float w) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        this.w -= w;
        return this;
    }

    public Vector4f sub(Vector4f v, Vector4f dest) {
        dest.x = this.x - v.x;
        dest.y = this.y - v.y;
        dest.z = this.z - v.z;
        dest.w = this.w - v.w;
        return dest;
    }

    public Vector4f sub(float x, float y, float z, float w, Vector4f dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        dest.w = this.w - w;
        return dest;
    }

    public Vector4f add(Vector4f v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        this.w += v.w;
        return this;
    }

    public Vector4f add(Vector4f v, Vector4f dest) {
        dest.x = this.x + v.x;
        dest.y = this.y + v.y;
        dest.z = this.z + v.z;
        dest.w = this.w + v.w;
        return dest;
    }

    public Vector4f add(float x, float y, float z, float w) {
        this.x += x;
        this.y += y;
        this.z += z;
        this.w += w;
        return this;
    }

    public Vector4f add(float x, float y, float z, float w, Vector4f dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        dest.w = this.w + w;
        return dest;
    }

    public Vector4f fma(Vector4f a, Vector4f b) {
        this.x += a.x * b.x;
        this.y += a.y * b.y;
        this.z += a.z * b.z;
        this.w += a.w * b.w;
        return this;
    }

    public Vector4f fma(float a, Vector4f b) {
        this.x += a * b.x;
        this.y += a * b.y;
        this.z += a * b.z;
        this.w += a * b.w;
        return this;
    }

    public Vector4f fma(Vector4f a, Vector4f b, Vector4f dest) {
        dest.x = this.x + a.x * b.x;
        dest.y = this.y + a.y * b.y;
        dest.z = this.z + a.z * b.z;
        dest.w = this.w + a.w * b.w;
        return dest;
    }

    public Vector4f fma(float a, Vector4f b, Vector4f dest) {
        dest.x = this.x + a * b.x;
        dest.y = this.y + a * b.y;
        dest.z = this.z + a * b.z;
        dest.w = this.w + a * b.w;
        return dest;
    }

    public Vector4f mul(Vector4f v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        this.w *= v.w;
        return this;
    }

    public Vector4f mul(Vector4f v, Vector4f dest) {
        dest.x = this.x * v.x;
        dest.y = this.y * v.y;
        dest.z = this.z * v.z;
        dest.w = this.w * v.w;
        return dest;
    }

    public Vector4f div(Vector4f v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        this.w /= v.w;
        return this;
    }

    public Vector4f div(Vector4f v, Vector4f dest) {
        dest.x = this.x / v.x;
        dest.y = this.y / v.y;
        dest.z = this.z / v.z;
        dest.w = this.w / v.w;
        return dest;
    }

    public Vector4f mul(Matrix4f mat) {
        return this.mul(mat, this);
    }

    public Vector4f mul(Matrix4f mat, Vector4f dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w, mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w, mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33() * this.w);
        return dest;
    }

    public Vector4f mul(Matrix4x3f mat) {
        return this.mul(mat, this);
    }

    public Vector4f mul(Matrix4x3f mat, Vector4f dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w, mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w, this.w);
        return dest;
    }

    public Vector4f mulProject(Matrix4f mat, Vector4f dest) {
        float invW = 1.0f / (mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33() * this.w);
        dest.set((mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w) * invW, (mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w) * invW, (mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w) * invW, 1.0f);
        return dest;
    }

    public Vector4f mulProject(Matrix4f mat) {
        return this.mulProject(mat, this);
    }

    public Vector4f mul(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
        return this;
    }

    public Vector4f mul(float scalar, Vector4f dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        dest.z = this.z * scalar;
        dest.w = this.w * scalar;
        return dest;
    }

    public Vector4f mul(float x, float y, float z, float w) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        this.w *= w;
        return this;
    }

    public Vector4f mul(float x, float y, float z, float w, Vector4f dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        dest.z = this.z * z;
        dest.w = this.w * w;
        return dest;
    }

    public Vector4f div(float scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
        this.w /= scalar;
        return this;
    }

    public Vector4f div(float scalar, Vector4f dest) {
        dest.x = this.x / scalar;
        dest.y = this.y / scalar;
        dest.z = this.z / scalar;
        dest.w = this.w / scalar;
        return dest;
    }

    public Vector4f div(float x, float y, float z, float w) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        this.w /= w;
        return this;
    }

    public Vector4f div(float x, float y, float z, float w, Vector4f dest) {
        dest.x = this.x / x;
        dest.y = this.y / y;
        dest.z = this.z / z;
        dest.w = this.w / w;
        return dest;
    }

    public Vector4f rotate(Quaternionf quat) {
        return this.rotate(quat, this);
    }

    public Vector4f rotate(Quaternionf quat, Vector4f dest) {
        return quat.transform(this, dest);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public Vector4f normalize() {
        float invLength = 1.0f / this.length();
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
        this.w *= invLength;
        return this;
    }

    public Vector4f normalize(Vector4f dest) {
        float invLength = 1.0f / this.length();
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        dest.w = this.w * invLength;
        return dest;
    }

    public Vector4f normalize3() {
        float invLength = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z));
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
        this.w *= invLength;
        return this;
    }

    public float distance(Vector4f v) {
        float dx = v.x - this.x;
        float dy = v.y - this.y;
        float dz = v.z - this.z;
        float dw = v.w - this.w;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    public float distance(float x, float y, float z, float w) {
        float dx = this.x - x;
        float dy = this.y - y;
        float dz = this.z - z;
        float dw = this.w - w;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    public float dot(Vector4f v) {
        return this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;
    }

    public float dot(float x, float y, float z, float w) {
        return this.x * x + this.y * y + this.z * z + this.w * w;
    }

    public float angleCos(Vector4f v) {
        double length1Sqared = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        double length2Sqared = v.x * v.x + v.y * v.y + v.z * v.z + v.w * v.w;
        double dot = this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;
        return (float)(dot / Math.sqrt(length1Sqared * length2Sqared));
    }

    public float angle(Vector4f v) {
        float cos = this.angleCos(v);
        cos = cos < 1.0f ? cos : 1.0f;
        cos = cos > -1.0f ? cos : -1.0f;
        return (float)Math.acos(cos);
    }

    public Vector4f zero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 0.0f;
        return this;
    }

    public Vector4f negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Vector4f negate(Vector4f dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        dest.w = -this.w;
        return dest;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat(" 0.000E0;-");
        return this.toString(formatter).replaceAll("E(\\d+)", "E+$1");
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + " " + formatter.format(this.w) + ")";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
        out.writeFloat(this.w);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.z = in.readFloat();
        this.w = in.readFloat();
    }

    public Vector4f min(Vector4f v) {
        this.x = this.x < v.x ? this.x : v.x;
        this.y = this.y < v.y ? this.y : v.y;
        this.z = this.z < v.z ? this.z : v.z;
        this.w = this.w < v.w ? this.w : v.w;
        return this;
    }

    public Vector4f max(Vector4f v) {
        this.x = this.x > v.x ? this.x : v.x;
        this.y = this.y > v.y ? this.y : v.y;
        this.z = this.z > v.z ? this.z : v.z;
        this.w = this.w > v.w ? this.w : v.w;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.w);
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector4f other = (Vector4f)obj;
        if (Float.floatToIntBits(this.w) != Float.floatToIntBits(other.w)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }

    public Vector4f smoothStep(Vector4f v, float t, Vector4f dest) {
        float t2 = t * t;
        float t3 = t2 * t;
        dest.x = (this.x + this.x - v.x - v.x) * t3 + (3.0f * v.x - 3.0f * this.x) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v.y - v.y) * t3 + (3.0f * v.y - 3.0f * this.y) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v.z - v.z) * t3 + (3.0f * v.z - 3.0f * this.z) * t2 + this.z * t + this.z;
        dest.w = (this.w + this.w - v.w - v.w) * t3 + (3.0f * v.w - 3.0f * this.w) * t2 + this.w * t + this.w;
        return dest;
    }

    public Vector4f hermite(Vector4f t0, Vector4f v1, Vector4f t1, float t, Vector4f dest) {
        float t2 = t * t;
        float t3 = t2 * t;
        dest.x = (this.x + this.x - v1.x - v1.x + t1.x + t0.x) * t3 + (3.0f * v1.x - 3.0f * this.x - t0.x - t0.x - t1.x) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v1.y - v1.y + t1.y + t0.y) * t3 + (3.0f * v1.y - 3.0f * this.y - t0.y - t0.y - t1.y) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v1.z - v1.z + t1.z + t0.z) * t3 + (3.0f * v1.z - 3.0f * this.z - t0.z - t0.z - t1.z) * t2 + this.z * t + this.z;
        dest.w = (this.w + this.w - v1.w - v1.w + t1.w + t0.w) * t3 + (3.0f * v1.w - 3.0f * this.w - t0.w - t0.w - t1.w) * t2 + this.w * t + this.w;
        return dest;
    }

    public Vector4f lerp(Vector4f other, float t) {
        return this.lerp(other, t, this);
    }

    public Vector4f lerp(Vector4f other, float t, Vector4f dest) {
        dest.x = this.x + (other.x - this.x) * t;
        dest.y = this.y + (other.y - this.y) * t;
        dest.z = this.z + (other.z - this.z) * t;
        dest.w = this.w + (other.w - this.w) * t;
        return dest;
    }
}

