/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import org.joml.Vector2d;

public class Vector2i
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;

    public Vector2i() {
    }

    public Vector2i(int s) {
        this.x = s;
        this.y = s;
    }

    public Vector2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vector2i(Vector2i v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vector2i(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector2i(int index, ByteBuffer buffer) {
        this.x = buffer.getInt(index + 0);
        this.y = buffer.getInt(index + 4);
    }

    public Vector2i(IntBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector2i(int index, IntBuffer buffer) {
        this.x = buffer.get(index);
        this.y = buffer.get(index + 1);
    }

    public Vector2i set(int s) {
        this.x = s;
        this.y = s;
        return this;
    }

    public Vector2i set(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2i set(Vector2i v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vector2i set(Vector2d v) {
        this.x = (int)v.x;
        this.y = (int)v.y;
        return this;
    }

    public Vector2i set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector2i set(int index, ByteBuffer buffer) {
        this.x = buffer.getInt(index);
        this.y = buffer.getInt(index + 4);
        return this;
    }

    public Vector2i set(IntBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector2i set(int index, IntBuffer buffer) {
        this.x = buffer.get(index);
        this.y = buffer.get(index + 1);
        return this;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        buffer.putInt(index + 0, this.x);
        buffer.putInt(index + 4, this.y);
        return buffer;
    }

    public IntBuffer get(IntBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public IntBuffer get(int index, IntBuffer buffer) {
        buffer.put(index, this.x);
        buffer.put(index + 1, this.y);
        return buffer;
    }

    public Vector2i sub(Vector2i v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public Vector2i sub(Vector2i v, Vector2i dest) {
        dest.x = this.x - v.x;
        dest.y = this.y - v.y;
        return dest;
    }

    public Vector2i sub(int x, int y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2i sub(int x, int y, Vector2i dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        return dest;
    }

    public long lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distance(Vector2i v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    public double distance(int x, int y) {
        return Math.sqrt(this.distanceSquared(x, y));
    }

    public long distanceSquared(Vector2i v) {
        int dx = this.x - v.x;
        int dy = this.y - v.y;
        return dx * dx + dy * dy;
    }

    public long distanceSquared(int x, int y) {
        int dx = this.x - x;
        int dy = this.y - y;
        return dx * dx + dy * dy;
    }

    public Vector2i add(Vector2i v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public Vector2i add(Vector2i v, Vector2i dest) {
        dest.x = this.x + v.x;
        dest.y = this.y + v.y;
        return dest;
    }

    public Vector2i add(int x, int y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2i add(int x, int y, Vector2i dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        return dest;
    }

    public Vector2i mul(int scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public Vector2i mul(int scalar, Vector2i dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        return dest;
    }

    public Vector2i mul(Vector2i v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public Vector2i mul(Vector2i v, Vector2i dest) {
        dest.x = this.x * v.x;
        dest.y = this.y * v.y;
        return dest;
    }

    public Vector2i mul(int x, int y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Vector2i mul(int x, int y, Vector2i dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        return dest;
    }

    public Vector2i zero() {
        this.x = 0;
        this.y = 0;
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readInt();
        this.y = in.readInt();
    }

    public Vector2i negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2i negate(Vector2i dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector2i other = (Vector2i)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        return "(" + this.x + " " + this.y + ")";
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + ")";
    }
}

