/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Vector2d;

public class Vector2f
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;

    public Vector2f() {
    }

    public Vector2f(float d) {
        this(d, d);
    }

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f(Vector2f v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vector2f(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector2f(int index, ByteBuffer buffer) {
        this.x = buffer.getFloat(index);
        this.y = buffer.getFloat(index + 4);
    }

    public Vector2f(FloatBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector2f(int index, FloatBuffer buffer) {
        this.x = buffer.get(index);
        this.y = buffer.get(index + 1);
    }

    public Vector2f set(float d) {
        return this.set(d, d);
    }

    public Vector2f set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2f set(Vector2f v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vector2f set(Vector2d v) {
        this.x = (float)v.x;
        this.y = (float)v.y;
        return this;
    }

    public Vector2f set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector2f set(int index, ByteBuffer buffer) {
        this.x = buffer.getFloat(index);
        this.y = buffer.getFloat(index + 4);
        return this;
    }

    public Vector2f set(FloatBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector2f set(int index, FloatBuffer buffer) {
        this.x = buffer.get(index);
        this.y = buffer.get(index + 1);
        return this;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        buffer.putFloat(index, this.x);
        buffer.putFloat(index + 4, this.y);
        return buffer;
    }

    public FloatBuffer get(FloatBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public FloatBuffer get(int index, FloatBuffer buffer) {
        buffer.put(index, this.x);
        buffer.put(index + 1, this.y);
        return buffer;
    }

    public Vector2f perpendicular() {
        return this.set(this.y, this.x * -1.0f);
    }

    public Vector2f sub(Vector2f v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public Vector2f sub(Vector2f v, Vector2f dest) {
        dest.x = this.x - v.x;
        dest.y = this.y - v.y;
        return dest;
    }

    public Vector2f sub(float x, float y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2f sub(float x, float y, Vector2f dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        return dest;
    }

    public float dot(Vector2f v) {
        return this.x * v.x + this.y * v.y;
    }

    public float angle(Vector2f v) {
        float dot = this.x * v.x + this.y * v.y;
        float det = this.x * v.y - this.y * v.x;
        return (float)Math.atan2(det, dot);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float distance(Vector2f v) {
        float dx = v.x - this.x;
        float dy = v.y - this.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public Vector2f normalize() {
        float invLength = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y));
        this.x *= invLength;
        this.y *= invLength;
        return this;
    }

    public Vector2f normalize(Vector2f dest) {
        float invLength = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y));
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        return dest;
    }

    public Vector2f add(Vector2f v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public Vector2f add(Vector2f v, Vector2f dest) {
        dest.x = this.x + v.x;
        dest.y = this.y + v.y;
        return dest;
    }

    public Vector2f add(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2f add(float x, float y, Vector2f dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        return dest;
    }

    public Vector2f zero() {
        this.x = 0.0f;
        this.y = 0.0f;
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readFloat();
        this.y = in.readFloat();
    }

    public Vector2f negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2f negate(Vector2f dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        return dest;
    }

    public Vector2f mul(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public Vector2f mul(float scalar, Vector2f dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        return dest;
    }

    public Vector2f mul(float x, float y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Vector2f mul(float x, float y, Vector2f dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        return dest;
    }

    public Vector2f mul(Vector2f v) {
        this.x *= v.x;
        this.y *= v.y;
        return this;
    }

    public Vector2f mul(Vector2f v, Vector2f dest) {
        dest.x = this.x * v.x;
        dest.y = this.y * v.y;
        return dest;
    }

    public Vector2f lerp(Vector2f other, float t) {
        return this.lerp(other, t, this);
    }

    public Vector2f lerp(Vector2f other, float t, Vector2f dest) {
        dest.x = this.x + (other.x - this.x) * t;
        dest.y = this.y + (other.y - this.y) * t;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector2f other = (Vector2f)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat(" 0.000E0;-");
        return this.toString(formatter).replaceAll("E(\\d+)", "E+$1");
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + ")";
    }

    public Vector2f fma(Vector2f a, Vector2f b) {
        this.x += a.x * b.x;
        this.y += a.y * b.y;
        return this;
    }

    public Vector2f fma(float a, Vector2f b) {
        this.x += a * b.x;
        this.y += a * b.y;
        return this;
    }

    public Vector2f fma(Vector2f a, Vector2f b, Vector2f dest) {
        dest.x = this.x + a.x * b.x;
        dest.y = this.y + a.y * b.y;
        return dest;
    }

    public Vector2f fma(float a, Vector2f b, Vector2f dest) {
        dest.x = this.x + a * b.x;
        dest.y = this.y + a * b.y;
        return dest;
    }
}

