/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.MemUtil;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class Matrix3f
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public float m00;
    public float m10;
    public float m20;
    public float m01;
    public float m11;
    public float m21;
    public float m02;
    public float m12;
    public float m22;

    public Matrix3f() {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
        this.m22 = 1.0f;
    }

    public Matrix3f(Matrix3f mat) {
        this.m00 = mat.m00;
        this.m01 = mat.m01;
        this.m02 = mat.m02;
        this.m10 = mat.m10;
        this.m11 = mat.m11;
        this.m12 = mat.m12;
        this.m20 = mat.m20;
        this.m21 = mat.m21;
        this.m22 = mat.m22;
    }

    public Matrix3f(Matrix4f mat) {
        this.m00 = mat.m00();
        this.m01 = mat.m01();
        this.m02 = mat.m02();
        this.m10 = mat.m10();
        this.m11 = mat.m11();
        this.m12 = mat.m12();
        this.m20 = mat.m20();
        this.m21 = mat.m21();
        this.m22 = mat.m22();
    }

    public Matrix3f(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public Matrix3f(FloatBuffer buffer) {
        MemUtil.INSTANCE.get(this, buffer.position(), buffer);
    }

    public float m00() {
        return this.m00;
    }

    public float m01() {
        return this.m01;
    }

    public float m02() {
        return this.m02;
    }

    public float m10() {
        return this.m10;
    }

    public float m11() {
        return this.m11;
    }

    public float m12() {
        return this.m12;
    }

    public float m20() {
        return this.m20;
    }

    public float m21() {
        return this.m21;
    }

    public float m22() {
        return this.m22;
    }

    public Matrix3f m00(float m00) {
        this.m00 = m00;
        return this;
    }

    public Matrix3f m01(float m01) {
        this.m01 = m01;
        return this;
    }

    public Matrix3f m02(float m02) {
        this.m02 = m02;
        return this;
    }

    public Matrix3f m10(float m10) {
        this.m10 = m10;
        return this;
    }

    public Matrix3f m11(float m11) {
        this.m11 = m11;
        return this;
    }

    public Matrix3f m12(float m12) {
        this.m12 = m12;
        return this;
    }

    public Matrix3f m20(float m20) {
        this.m20 = m20;
        return this;
    }

    public Matrix3f m21(float m21) {
        this.m21 = m21;
        return this;
    }

    public Matrix3f m22(float m22) {
        this.m22 = m22;
        return this;
    }

    public Matrix3f set(Matrix3f m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        return this;
    }

    public Matrix3f set(Matrix4f mat) {
        this.m00 = mat.m00();
        this.m01 = mat.m01();
        this.m02 = mat.m02();
        this.m10 = mat.m10();
        this.m11 = mat.m11();
        this.m12 = mat.m12();
        this.m20 = mat.m20();
        this.m21 = mat.m21();
        this.m22 = mat.m22();
        return this;
    }

    public Matrix3f set(AxisAngle4f axisAngle) {
        float x = axisAngle.x;
        float y = axisAngle.y;
        float z = axisAngle.z;
        float angle = axisAngle.angle;
        float invLength = (float)(1.0 / Math.sqrt(x * x + y * y + z * z));
        x *= invLength;
        y *= invLength;
        z *= invLength;
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        float omc = 1.0f - c;
        this.m00 = c + x * x * omc;
        this.m11 = c + y * y * omc;
        this.m22 = c + z * z * omc;
        float tmp1 = x * y * omc;
        float tmp2 = z * s;
        this.m10 = tmp1 - tmp2;
        this.m01 = tmp1 + tmp2;
        tmp1 = x * z * omc;
        tmp2 = y * s;
        this.m20 = tmp1 + tmp2;
        this.m02 = tmp1 - tmp2;
        tmp1 = y * z * omc;
        tmp2 = x * s;
        this.m21 = tmp1 - tmp2;
        this.m12 = tmp1 + tmp2;
        return this;
    }

    public Matrix3f set(AxisAngle4d axisAngle) {
        double x = axisAngle.x;
        double y = axisAngle.y;
        double z = axisAngle.z;
        double angle = axisAngle.angle;
        double invLength = 1.0 / Math.sqrt(x * x + y * y + z * z);
        x *= invLength;
        y *= invLength;
        z *= invLength;
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double omc = 1.0 - c;
        this.m00 = (float)(c + x * x * omc);
        this.m11 = (float)(c + y * y * omc);
        this.m22 = (float)(c + z * z * omc);
        double tmp1 = x * y * omc;
        double tmp2 = z * s;
        this.m10 = (float)(tmp1 - tmp2);
        this.m01 = (float)(tmp1 + tmp2);
        tmp1 = x * z * omc;
        tmp2 = y * s;
        this.m20 = (float)(tmp1 + tmp2);
        this.m02 = (float)(tmp1 - tmp2);
        tmp1 = y * z * omc;
        tmp2 = x * s;
        this.m21 = (float)(tmp1 - tmp2);
        this.m12 = (float)(tmp1 + tmp2);
        return this;
    }

    public Matrix3f set(Quaternionf q) {
        q.get(this);
        return this;
    }

    public Matrix3f set(Quaterniond q) {
        q.get(this);
        return this;
    }

    public Matrix3f mul(Matrix3f right) {
        return this.mul(right, this);
    }

    public Matrix3f mul(Matrix3f right, Matrix3f dest) {
        float nm00 = this.m00 * right.m00 + this.m10 * right.m01 + this.m20 * right.m02;
        float nm01 = this.m01 * right.m00 + this.m11 * right.m01 + this.m21 * right.m02;
        float nm02 = this.m02 * right.m00 + this.m12 * right.m01 + this.m22 * right.m02;
        float nm10 = this.m00 * right.m10 + this.m10 * right.m11 + this.m20 * right.m12;
        float nm11 = this.m01 * right.m10 + this.m11 * right.m11 + this.m21 * right.m12;
        float nm12 = this.m02 * right.m10 + this.m12 * right.m11 + this.m22 * right.m12;
        float nm20 = this.m00 * right.m20 + this.m10 * right.m21 + this.m20 * right.m22;
        float nm21 = this.m01 * right.m20 + this.m11 * right.m21 + this.m21 * right.m22;
        float nm22 = this.m02 * right.m20 + this.m12 * right.m21 + this.m22 * right.m22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3f set(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        return this;
    }

    public Matrix3f set(float[] m) {
        this.m00 = m[0];
        this.m01 = m[1];
        this.m02 = m[2];
        this.m10 = m[3];
        this.m11 = m[4];
        this.m12 = m[5];
        this.m20 = m[6];
        this.m21 = m[7];
        this.m22 = m[8];
        return this;
    }

    public float determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public Matrix3f invert() {
        return this.invert(this);
    }

    public Matrix3f invert(Matrix3f dest) {
        float s = this.determinant();
        s = 1.0f / s;
        float nm00 = (this.m11 * this.m22 - this.m21 * this.m12) * s;
        float nm01 = (this.m21 * this.m02 - this.m01 * this.m22) * s;
        float nm02 = (this.m01 * this.m12 - this.m11 * this.m02) * s;
        float nm10 = (this.m20 * this.m12 - this.m10 * this.m22) * s;
        float nm11 = (this.m00 * this.m22 - this.m20 * this.m02) * s;
        float nm12 = (this.m10 * this.m02 - this.m00 * this.m12) * s;
        float nm20 = (this.m10 * this.m21 - this.m20 * this.m11) * s;
        float nm21 = (this.m20 * this.m01 - this.m00 * this.m21) * s;
        float nm22 = (this.m00 * this.m11 - this.m10 * this.m01) * s;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3f transpose() {
        return this.transpose(this);
    }

    public Matrix3f transpose(Matrix3f dest) {
        dest.set(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
        return dest;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat("  0.000E0; -");
        return this.toString(formatter).replaceAll("E(\\d+)", "E+$1");
    }

    public String toString(NumberFormat formatter) {
        return formatter.format(this.m00) + formatter.format(this.m10) + formatter.format(this.m20) + "\n" + formatter.format(this.m01) + formatter.format(this.m11) + formatter.format(this.m21) + "\n" + formatter.format(this.m02) + formatter.format(this.m12) + formatter.format(this.m22) + "\n";
    }

    public Matrix3f get(Matrix3f dest) {
        return dest.set(this);
    }

    public Matrix4f get(Matrix4f dest) {
        return dest.set(this);
    }

    public AxisAngle4f getRotation(AxisAngle4f dest) {
        return dest.set(this);
    }

    public Quaternionf getUnnormalizedRotation(Quaternionf dest) {
        return dest.setFromUnnormalized(this);
    }

    public Quaternionf getNormalizedRotation(Quaternionf dest) {
        return dest.setFromNormalized(this);
    }

    public Quaterniond getUnnormalizedRotation(Quaterniond dest) {
        return dest.setFromUnnormalized(this);
    }

    public Quaterniond getNormalizedRotation(Quaterniond dest) {
        return dest.setFromNormalized(this);
    }

    public FloatBuffer get(FloatBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public FloatBuffer get(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public FloatBuffer getTransposed(FloatBuffer buffer) {
        return this.getTransposed(buffer.position(), buffer);
    }

    public FloatBuffer getTransposed(int index, FloatBuffer buffer) {
        buffer.put(index, this.m00);
        buffer.put(index + 1, this.m10);
        buffer.put(index + 2, this.m20);
        buffer.put(index + 3, this.m01);
        buffer.put(index + 4, this.m11);
        buffer.put(index + 5, this.m21);
        buffer.put(index + 6, this.m02);
        buffer.put(index + 7, this.m12);
        buffer.put(index + 8, this.m22);
        return buffer;
    }

    public ByteBuffer getTransposed(ByteBuffer buffer) {
        return this.getTransposed(buffer.position(), buffer);
    }

    public ByteBuffer getTransposed(int index, ByteBuffer buffer) {
        buffer.putFloat(index, this.m00);
        buffer.putFloat(index + 4, this.m10);
        buffer.putFloat(index + 8, this.m20);
        buffer.putFloat(index + 12, this.m01);
        buffer.putFloat(index + 16, this.m11);
        buffer.putFloat(index + 20, this.m21);
        buffer.putFloat(index + 24, this.m02);
        buffer.putFloat(index + 28, this.m12);
        buffer.putFloat(index + 32, this.m22);
        return buffer;
    }

    public float[] get(float[] arr, int offset) {
        arr[offset + 0] = this.m00;
        arr[offset + 1] = this.m01;
        arr[offset + 2] = this.m02;
        arr[offset + 3] = this.m10;
        arr[offset + 4] = this.m11;
        arr[offset + 5] = this.m12;
        arr[offset + 6] = this.m20;
        arr[offset + 7] = this.m21;
        arr[offset + 8] = this.m22;
        return arr;
    }

    public float[] get(float[] arr) {
        return this.get(arr, 0);
    }

    public Matrix3f set(FloatBuffer buffer) {
        MemUtil.INSTANCE.get(this, buffer.position(), buffer);
        return this;
    }

    public Matrix3f set(ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, buffer.position(), buffer);
        return this;
    }

    public Matrix3f zero() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        return this;
    }

    public Matrix3f identity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix3f scale(Vector3f xyz, Matrix3f dest) {
        return this.scale(xyz.x, xyz.y, xyz.z, dest);
    }

    public Matrix3f scale(Vector3f xyz) {
        return this.scale(xyz.x, xyz.y, xyz.z, this);
    }

    public Matrix3f scale(float x, float y, float z, Matrix3f dest) {
        dest.m00 = this.m00 * x;
        dest.m01 = this.m01 * x;
        dest.m02 = this.m02 * x;
        dest.m10 = this.m10 * y;
        dest.m11 = this.m11 * y;
        dest.m12 = this.m12 * y;
        dest.m20 = this.m20 * z;
        dest.m21 = this.m21 * z;
        dest.m22 = this.m22 * z;
        return dest;
    }

    public Matrix3f scale(float x, float y, float z) {
        return this.scale(x, y, z, this);
    }

    public Matrix3f scale(float xyz, Matrix3f dest) {
        return this.scale(xyz, xyz, xyz, dest);
    }

    public Matrix3f scale(float xyz) {
        return this.scale(xyz, xyz, xyz);
    }

    public Matrix3f scaleLocal(float x, float y, float z, Matrix3f dest) {
        float nm00 = x * this.m00;
        float nm01 = y * this.m01;
        float nm02 = z * this.m02;
        float nm10 = x * this.m10;
        float nm11 = y * this.m11;
        float nm12 = z * this.m12;
        float nm20 = x * this.m20;
        float nm21 = y * this.m21;
        float nm22 = z * this.m22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3f scaleLocal(float x, float y, float z) {
        return this.scaleLocal(x, y, z, this);
    }

    public Matrix3f scaling(float factor) {
        this.m00 = factor;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = factor;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = factor;
        return this;
    }

    public Matrix3f scaling(float x, float y, float z) {
        this.m00 = x;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = y;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = z;
        return this;
    }

    public Matrix3f scaling(Vector3f xyz) {
        return this.scaling(xyz.x, xyz.y, xyz.z);
    }

    public Matrix3f rotation(float angle, Vector3f axis) {
        return this.rotation(angle, axis.x, axis.y, axis.z);
    }

    public Matrix3f rotation(AxisAngle4f axisAngle) {
        return this.rotation(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Matrix3f rotation(float angle, float x, float y, float z) {
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        float C = 1.0f - cos;
        float xy = x * y;
        float xz = x * z;
        float yz = y * z;
        this.m00 = cos + x * x * C;
        this.m10 = xy * C - z * sin;
        this.m20 = xz * C + y * sin;
        this.m01 = xy * C + z * sin;
        this.m11 = cos + y * y * C;
        this.m21 = yz * C - x * sin;
        this.m02 = xz * C - y * sin;
        this.m12 = yz * C + x * sin;
        this.m22 = cos + z * z * C;
        return this;
    }

    public Matrix3f rotationX(float ang) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = cos;
        this.m12 = sin;
        this.m20 = 0.0f;
        this.m21 = -sin;
        this.m22 = cos;
        return this;
    }

    public Matrix3f rotationY(float ang) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        this.m00 = cos;
        this.m01 = 0.0f;
        this.m02 = -sin;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = sin;
        this.m21 = 0.0f;
        this.m22 = cos;
        return this;
    }

    public Matrix3f rotationZ(float ang) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        this.m00 = cos;
        this.m01 = sin;
        this.m02 = 0.0f;
        this.m10 = -sin;
        this.m11 = cos;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix3f rotationXYZ(float angleX, float angleY, float angleZ) {
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float m_sinX = -sinX;
        float m_sinY = -sinY;
        float m_sinZ = -sinZ;
        float nm11 = cosX;
        float nm12 = sinX;
        float nm21 = m_sinX;
        float nm22 = cosX;
        float nm00 = cosY;
        float nm01 = nm21 * m_sinY;
        float nm02 = nm22 * m_sinY;
        this.m20 = sinY;
        this.m21 = nm21 * cosY;
        this.m22 = nm22 * cosY;
        this.m00 = nm00 * cosZ;
        this.m01 = nm01 * cosZ + nm11 * sinZ;
        this.m02 = nm02 * cosZ + nm12 * sinZ;
        this.m10 = nm00 * m_sinZ;
        this.m11 = nm01 * m_sinZ + nm11 * cosZ;
        this.m12 = nm02 * m_sinZ + nm12 * cosZ;
        return this;
    }

    public Matrix3f rotationZYX(float angleZ, float angleY, float angleX) {
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float m_sinZ = -sinZ;
        float m_sinY = -sinY;
        float m_sinX = -sinX;
        float nm00 = cosZ;
        float nm01 = sinZ;
        float nm10 = m_sinZ;
        float nm11 = cosZ;
        float nm20 = nm00 * sinY;
        float nm21 = nm01 * sinY;
        float nm22 = cosY;
        this.m00 = nm00 * cosY;
        this.m01 = nm01 * cosY;
        this.m02 = m_sinY;
        this.m10 = nm10 * cosX + nm20 * sinX;
        this.m11 = nm11 * cosX + nm21 * sinX;
        this.m12 = nm22 * sinX;
        this.m20 = nm10 * m_sinX + nm20 * cosX;
        this.m21 = nm11 * m_sinX + nm21 * cosX;
        this.m22 = nm22 * cosX;
        return this;
    }

    public Matrix3f rotationYXZ(float angleY, float angleX, float angleZ) {
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float m_sinY = -sinY;
        float m_sinX = -sinX;
        float m_sinZ = -sinZ;
        float nm00 = cosY;
        float nm02 = m_sinY;
        float nm20 = sinY;
        float nm22 = cosY;
        float nm10 = nm20 * sinX;
        float nm11 = cosX;
        float nm12 = nm22 * sinX;
        this.m20 = nm20 * cosX;
        this.m21 = m_sinX;
        this.m22 = nm22 * cosX;
        this.m00 = nm00 * cosZ + nm10 * sinZ;
        this.m01 = nm11 * sinZ;
        this.m02 = nm02 * cosZ + nm12 * sinZ;
        this.m10 = nm00 * m_sinZ + nm10 * cosZ;
        this.m11 = nm11 * cosZ;
        this.m12 = nm02 * m_sinZ + nm12 * cosZ;
        return this;
    }

    public Matrix3f rotation(Quaternionf quat) {
        float dqx = quat.x + quat.x;
        float dqy = quat.y + quat.y;
        float dqz = quat.z + quat.z;
        float q00 = dqx * quat.x;
        float q11 = dqy * quat.y;
        float q22 = dqz * quat.z;
        float q01 = dqx * quat.y;
        float q02 = dqx * quat.z;
        float q03 = dqx * quat.w;
        float q12 = dqy * quat.z;
        float q13 = dqy * quat.w;
        float q23 = dqz * quat.w;
        this.m00 = 1.0f - q11 - q22;
        this.m01 = q01 + q23;
        this.m02 = q02 - q13;
        this.m10 = q01 - q23;
        this.m11 = 1.0f - q22 - q00;
        this.m12 = q12 + q03;
        this.m20 = q02 + q13;
        this.m21 = q12 - q03;
        this.m22 = 1.0f - q11 - q00;
        return this;
    }

    public Vector3f transform(Vector3f v) {
        return v.mul(this);
    }

    public Vector3f transform(Vector3f v, Vector3f dest) {
        v.mul(this, dest);
        return dest;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.m00);
        out.writeFloat(this.m01);
        out.writeFloat(this.m02);
        out.writeFloat(this.m10);
        out.writeFloat(this.m11);
        out.writeFloat(this.m12);
        out.writeFloat(this.m20);
        out.writeFloat(this.m21);
        out.writeFloat(this.m22);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m00 = in.readFloat();
        this.m01 = in.readFloat();
        this.m02 = in.readFloat();
        this.m10 = in.readFloat();
        this.m11 = in.readFloat();
        this.m12 = in.readFloat();
        this.m20 = in.readFloat();
        this.m21 = in.readFloat();
        this.m22 = in.readFloat();
    }

    public Matrix3f rotateX(float ang, Matrix3f dest) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        float rm11 = cos;
        float rm21 = -sin;
        float rm12 = sin;
        float rm22 = cos;
        float nm10 = this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m12 * rm11 + this.m22 * rm12;
        dest.m20 = this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m12 * rm21 + this.m22 * rm22;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m00 = this.m00;
        dest.m01 = this.m01;
        dest.m02 = this.m02;
        return dest;
    }

    public Matrix3f rotateX(float ang) {
        return this.rotateX(ang, this);
    }

    public Matrix3f rotateY(float ang, Matrix3f dest) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        float rm00 = cos;
        float rm20 = sin;
        float rm02 = -sin;
        float rm22 = cos;
        float nm00 = this.m00 * rm00 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m22 * rm02;
        dest.m20 = this.m00 * rm20 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m22 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = this.m10;
        dest.m11 = this.m11;
        dest.m12 = this.m12;
        return dest;
    }

    public Matrix3f rotateY(float ang) {
        return this.rotateY(ang, this);
    }

    public Matrix3f rotateZ(float ang, Matrix3f dest) {
        float sin;
        float cos;
        if (ang == (float)Math.PI || ang == (float)(-Math.PI)) {
            cos = -1.0f;
            sin = 0.0f;
        } else if (ang == 1.5707964f || ang == -4.712389f) {
            cos = 0.0f;
            sin = 1.0f;
        } else if (ang == -1.5707964f || ang == 4.712389f) {
            cos = 0.0f;
            sin = -1.0f;
        } else {
            cos = (float)Math.cos(ang);
            sin = (float)Math.sin(ang);
        }
        float rm00 = cos;
        float rm10 = -sin;
        float rm01 = sin;
        float rm11 = cos;
        float nm00 = this.m00 * rm00 + this.m10 * rm01;
        float nm01 = this.m01 * rm00 + this.m11 * rm01;
        float nm02 = this.m02 * rm00 + this.m12 * rm01;
        dest.m10 = this.m00 * rm10 + this.m10 * rm11;
        dest.m11 = this.m01 * rm10 + this.m11 * rm11;
        dest.m12 = this.m02 * rm10 + this.m12 * rm11;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m20 = this.m20;
        dest.m21 = this.m21;
        dest.m22 = this.m22;
        return dest;
    }

    public Matrix3f rotateZ(float ang) {
        return this.rotateZ(ang, this);
    }

    public Matrix3f rotateXYZ(float angleX, float angleY, float angleZ) {
        return this.rotateXYZ(angleX, angleY, angleZ, this);
    }

    public Matrix3f rotateXYZ(float angleX, float angleY, float angleZ, Matrix3f dest) {
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float m_sinX = -sinX;
        float m_sinY = -sinY;
        float m_sinZ = -sinZ;
        float nm10 = this.m10 * cosX + this.m20 * sinX;
        float nm11 = this.m11 * cosX + this.m21 * sinX;
        float nm12 = this.m12 * cosX + this.m22 * sinX;
        float nm20 = this.m10 * m_sinX + this.m20 * cosX;
        float nm21 = this.m11 * m_sinX + this.m21 * cosX;
        float nm22 = this.m12 * m_sinX + this.m22 * cosX;
        float nm00 = this.m00 * cosY + nm20 * m_sinY;
        float nm01 = this.m01 * cosY + nm21 * m_sinY;
        float nm02 = this.m02 * cosY + nm22 * m_sinY;
        dest.m20 = this.m00 * sinY + nm20 * cosY;
        dest.m21 = this.m01 * sinY + nm21 * cosY;
        dest.m22 = this.m02 * sinY + nm22 * cosY;
        dest.m00 = nm00 * cosZ + nm10 * sinZ;
        dest.m01 = nm01 * cosZ + nm11 * sinZ;
        dest.m02 = nm02 * cosZ + nm12 * sinZ;
        dest.m10 = nm00 * m_sinZ + nm10 * cosZ;
        dest.m11 = nm01 * m_sinZ + nm11 * cosZ;
        dest.m12 = nm02 * m_sinZ + nm12 * cosZ;
        return dest;
    }

    public Matrix3f rotateZYX(float angleZ, float angleY, float angleX) {
        return this.rotateZYX(angleZ, angleY, angleX, this);
    }

    public Matrix3f rotateZYX(float angleZ, float angleY, float angleX, Matrix3f dest) {
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float m_sinZ = -sinZ;
        float m_sinY = -sinY;
        float m_sinX = -sinX;
        float nm00 = this.m00 * cosZ + this.m10 * sinZ;
        float nm01 = this.m01 * cosZ + this.m11 * sinZ;
        float nm02 = this.m02 * cosZ + this.m12 * sinZ;
        float nm10 = this.m00 * m_sinZ + this.m10 * cosZ;
        float nm11 = this.m01 * m_sinZ + this.m11 * cosZ;
        float nm12 = this.m02 * m_sinZ + this.m12 * cosZ;
        float nm20 = nm00 * sinY + this.m20 * cosY;
        float nm21 = nm01 * sinY + this.m21 * cosY;
        float nm22 = nm02 * sinY + this.m22 * cosY;
        dest.m00 = nm00 * cosY + this.m20 * m_sinY;
        dest.m01 = nm01 * cosY + this.m21 * m_sinY;
        dest.m02 = nm02 * cosY + this.m22 * m_sinY;
        dest.m10 = nm10 * cosX + nm20 * sinX;
        dest.m11 = nm11 * cosX + nm21 * sinX;
        dest.m12 = nm12 * cosX + nm22 * sinX;
        dest.m20 = nm10 * m_sinX + nm20 * cosX;
        dest.m21 = nm11 * m_sinX + nm21 * cosX;
        dest.m22 = nm12 * m_sinX + nm22 * cosX;
        return dest;
    }

    public Matrix3f rotate(float ang, float x, float y, float z) {
        return this.rotate(ang, x, y, z, this);
    }

    public Matrix3f rotate(float ang, float x, float y, float z, Matrix3f dest) {
        float s = (float)Math.sin(ang);
        float c = (float)Math.cos(ang);
        float C = 1.0f - c;
        float xx = x * x;
        float xy = x * y;
        float xz = x * z;
        float yy = y * y;
        float yz = y * z;
        float zz = z * z;
        float rm00 = xx * C + c;
        float rm01 = xy * C + z * s;
        float rm02 = xz * C - y * s;
        float rm10 = xy * C - z * s;
        float rm11 = yy * C + c;
        float rm12 = yz * C + x * s;
        float rm20 = xz * C + y * s;
        float rm21 = yz * C - x * s;
        float rm22 = zz * C + c;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        return dest;
    }

    public Matrix3f rotateLocal(float ang, float x, float y, float z, Matrix3f dest) {
        float s = (float)Math.sin(ang);
        float c = (float)Math.cos(ang);
        float C = 1.0f - c;
        float xx = x * x;
        float xy = x * y;
        float xz = x * z;
        float yy = y * y;
        float yz = y * z;
        float zz = z * z;
        float lm00 = xx * C + c;
        float lm01 = xy * C + z * s;
        float lm02 = xz * C - y * s;
        float lm10 = xy * C - z * s;
        float lm11 = yy * C + c;
        float lm12 = yz * C + x * s;
        float lm20 = xz * C + y * s;
        float lm21 = yz * C - x * s;
        float lm22 = zz * C + c;
        float nm00 = lm00 * this.m00 + lm10 * this.m01 + lm20 * this.m02;
        float nm01 = lm01 * this.m00 + lm11 * this.m01 + lm21 * this.m02;
        float nm02 = lm02 * this.m00 + lm12 * this.m01 + lm22 * this.m02;
        float nm10 = lm00 * this.m10 + lm10 * this.m11 + lm20 * this.m12;
        float nm11 = lm01 * this.m10 + lm11 * this.m11 + lm21 * this.m12;
        float nm12 = lm02 * this.m10 + lm12 * this.m11 + lm22 * this.m12;
        float nm20 = lm00 * this.m20 + lm10 * this.m21 + lm20 * this.m22;
        float nm21 = lm01 * this.m20 + lm11 * this.m21 + lm21 * this.m22;
        float nm22 = lm02 * this.m20 + lm12 * this.m21 + lm22 * this.m22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3f rotateLocal(float ang, float x, float y, float z) {
        return this.rotateLocal(ang, x, y, z, this);
    }

    public Matrix3f rotate(Quaternionf quat) {
        return this.rotate(quat, this);
    }

    public Matrix3f rotate(Quaternionf quat, Matrix3f dest) {
        float dqx = quat.x + quat.x;
        float dqy = quat.y + quat.y;
        float dqz = quat.z + quat.z;
        float q00 = dqx * quat.x;
        float q11 = dqy * quat.y;
        float q22 = dqz * quat.z;
        float q01 = dqx * quat.y;
        float q02 = dqx * quat.z;
        float q03 = dqx * quat.w;
        float q12 = dqy * quat.z;
        float q13 = dqy * quat.w;
        float q23 = dqz * quat.w;
        float rm00 = 1.0f - q11 - q22;
        float rm01 = q01 + q23;
        float rm02 = q02 - q13;
        float rm10 = q01 - q23;
        float rm11 = 1.0f - q22 - q00;
        float rm12 = q12 + q03;
        float rm20 = q02 + q13;
        float rm21 = q12 - q03;
        float rm22 = 1.0f - q11 - q00;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        return dest;
    }

    public Matrix3f rotateLocal(Quaternionf quat, Matrix3f dest) {
        float dqx = quat.x + quat.x;
        float dqy = quat.y + quat.y;
        float dqz = quat.z + quat.z;
        float q00 = dqx * quat.x;
        float q11 = dqy * quat.y;
        float q22 = dqz * quat.z;
        float q01 = dqx * quat.y;
        float q02 = dqx * quat.z;
        float q03 = dqx * quat.w;
        float q12 = dqy * quat.z;
        float q13 = dqy * quat.w;
        float q23 = dqz * quat.w;
        float lm00 = 1.0f - q11 - q22;
        float lm01 = q01 + q23;
        float lm02 = q02 - q13;
        float lm10 = q01 - q23;
        float lm11 = 1.0f - q22 - q00;
        float lm12 = q12 + q03;
        float lm20 = q02 + q13;
        float lm21 = q12 - q03;
        float lm22 = 1.0f - q11 - q00;
        float nm00 = lm00 * this.m00 + lm10 * this.m01 + lm20 * this.m02;
        float nm01 = lm01 * this.m00 + lm11 * this.m01 + lm21 * this.m02;
        float nm02 = lm02 * this.m00 + lm12 * this.m01 + lm22 * this.m02;
        float nm10 = lm00 * this.m10 + lm10 * this.m11 + lm20 * this.m12;
        float nm11 = lm01 * this.m10 + lm11 * this.m11 + lm21 * this.m12;
        float nm12 = lm02 * this.m10 + lm12 * this.m11 + lm22 * this.m12;
        float nm20 = lm00 * this.m20 + lm10 * this.m21 + lm20 * this.m22;
        float nm21 = lm01 * this.m20 + lm11 * this.m21 + lm21 * this.m22;
        float nm22 = lm02 * this.m20 + lm12 * this.m21 + lm22 * this.m22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3f rotateLocal(Quaternionf quat) {
        return this.rotateLocal(quat, this);
    }

    public Matrix3f rotate(AxisAngle4f axisAngle) {
        return this.rotate(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Matrix3f rotate(AxisAngle4f axisAngle, Matrix3f dest) {
        return this.rotate(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z, dest);
    }

    public Matrix3f rotate(float angle, Vector3f axis) {
        return this.rotate(angle, axis.x, axis.y, axis.z);
    }

    public Matrix3f rotate(float angle, Vector3f axis, Matrix3f dest) {
        return this.rotate(angle, axis.x, axis.y, axis.z, dest);
    }

    public Matrix3f lookAlong(Vector3f dir, Vector3f up) {
        return this.lookAlong(dir.x, dir.y, dir.z, up.x, up.y, up.z, this);
    }

    public Matrix3f lookAlong(Vector3f dir, Vector3f up, Matrix3f dest) {
        return this.lookAlong(dir.x, dir.y, dir.z, up.x, up.y, up.z, dest);
    }

    public Matrix3f lookAlong(float dirX, float dirY, float dirZ, float upX, float upY, float upZ, Matrix3f dest) {
        float invDirLength = (float)(1.0 / Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ));
        float dirnX = dirX * invDirLength;
        float dirnY = dirY * invDirLength;
        float dirnZ = dirZ * invDirLength;
        float rightX = dirnY * upZ - dirnZ * upY;
        float rightY = dirnZ * upX - dirnX * upZ;
        float rightZ = dirnX * upY - dirnY * upX;
        float invRightLength = (float)(1.0 / Math.sqrt(rightX * rightX + rightY * rightY + rightZ * rightZ));
        float upnX = (rightY *= invRightLength) * dirnZ - (rightZ *= invRightLength) * dirnY;
        float upnY = rightZ * dirnX - (rightX *= invRightLength) * dirnZ;
        float upnZ = rightX * dirnY - rightY * dirnX;
        float rm00 = rightX;
        float rm01 = upnX;
        float rm02 = -dirnX;
        float rm10 = rightY;
        float rm11 = upnY;
        float rm12 = -dirnY;
        float rm20 = rightZ;
        float rm21 = upnZ;
        float rm22 = -dirnZ;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        return dest;
    }

    public Matrix3f lookAlong(float dirX, float dirY, float dirZ, float upX, float upY, float upZ) {
        return this.lookAlong(dirX, dirY, dirZ, upX, upY, upZ, this);
    }

    public Matrix3f setLookAlong(Vector3f dir, Vector3f up) {
        return this.setLookAlong(dir.x, dir.y, dir.z, up.x, up.y, up.z);
    }

    public Matrix3f setLookAlong(float dirX, float dirY, float dirZ, float upX, float upY, float upZ) {
        float invDirLength = (float)(1.0 / Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ));
        float dirnX = dirX * invDirLength;
        float dirnY = dirY * invDirLength;
        float dirnZ = dirZ * invDirLength;
        float rightX = dirnY * upZ - dirnZ * upY;
        float rightY = dirnZ * upX - dirnX * upZ;
        float rightZ = dirnX * upY - dirnY * upX;
        float invRightLength = (float)(1.0 / Math.sqrt(rightX * rightX + rightY * rightY + rightZ * rightZ));
        float upnX = (rightY *= invRightLength) * dirnZ - (rightZ *= invRightLength) * dirnY;
        float upnY = rightZ * dirnX - (rightX *= invRightLength) * dirnZ;
        float upnZ = rightX * dirnY - rightY * dirnX;
        this.m00 = rightX;
        this.m01 = upnX;
        this.m02 = -dirnX;
        this.m10 = rightY;
        this.m11 = upnY;
        this.m12 = -dirnY;
        this.m20 = rightZ;
        this.m21 = upnZ;
        this.m22 = -dirnZ;
        return this;
    }

    public Vector3f getRow(int row, Vector3f dest) throws IndexOutOfBoundsException {
        switch (row) {
            case 0: {
                dest.x = this.m00;
                dest.y = this.m10;
                dest.z = this.m20;
                break;
            }
            case 1: {
                dest.x = this.m01;
                dest.y = this.m11;
                dest.z = this.m21;
                break;
            }
            case 2: {
                dest.x = this.m02;
                dest.y = this.m12;
                dest.z = this.m22;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return dest;
    }

    public Vector3f getColumn(int column, Vector3f dest) throws IndexOutOfBoundsException {
        switch (column) {
            case 0: {
                dest.x = this.m00;
                dest.y = this.m01;
                dest.z = this.m02;
                break;
            }
            case 1: {
                dest.x = this.m10;
                dest.y = this.m11;
                dest.z = this.m12;
                break;
            }
            case 2: {
                dest.x = this.m20;
                dest.y = this.m21;
                dest.z = this.m22;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return dest;
    }

    public Matrix3f normal() {
        return this.normal(this);
    }

    public Matrix3f normal(Matrix3f dest) {
        float det = this.determinant();
        float s = 1.0f / det;
        dest.set((this.m11 * this.m22 - this.m21 * this.m12) * s, (this.m20 * this.m12 - this.m10 * this.m22) * s, (this.m10 * this.m21 - this.m20 * this.m11) * s, (this.m21 * this.m02 - this.m01 * this.m22) * s, (this.m00 * this.m22 - this.m20 * this.m02) * s, (this.m20 * this.m01 - this.m00 * this.m21) * s, (this.m01 * this.m12 - this.m11 * this.m02) * s, (this.m10 * this.m02 - this.m00 * this.m12) * s, (this.m00 * this.m11 - this.m10 * this.m01) * s);
        return dest;
    }

    public Vector3f getScale(Vector3f dest) {
        dest.x = (float)Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        dest.y = (float)Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        dest.z = (float)Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        return dest;
    }

    public Vector3f positiveZ(Vector3f dir) {
        dir.x = this.m10 * this.m21 - this.m11 * this.m20;
        dir.y = this.m20 * this.m01 - this.m21 * this.m00;
        dir.z = this.m00 * this.m11 - this.m01 * this.m10;
        dir.normalize();
        return dir;
    }

    public Vector3f normalizedPositiveZ(Vector3f dir) {
        dir.x = this.m02;
        dir.y = this.m12;
        dir.z = this.m22;
        return dir;
    }

    public Vector3f positiveX(Vector3f dir) {
        dir.x = this.m11 * this.m22 - this.m12 * this.m21;
        dir.y = this.m02 * this.m21 - this.m01 * this.m22;
        dir.z = this.m01 * this.m12 - this.m02 * this.m11;
        dir.normalize();
        return dir;
    }

    public Vector3f normalizedPositiveX(Vector3f dir) {
        dir.x = this.m00;
        dir.y = this.m10;
        dir.z = this.m20;
        return dir;
    }

    public Vector3f positiveY(Vector3f dir) {
        dir.x = this.m12 * this.m20 - this.m10 * this.m22;
        dir.y = this.m00 * this.m22 - this.m02 * this.m20;
        dir.z = this.m02 * this.m10 - this.m00 * this.m12;
        dir.normalize();
        return dir;
    }

    public Vector3f normalizedPositiveY(Vector3f dir) {
        dir.x = this.m01;
        dir.y = this.m11;
        dir.z = this.m21;
        return dir;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.m00);
        result = 31 * result + Float.floatToIntBits(this.m01);
        result = 31 * result + Float.floatToIntBits(this.m02);
        result = 31 * result + Float.floatToIntBits(this.m10);
        result = 31 * result + Float.floatToIntBits(this.m11);
        result = 31 * result + Float.floatToIntBits(this.m12);
        result = 31 * result + Float.floatToIntBits(this.m20);
        result = 31 * result + Float.floatToIntBits(this.m21);
        result = 31 * result + Float.floatToIntBits(this.m22);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Matrix3f other = (Matrix3f)obj;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(other.m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(other.m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m02) != Float.floatToIntBits(other.m02)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(other.m10)) {
            return false;
        }
        if (Float.floatToIntBits(this.m11) != Float.floatToIntBits(other.m11)) {
            return false;
        }
        if (Float.floatToIntBits(this.m12) != Float.floatToIntBits(other.m12)) {
            return false;
        }
        if (Float.floatToIntBits(this.m20) != Float.floatToIntBits(other.m20)) {
            return false;
        }
        if (Float.floatToIntBits(this.m21) != Float.floatToIntBits(other.m21)) {
            return false;
        }
        return Float.floatToIntBits(this.m22) == Float.floatToIntBits(other.m22);
    }

    public Matrix3f swap(Matrix3f other) {
        float tmp = this.m00;
        this.m00 = other.m00;
        other.m00 = tmp;
        tmp = this.m01;
        this.m01 = other.m01;
        other.m01 = tmp;
        tmp = this.m02;
        this.m02 = other.m02;
        other.m02 = tmp;
        tmp = this.m10;
        this.m10 = other.m10;
        other.m10 = tmp;
        tmp = this.m11;
        this.m11 = other.m11;
        other.m11 = tmp;
        tmp = this.m12;
        this.m12 = other.m12;
        other.m12 = tmp;
        tmp = this.m20;
        this.m20 = other.m20;
        other.m20 = tmp;
        tmp = this.m21;
        this.m21 = other.m21;
        other.m21 = tmp;
        tmp = this.m22;
        this.m22 = other.m22;
        other.m22 = tmp;
        return this;
    }
}

