/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Matrix3d;
import org.joml.Matrix3f;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4x3f;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class AxisAngle4f
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public float angle;
    public float x;
    public float y;
    public float z;

    public AxisAngle4f() {
        this.z = 1.0f;
    }

    public AxisAngle4f(AxisAngle4f a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
        this.angle = (float)(((double)a.angle < 0.0 ? Math.PI * 2 + (double)a.angle % (Math.PI * 2) : (double)a.angle) % (Math.PI * 2));
    }

    public AxisAngle4f(Quaternionf q) {
        float acos = (float)Math.acos(q.w);
        float invSqrt = (float)(1.0 / Math.sqrt(1.0 - (double)(q.w * q.w)));
        this.x = q.x * invSqrt;
        this.y = q.y * invSqrt;
        this.z = q.z * invSqrt;
        this.angle = acos + acos;
    }

    public AxisAngle4f(float angle, float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.angle = (float)(((double)angle < 0.0 ? Math.PI * 2 + (double)angle % (Math.PI * 2) : (double)angle) % (Math.PI * 2));
    }

    public AxisAngle4f(float angle, Vector3f v) {
        this(angle, v.x, v.y, v.z);
    }

    public AxisAngle4f set(AxisAngle4f a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
        this.angle = a.angle;
        this.angle = (float)(((double)this.angle < 0.0 ? Math.PI * 2 + (double)this.angle % (Math.PI * 2) : (double)this.angle) % (Math.PI * 2));
        return this;
    }

    public AxisAngle4f set(float angle, float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.angle = (float)(((double)angle < 0.0 ? Math.PI * 2 + (double)angle % (Math.PI * 2) : (double)angle) % (Math.PI * 2));
        return this;
    }

    public AxisAngle4f set(float angle, Vector3f v) {
        return this.set(angle, v.x, v.y, v.z);
    }

    public AxisAngle4f set(Quaternionf q) {
        double acos = Math.acos(q.w);
        double invSqrt = 1.0 / Math.sqrt(1.0 - (double)(q.w * q.w));
        this.x = (float)((double)q.x * invSqrt);
        this.y = (float)((double)q.y * invSqrt);
        this.z = (float)((double)q.z * invSqrt);
        this.angle = (float)(acos + acos);
        return this;
    }

    public AxisAngle4f set(Quaterniond q) {
        double acos = Math.acos(q.w);
        double invSqrt = 1.0 / Math.sqrt(1.0 - q.w * q.w);
        this.x = (float)(q.x * invSqrt);
        this.y = (float)(q.y * invSqrt);
        this.z = (float)(q.z * invSqrt);
        this.angle = (float)(acos + acos);
        return this;
    }

    public AxisAngle4f set(Matrix3f m) {
        double cos = ((double)(m.m00 + m.m11 + m.m22) - 1.0) * 0.5;
        this.x = m.m12 - m.m21;
        this.y = m.m20 - m.m02;
        this.z = m.m01 - m.m10;
        double sin = 0.5 * Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.angle = (float)Math.atan2(sin, cos);
        return this;
    }

    public AxisAngle4f set(Matrix3d m) {
        double cos = (m.m00 + m.m11 + m.m22 - 1.0) * 0.5;
        this.x = (float)(m.m12 - m.m21);
        this.y = (float)(m.m20 - m.m02);
        this.z = (float)(m.m01 - m.m10);
        double sin = 0.5 * Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.angle = (float)Math.atan2(sin, cos);
        return this;
    }

    public AxisAngle4f set(Matrix4f m) {
        double cos = ((double)(m.m00() + m.m11() + m.m22()) - 1.0) * 0.5;
        this.x = m.m12() - m.m21();
        this.y = m.m20() - m.m02();
        this.z = m.m01() - m.m10();
        double sin = 0.5 * Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.angle = (float)Math.atan2(sin, cos);
        return this;
    }

    public AxisAngle4f set(Matrix4x3f m) {
        double cos = ((double)(m.m00() + m.m11() + m.m22()) - 1.0) * 0.5;
        this.x = m.m12() - m.m21();
        this.y = m.m20() - m.m02();
        this.z = m.m01() - m.m10();
        double sin = 0.5 * Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.angle = (float)Math.atan2(sin, cos);
        return this;
    }

    public AxisAngle4f set(Matrix4d m) {
        double cos = (m.m00() + m.m11() + m.m22() - 1.0) * 0.5;
        this.x = (float)(m.m12() - m.m21());
        this.y = (float)(m.m20() - m.m02());
        this.z = (float)(m.m01() - m.m10());
        double sin = 0.5 * Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.angle = (float)Math.atan2(sin, cos);
        return this;
    }

    public Quaternionf get(Quaternionf q) {
        return q.set(this);
    }

    public Quaterniond get(Quaterniond q) {
        return q.set(this);
    }

    public Matrix4f get(Matrix4f m) {
        return m.set(this);
    }

    public Matrix3f get(Matrix3f m) {
        return m.set(this);
    }

    public Matrix4d get(Matrix4d m) {
        return m.set(this);
    }

    public Matrix3d get(Matrix3d m) {
        return m.set(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.angle);
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.angle = in.readFloat();
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.z = in.readFloat();
    }

    public AxisAngle4f normalize() {
        float invLength = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z));
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
        return this;
    }

    public AxisAngle4f rotate(float ang) {
        this.angle += ang;
        this.angle = (float)(((double)this.angle < 0.0 ? Math.PI * 2 + (double)this.angle % (Math.PI * 2) : (double)this.angle) % (Math.PI * 2));
        return this;
    }

    public Vector3f transform(Vector3f v) {
        return this.transform(v, v);
    }

    public Vector3f transform(Vector3f v, Vector3f dest) {
        double cos = Math.cos(this.angle);
        double sin = Math.sin(this.angle);
        float dot = this.x * v.x + this.y * v.y + this.z * v.z;
        dest.set((float)((double)v.x * cos + sin * (double)(this.y * v.z - this.z * v.y) + (1.0 - cos) * (double)dot * (double)this.x), (float)((double)v.y * cos + sin * (double)(this.z * v.x - this.x * v.z) + (1.0 - cos) * (double)dot * (double)this.y), (float)((double)v.z * cos + sin * (double)(this.x * v.y - this.y * v.x) + (1.0 - cos) * (double)dot * (double)this.z));
        return dest;
    }

    public Vector4f transform(Vector4f v) {
        return this.transform(v, v);
    }

    public Vector4f transform(Vector4f v, Vector4f dest) {
        double cos = Math.cos(this.angle);
        double sin = Math.sin(this.angle);
        float dot = this.x * v.x + this.y * v.y + this.z * v.z;
        dest.set((float)((double)v.x * cos + sin * (double)(this.y * v.z - this.z * v.y) + (1.0 - cos) * (double)dot * (double)this.x), (float)((double)v.y * cos + sin * (double)(this.z * v.x - this.x * v.z) + (1.0 - cos) * (double)dot * (double)this.y), (float)((double)v.z * cos + sin * (double)(this.x * v.y - this.y * v.x) + (1.0 - cos) * (double)dot * (double)this.z), dest.w);
        return dest;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat(" 0.000E0;-");
        return this.toString(formatter).replaceAll("E(\\d+)", "E+$1");
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + formatter.format(this.y) + formatter.format(this.z) + " <|" + formatter.format(this.angle) + " )";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        float nangle = (float)(((double)this.angle < 0.0 ? Math.PI * 2 + (double)this.angle % (Math.PI * 2) : (double)this.angle) % (Math.PI * 2));
        result = 31 * result + Float.floatToIntBits(nangle);
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AxisAngle4f other = (AxisAngle4f)obj;
        float nangle = (float)(((double)this.angle < 0.0 ? Math.PI * 2 + (double)this.angle % (Math.PI * 2) : (double)this.angle) % (Math.PI * 2));
        float nangleOther = (float)(((double)other.angle < 0.0 ? Math.PI * 2 + (double)other.angle % (Math.PI * 2) : (double)other.angle) % (Math.PI * 2));
        if (Float.floatToIntBits(nangle) != Float.floatToIntBits(nangleOther)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }
}

