/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkImageResolve
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCSUBRESOURCE;
    public static final int SRCOFFSET;
    public static final int DSTSUBRESOURCE;
    public static final int DSTOFFSET;
    public static final int EXTENT;

    VkImageResolve(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkImageResolve(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageResolve.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkImageSubresourceLayers srcSubresource() {
        return VkImageResolve.nsrcSubresource(this.address());
    }

    public VkOffset3D srcOffset() {
        return VkImageResolve.nsrcOffset(this.address());
    }

    public VkImageSubresourceLayers dstSubresource() {
        return VkImageResolve.ndstSubresource(this.address());
    }

    public VkOffset3D dstOffset() {
        return VkImageResolve.ndstOffset(this.address());
    }

    public VkExtent3D extent() {
        return VkImageResolve.nextent(this.address());
    }

    public VkImageResolve srcSubresource(VkImageSubresourceLayers value) {
        VkImageResolve.nsrcSubresource(this.address(), value);
        return this;
    }

    public VkImageResolve srcOffset(VkOffset3D value) {
        VkImageResolve.nsrcOffset(this.address(), value);
        return this;
    }

    public VkImageResolve dstSubresource(VkImageSubresourceLayers value) {
        VkImageResolve.ndstSubresource(this.address(), value);
        return this;
    }

    public VkImageResolve dstOffset(VkOffset3D value) {
        VkImageResolve.ndstOffset(this.address(), value);
        return this;
    }

    public VkImageResolve extent(VkExtent3D value) {
        VkImageResolve.nextent(this.address(), value);
        return this;
    }

    public VkImageResolve set(VkImageSubresourceLayers srcSubresource, VkOffset3D srcOffset, VkImageSubresourceLayers dstSubresource, VkOffset3D dstOffset, VkExtent3D extent) {
        this.srcSubresource(srcSubresource);
        this.srcOffset(srcOffset);
        this.dstSubresource(dstSubresource);
        this.dstOffset(dstOffset);
        this.extent(extent);
        return this;
    }

    public VkImageResolve nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkImageResolve set(VkImageResolve src) {
        return this.nset(src.address());
    }

    public static VkImageResolve malloc() {
        return VkImageResolve.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkImageResolve calloc() {
        return VkImageResolve.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkImageResolve create() {
        return new VkImageResolve(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageResolve create(long address) {
        return address == 0L ? null : new VkImageResolve(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkImageResolve.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageResolve.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkImageResolve mallocStack() {
        return VkImageResolve.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageResolve callocStack() {
        return VkImageResolve.callocStack(MemoryStack.stackGet());
    }

    public static VkImageResolve mallocStack(MemoryStack stack) {
        return VkImageResolve.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageResolve callocStack(MemoryStack stack) {
        return VkImageResolve.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageResolve.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageResolve.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageResolve.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageResolve.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkImageSubresourceLayers nsrcSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)SRCSUBRESOURCE);
    }

    public static VkOffset3D nsrcOffset(long struct) {
        return VkOffset3D.create(struct + (long)SRCOFFSET);
    }

    public static VkImageSubresourceLayers ndstSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)DSTSUBRESOURCE);
    }

    public static VkOffset3D ndstOffset(long struct) {
        return VkOffset3D.create(struct + (long)DSTOFFSET);
    }

    public static VkExtent3D nextent(long struct) {
        return VkExtent3D.create(struct + (long)EXTENT);
    }

    public static void nsrcSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCSUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void nsrcOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCOFFSET, VkOffset3D.SIZEOF);
    }

    public static void ndstSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTSUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void ndstOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTOFFSET, VkOffset3D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, VkExtent3D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageResolve.__struct(VkImageResolve.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkImageResolve.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkImageResolve.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkImageResolve.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkImageResolve.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCSUBRESOURCE = layout.offsetof(0);
        SRCOFFSET = layout.offsetof(1);
        DSTSUBRESOURCE = layout.offsetof(2);
        DSTOFFSET = layout.offsetof(3);
        EXTENT = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<VkImageResolve, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageResolve newInstance(long address) {
            return new VkImageResolve(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public VkImageSubresourceLayers srcSubresource() {
            return VkImageResolve.nsrcSubresource(this.address());
        }

        public VkOffset3D srcOffset() {
            return VkImageResolve.nsrcOffset(this.address());
        }

        public VkImageSubresourceLayers dstSubresource() {
            return VkImageResolve.ndstSubresource(this.address());
        }

        public VkOffset3D dstOffset() {
            return VkImageResolve.ndstOffset(this.address());
        }

        public VkExtent3D extent() {
            return VkImageResolve.nextent(this.address());
        }

        public Buffer srcSubresource(VkImageSubresourceLayers value) {
            VkImageResolve.nsrcSubresource(this.address(), value);
            return this;
        }

        public Buffer srcOffset(VkOffset3D value) {
            VkImageResolve.nsrcOffset(this.address(), value);
            return this;
        }

        public Buffer dstSubresource(VkImageSubresourceLayers value) {
            VkImageResolve.ndstSubresource(this.address(), value);
            return this;
        }

        public Buffer dstOffset(VkOffset3D value) {
            VkImageResolve.ndstOffset(this.address(), value);
            return this;
        }

        public Buffer extent(VkExtent3D value) {
            VkImageResolve.nextent(this.address(), value);
            return this;
        }
    }
}

