/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFenceCreateInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;

    VkFenceCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkFenceCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkFenceCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkFenceCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkFenceCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkFenceCreateInfo.nflags(this.address());
    }

    public VkFenceCreateInfo sType(int value) {
        VkFenceCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkFenceCreateInfo pNext(long value) {
        VkFenceCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkFenceCreateInfo flags(int value) {
        VkFenceCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkFenceCreateInfo set(int sType, long pNext, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        return this;
    }

    public VkFenceCreateInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkFenceCreateInfo set(VkFenceCreateInfo src) {
        return this.nset(src.address());
    }

    public static VkFenceCreateInfo malloc() {
        return VkFenceCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkFenceCreateInfo calloc() {
        return VkFenceCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkFenceCreateInfo create() {
        return new VkFenceCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkFenceCreateInfo create(long address) {
        return address == 0L ? null : new VkFenceCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkFenceCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkFenceCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkFenceCreateInfo mallocStack() {
        return VkFenceCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkFenceCreateInfo callocStack() {
        return VkFenceCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkFenceCreateInfo mallocStack(MemoryStack stack) {
        return VkFenceCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkFenceCreateInfo callocStack(MemoryStack stack) {
        return VkFenceCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkFenceCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkFenceCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkFenceCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkFenceCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkFenceCreateInfo.__struct(VkFenceCreateInfo.__member(4), VkFenceCreateInfo.__member(POINTER_SIZE), VkFenceCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<VkFenceCreateInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkFenceCreateInfo newInstance(long address) {
            return new VkFenceCreateInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkFenceCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkFenceCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkFenceCreateInfo.nflags(this.address());
        }

        public Buffer sType(int value) {
            VkFenceCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkFenceCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkFenceCreateInfo.nflags(this.address(), value);
            return this;
        }
    }
}

