/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLDebugMessageKHRCallbackI;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class KHRDebug {
    public static final int GL_DEBUG_OUTPUT_KHR = 37600;
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR = 33346;
    public static final int GL_CONTEXT_FLAG_DEBUG_BIT_KHR = 2;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_KHR = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_KHR = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_KHR = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR = 33347;
    public static final int GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR = 33388;
    public static final int GL_DEBUG_GROUP_STACK_DEPTH_KHR = 33389;
    public static final int GL_MAX_LABEL_LENGTH_KHR = 33512;
    public static final int GL_DEBUG_CALLBACK_FUNCTION_KHR = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM_KHR = 33349;
    public static final int GL_DEBUG_SOURCE_API_KHR = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER_KHR = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY_KHR = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION_KHR = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER_KHR = 33355;
    public static final int GL_DEBUG_TYPE_ERROR_KHR = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY_KHR = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE_KHR = 33360;
    public static final int GL_DEBUG_TYPE_OTHER_KHR = 33361;
    public static final int GL_DEBUG_TYPE_MARKER_KHR = 33384;
    public static final int GL_DEBUG_TYPE_PUSH_GROUP_KHR = 33385;
    public static final int GL_DEBUG_TYPE_POP_GROUP_KHR = 33386;
    public static final int GL_DEBUG_SEVERITY_HIGH_KHR = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_KHR = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_KHR = 37192;
    public static final int GL_DEBUG_SEVERITY_NOTIFICATION_KHR = 33387;
    public static final int GL_STACK_UNDERFLOW_KHR = 1284;
    public static final int GL_STACK_OVERFLOW_KHR = 1283;
    public static final int GL_BUFFER_KHR = 33504;
    public static final int GL_SHADER_KHR = 33505;
    public static final int GL_PROGRAM_KHR = 33506;
    public static final int GL_QUERY_KHR = 33507;
    public static final int GL_PROGRAM_PIPELINE_KHR = 33508;
    public static final int GL_SAMPLER_KHR = 33510;

    protected KHRDebug() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glDebugMessageControlKHR, caps.glDebugMessageInsertKHR, caps.glDebugMessageCallbackKHR, caps.glGetDebugMessageLogKHR, caps.glGetPointervKHR, caps.glPushDebugGroupKHR, caps.glPopDebugGroupKHR, caps.glObjectLabelKHR, caps.glGetObjectLabelKHR, caps.glObjectPtrLabelKHR, caps.glGetObjectPtrLabelKHR);
    }

    public static void nglDebugMessageControlKHR(int source, int type, int severity, int count, long ids, boolean enabled) {
        long __functionAddress = GLES.getCapabilities().glDebugMessageControlKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, source, type, severity, count, ids, enabled);
    }

    public static void glDebugMessageControlKHR(int source, int type, int severity, IntBuffer ids, boolean enabled) {
        KHRDebug.nglDebugMessageControlKHR(source, type, severity, ids == null ? 0 : ids.remaining(), MemoryUtil.memAddressSafe(ids), enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageControlKHR(int source, int type, int severity, int id, boolean enabled) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            KHRDebug.nglDebugMessageControlKHR(source, type, severity, 1, MemoryUtil.memAddress(ids), enabled);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDebugMessageInsertKHR(int source, int type, int id, int severity, int length, long message) {
        long __functionAddress = GLES.getCapabilities().glDebugMessageInsertKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, source, type, id, severity, length, message);
    }

    public static void glDebugMessageInsertKHR(int source, int type, int id, int severity, ByteBuffer message) {
        KHRDebug.nglDebugMessageInsertKHR(source, type, id, severity, message.remaining(), MemoryUtil.memAddress(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageInsertKHR(int source, int type, int id, int severity, CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message, false);
            int messageEncodedLen = messageEncoded.capacity();
            KHRDebug.nglDebugMessageInsertKHR(source, type, id, severity, messageEncodedLen, MemoryUtil.memAddress(messageEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDebugMessageCallbackKHR(long callback, long userParam) {
        long __functionAddress = GLES.getCapabilities().glDebugMessageCallbackKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, callback, userParam);
    }

    public static void glDebugMessageCallbackKHR(GLDebugMessageKHRCallbackI callback, long userParam) {
        KHRDebug.nglDebugMessageCallbackKHR(callback == null ? 0L : callback.address(), userParam);
    }

    public static int nglGetDebugMessageLogKHR(int count, int bufsize, long sources, long types, long ids, long severities, long lengths, long messageLog) {
        long __functionAddress = GLES.getCapabilities().glGetDebugMessageLogKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPPPPPPI(__functionAddress, count, bufsize, sources, types, ids, severities, lengths, messageLog);
    }

    public static int glGetDebugMessageLogKHR(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            if (sources != null) {
                Checks.checkBuffer((Buffer)sources, count);
            }
            if (types != null) {
                Checks.checkBuffer((Buffer)types, count);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count);
            }
        }
        return KHRDebug.nglGetDebugMessageLogKHR(count, messageLog == null ? 0 : messageLog.remaining(), MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static void nglGetPointervKHR(int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetPointervKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, pname, params);
    }

    public static void glGetPointervKHR(int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        KHRDebug.nglGetPointervKHR(pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetPointerKHR(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            KHRDebug.nglGetPointervKHR(pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglPushDebugGroupKHR(int source, int id, int length, long message) {
        long __functionAddress = GLES.getCapabilities().glPushDebugGroupKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, source, id, length, message);
    }

    public static void glPushDebugGroupKHR(int source, int id, ByteBuffer message) {
        KHRDebug.nglPushDebugGroupKHR(source, id, message.remaining(), MemoryUtil.memAddress(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glPushDebugGroupKHR(int source, int id, CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message, false);
            int messageEncodedLen = messageEncoded.capacity();
            KHRDebug.nglPushDebugGroupKHR(source, id, messageEncodedLen, MemoryUtil.memAddress(messageEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glPopDebugGroupKHR() {
        long __functionAddress = GLES.getCapabilities().glPopDebugGroupKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static void nglObjectLabelKHR(int identifier, int name, int length, long label) {
        long __functionAddress = GLES.getCapabilities().glObjectLabelKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, identifier, name, length, label);
    }

    public static void glObjectLabelKHR(int identifier, int name, ByteBuffer label) {
        KHRDebug.nglObjectLabelKHR(identifier, name, label.remaining(), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glObjectLabelKHR(int identifier, int name, CharSequence label) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            int labelEncodedLen = labelEncoded.capacity();
            KHRDebug.nglObjectLabelKHR(identifier, name, labelEncodedLen, MemoryUtil.memAddress(labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetObjectLabelKHR(int identifier, int name, int bufSize, long length, long label) {
        long __functionAddress = GLES.getCapabilities().glGetObjectLabelKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, identifier, name, bufSize, length, label);
    }

    public static void glGetObjectLabelKHR(int identifier, int name, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        KHRDebug.nglGetObjectLabelKHR(identifier, name, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectLabelKHR(int identifier, int name, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectLabelKHR(identifier, name, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
            String string = MemoryUtil.memUTF8(label, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectLabelKHR(int identifier, int name) {
        int bufSize = GLES20.glGetInteger(33512);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectLabelKHR(identifier, name, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
            String string = MemoryUtil.memUTF8(label, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglObjectPtrLabelKHR(long ptr, int length, long label) {
        long __functionAddress = GLES.getCapabilities().glObjectPtrLabelKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(ptr);
        }
        JNI.callPPV(__functionAddress, ptr, length, label);
    }

    public static void glObjectPtrLabelKHR(long ptr, ByteBuffer label) {
        KHRDebug.nglObjectPtrLabelKHR(ptr, label.remaining(), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glObjectPtrLabelKHR(long ptr, CharSequence label) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            int labelEncodedLen = labelEncoded.capacity();
            KHRDebug.nglObjectPtrLabelKHR(ptr, labelEncodedLen, MemoryUtil.memAddress(labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetObjectPtrLabelKHR(long ptr, int bufSize, long length, long label) {
        long __functionAddress = GLES.getCapabilities().glGetObjectPtrLabelKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(ptr);
        }
        JNI.callPPPV(__functionAddress, ptr, bufSize, length, label);
    }

    public static void glGetObjectPtrLabelKHR(long ptr, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        KHRDebug.nglGetObjectPtrLabelKHR(ptr, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectPtrLabelKHR(long ptr, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectPtrLabelKHR(ptr, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
            String string = MemoryUtil.memUTF8(label, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectPtrLabelKHR(long ptr) {
        int bufSize = GLES20.glGetInteger(33512);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectPtrLabelKHR(ptr, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
            String string = MemoryUtil.memUTF8(label, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDebugMessageControlKHR(int source, int type, int severity, int[] ids, boolean enabled) {
        long __functionAddress = GLES.getCapabilities().glDebugMessageControlKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, source, type, severity, ids == null ? 0 : ids.length, ids, enabled);
    }

    public static int glGetDebugMessageLogKHR(int count, int[] sources, int[] types, int[] ids, int[] severities, int[] lengths, ByteBuffer messageLog) {
        long __functionAddress = GLES.getCapabilities().glGetDebugMessageLogKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (sources != null) {
                Checks.checkBuffer(sources, count);
            }
            if (types != null) {
                Checks.checkBuffer(types, count);
            }
            if (ids != null) {
                Checks.checkBuffer(ids, count);
            }
            if (severities != null) {
                Checks.checkBuffer(severities, count);
            }
            if (lengths != null) {
                Checks.checkBuffer(lengths, count);
            }
        }
        return JNI.callPPPPPPI(__functionAddress, count, messageLog == null ? 0 : messageLog.remaining(), sources, types, ids, severities, lengths, MemoryUtil.memAddressSafe(messageLog));
    }

    public static void glGetObjectLabelKHR(int identifier, int name, int[] length, ByteBuffer label) {
        long __functionAddress = GLES.getCapabilities().glGetObjectLabelKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, identifier, name, label.remaining(), length, MemoryUtil.memAddress(label));
    }

    public static void glGetObjectPtrLabelKHR(long ptr, int[] length, ByteBuffer label) {
        long __functionAddress = GLES.getCapabilities().glGetObjectPtrLabelKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(ptr);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPPV(__functionAddress, ptr, label.remaining(), length, MemoryUtil.memAddress(label));
    }
}

