/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTDebugLabel {
    public static final int GL_BUFFER_OBJECT_EXT = 37201;
    public static final int GL_SHADER_OBJECT_EXT = 35656;
    public static final int GL_PROGRAM_OBJECT_EXT = 35648;
    public static final int GL_VERTEX_ARRAY_OBJECT_EXT = 37204;
    public static final int GL_QUERY_OBJECT_EXT = 37203;
    public static final int GL_PROGRAM_PIPELINE_OBJECT_EXT = 35407;

    protected EXTDebugLabel() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glLabelObjectEXT, caps.glGetObjectLabelEXT);
    }

    public static void nglLabelObjectEXT(int type, int object, int length, long label) {
        long __functionAddress = GLES.getCapabilities().glLabelObjectEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, type, object, length, label);
    }

    public static void glLabelObjectEXT(int type, int object, ByteBuffer label) {
        EXTDebugLabel.nglLabelObjectEXT(type, object, label.remaining(), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glLabelObjectEXT(int type, int object, CharSequence label) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            int labelEncodedLen = labelEncoded.capacity();
            EXTDebugLabel.nglLabelObjectEXT(type, object, labelEncodedLen, MemoryUtil.memAddress(labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetObjectLabelEXT(int type, int object, int bufSize, long length, long label) {
        long __functionAddress = GLES.getCapabilities().glGetObjectLabelEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, type, object, bufSize, length, label);
    }

    public static void glGetObjectLabelEXT(int type, int object, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        EXTDebugLabel.nglGetObjectLabelEXT(type, object, label.remaining(), MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectLabelEXT(int type, int object, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            EXTDebugLabel.nglGetObjectLabelEXT(type, object, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
            String string = MemoryUtil.memUTF8(label, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetObjectLabelEXT(int type, int object, int[] length, ByteBuffer label) {
        long __functionAddress = GLES.getCapabilities().glGetObjectLabelEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(length, 1);
        }
        JNI.callPPV(__functionAddress, type, object, label.remaining(), length, MemoryUtil.memAddress(label));
    }
}

