/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBBaseInstance {
    protected ARBBaseInstance() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glDrawArraysInstancedBaseInstance, caps.glDrawElementsInstancedBaseInstance, caps.glDrawElementsInstancedBaseVertexBaseInstance);
    }

    public static void glDrawArraysInstancedBaseInstance(int mode, int first, int count, int primcount, int baseinstance) {
        long __functionAddress = GL.getCapabilities().glDrawArraysInstancedBaseInstance;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, mode, first, count, primcount, baseinstance);
    }

    public static void nglDrawElementsInstancedBaseInstance(int mode, int count, int type, long indices, int primcount, int baseinstance) {
        long __functionAddress = GL.getCapabilities().glDrawElementsInstancedBaseInstance;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, int count, int type, long indices, int primcount, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, count, type, indices, primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, int type, ByteBuffer indices, int primcount, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, ByteBuffer indices, int primcount, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, ShortBuffer indices, int primcount, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, IntBuffer indices, int primcount, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void nglDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, long indices, int primcount, int basevertex, int baseinstance) {
        long __functionAddress = GL.getCapabilities().glDrawElementsInstancedBaseVertexBaseInstance;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, long indices, int primcount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, count, type, indices, primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int type, ByteBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, ByteBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, ShortBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, IntBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }
}

