/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CLBusAddressAMD
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SURFBUSADDRESS;
    public static final int SIGNALBUSADDRESS;

    CLBusAddressAMD(long address, ByteBuffer container) {
        super(address, container);
    }

    public CLBusAddressAMD(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), CLBusAddressAMD.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long surfbusaddress() {
        return CLBusAddressAMD.nsurfbusaddress(this.address());
    }

    public long signalbusaddress() {
        return CLBusAddressAMD.nsignalbusaddress(this.address());
    }

    public CLBusAddressAMD surfbusaddress(long value) {
        CLBusAddressAMD.nsurfbusaddress(this.address(), value);
        return this;
    }

    public CLBusAddressAMD signalbusaddress(long value) {
        CLBusAddressAMD.nsignalbusaddress(this.address(), value);
        return this;
    }

    public CLBusAddressAMD set(long surfbusaddress, long signalbusaddress) {
        this.surfbusaddress(surfbusaddress);
        this.signalbusaddress(signalbusaddress);
        return this;
    }

    public CLBusAddressAMD nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public CLBusAddressAMD set(CLBusAddressAMD src) {
        return this.nset(src.address());
    }

    public static CLBusAddressAMD malloc() {
        return CLBusAddressAMD.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static CLBusAddressAMD calloc() {
        return CLBusAddressAMD.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static CLBusAddressAMD create() {
        return new CLBusAddressAMD(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static CLBusAddressAMD create(long address) {
        return address == 0L ? null : new CLBusAddressAMD(address, null);
    }

    public static Buffer malloc(int capacity) {
        return CLBusAddressAMD.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLBusAddressAMD.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static CLBusAddressAMD mallocStack() {
        return CLBusAddressAMD.mallocStack(MemoryStack.stackGet());
    }

    public static CLBusAddressAMD callocStack() {
        return CLBusAddressAMD.callocStack(MemoryStack.stackGet());
    }

    public static CLBusAddressAMD mallocStack(MemoryStack stack) {
        return CLBusAddressAMD.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLBusAddressAMD callocStack(MemoryStack stack) {
        return CLBusAddressAMD.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CLBusAddressAMD.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CLBusAddressAMD.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLBusAddressAMD.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLBusAddressAMD.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsurfbusaddress(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SURFBUSADDRESS);
    }

    public static long nsignalbusaddress(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIGNALBUSADDRESS);
    }

    public static void nsurfbusaddress(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SURFBUSADDRESS, value);
    }

    public static void nsignalbusaddress(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SIGNALBUSADDRESS, value);
    }

    static {
        Struct.Layout layout = CLBusAddressAMD.__struct(CLBusAddressAMD.__member(8), CLBusAddressAMD.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SURFBUSADDRESS = layout.offsetof(0);
        SIGNALBUSADDRESS = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<CLBusAddressAMD, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected CLBusAddressAMD newInstance(long address) {
            return new CLBusAddressAMD(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long surfbusaddress() {
            return CLBusAddressAMD.nsurfbusaddress(this.address());
        }

        public long signalbusaddress() {
            return CLBusAddressAMD.nsignalbusaddress(this.address());
        }

        public Buffer surfbusaddress(long value) {
            CLBusAddressAMD.nsurfbusaddress(this.address(), value);
            return this;
        }

        public Buffer signalbusaddress(long value) {
            CLBusAddressAMD.nsignalbusaddress(this.address(), value);
            return this;
        }
    }
}

