/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLEventCallbackI;
import org.lwjgl.opencl.CLMemObjectDestructorCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class CL11 {
    public static final int CL_MISALIGNED_SUB_BUFFER_OFFSET = -13;
    public static final int CL_EXEC_STATUS_ERROR_FOR_EVENTS_IN_WAIT_LIST = -14;
    public static final int CL_INVALID_PROPERTY = -64;
    public static final int CL_VERSION_1_1 = 1;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_HALF = 4148;
    public static final int CL_DEVICE_HOST_UNIFIED_MEMORY = 4149;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_CHAR = 4150;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_SHORT = 4151;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_INT = 4152;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_LONG = 4153;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_FLOAT = 4154;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_DOUBLE = 4155;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_HALF = 4156;
    public static final int CL_DEVICE_OPENCL_C_VERSION = 4157;
    public static final int CL_FP_SOFT_FLOAT = 64;
    public static final int CL_CONTEXT_NUM_DEVICES = 4227;
    public static final int CL_Rx = 4282;
    public static final int CL_RGx = 4283;
    public static final int CL_RGBx = 4284;
    public static final int CL_MEM_ASSOCIATED_MEMOBJECT = 4359;
    public static final int CL_MEM_OFFSET = 4360;
    public static final int CL_ADDRESS_MIRRORED_REPEAT = 4404;
    public static final int CL_KERNEL_PREFERRED_WORK_GROUP_SIZE_MULTIPLE = 4531;
    public static final int CL_KERNEL_PRIVATE_MEM_SIZE = 4532;
    public static final int CL_EVENT_CONTEXT = 4564;
    public static final int CL_COMMAND_READ_BUFFER_RECT = 4609;
    public static final int CL_COMMAND_WRITE_BUFFER_RECT = 4610;
    public static final int CL_COMMAND_COPY_BUFFER_RECT = 4611;
    public static final int CL_COMMAND_USER = 4612;
    public static final int CL_BUFFER_CREATE_TYPE_REGION = 4640;

    protected CL11() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clCreateSubBuffer, caps.clSetMemObjectDestructorCallback, caps.clEnqueueReadBufferRect, caps.clEnqueueWriteBufferRect, caps.clEnqueueCopyBufferRect, caps.clCreateUserEvent, caps.clSetUserEventStatus, caps.clSetEventCallback);
    }

    public static long nclCreateSubBuffer(long buffer, long flags, int buffer_create_type, long buffer_create_info, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSubBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(buffer);
        }
        return JNI.callPJPPP(__functionAddress, buffer, flags, buffer_create_type, buffer_create_info, errcode_ret);
    }

    public static long clCreateSubBuffer(long buffer, long flags, int buffer_create_type, ByteBuffer buffer_create_info, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL11.nclCreateSubBuffer(buffer, flags, buffer_create_type, MemoryUtil.memAddress(buffer_create_info), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclSetMemObjectDestructorCallback(long memobj, long pfn_notify, long user_data) {
        long __functionAddress = CL.getICD().clSetMemObjectDestructorCallback;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(memobj);
        }
        return JNI.callPPPI(__functionAddress, memobj, pfn_notify, user_data);
    }

    public static int clSetMemObjectDestructorCallback(long memobj, CLMemObjectDestructorCallbackI pfn_notify, long user_data) {
        return CL11.nclSetMemObjectDestructorCallback(memobj, pfn_notify.address(), user_data);
    }

    public static int nclEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, long buffer_offset, long host_offset, long region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueReadBufferRect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
        }
        return JNI.callPPPPPPPPPPPPI(__functionAddress, command_queue, buffer, blocking_read, buffer_offset, host_offset, region, buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, ByteBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueReadBufferRect(command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, ShortBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueReadBufferRect(command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, IntBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueReadBufferRect(command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, FloatBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueReadBufferRect(command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, DoubleBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueReadBufferRect(command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, long buffer_offset, long host_offset, long region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBufferRect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
        }
        return JNI.callPPPPPPPPPPPPI(__functionAddress, command_queue, buffer, blocking_write, buffer_offset, host_offset, region, buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, ByteBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueWriteBufferRect(command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, ShortBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueWriteBufferRect(command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, IntBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueWriteBufferRect(command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, FloatBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueWriteBufferRect(command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, DoubleBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueWriteBufferRect(command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueCopyBufferRect(long command_queue, long src_buffer, long dst_buffer, long src_origin, long dst_origin, long region, long src_row_pitch, long src_slice_pitch, long dst_row_pitch, long dst_slice_pitch, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueCopyBufferRect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(src_buffer);
            Checks.checkPointer(dst_buffer);
        }
        return JNI.callPPPPPPPPPPPPI(__functionAddress, command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region, src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueCopyBufferRect(long command_queue, long src_buffer, long dst_buffer, PointerBuffer src_origin, PointerBuffer dst_origin, PointerBuffer region, long src_row_pitch, long src_slice_pitch, long dst_row_pitch, long dst_slice_pitch, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(src_origin, 3);
            Checks.checkBuffer(dst_origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueCopyBufferRect(command_queue, src_buffer, dst_buffer, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static long nclCreateUserEvent(long context, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateUserEvent;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return JNI.callPPP(__functionAddress, context, errcode_ret);
    }

    public static long clCreateUserEvent(long context, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL11.nclCreateUserEvent(context, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int clSetUserEventStatus(long event, int execution_status) {
        long __functionAddress = CL.getICD().clSetUserEventStatus;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(event);
        }
        return JNI.callPI(__functionAddress, event, execution_status);
    }

    public static int nclSetEventCallback(long event, int command_exec_callback_type, long pfn_notify, long user_data) {
        long __functionAddress = CL.getICD().clSetEventCallback;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(event);
        }
        return JNI.callPPPI(__functionAddress, event, command_exec_callback_type, pfn_notify, user_data);
    }

    public static int clSetEventCallback(long event, int command_exec_callback_type, CLEventCallbackI pfn_notify, long user_data) {
        return CL11.nclSetEventCallback(event, command_exec_callback_type, pfn_notify.address(), user_data);
    }

    public static long clCreateSubBuffer(long buffer, long flags, int buffer_create_type, ByteBuffer buffer_create_info, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSubBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(buffer);
            if (errcode_ret != null) {
                Checks.checkBuffer(errcode_ret, 1);
            }
        }
        return JNI.callPJPPP(__functionAddress, buffer, flags, buffer_create_type, MemoryUtil.memAddress(buffer_create_info), errcode_ret);
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, short[] ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadBufferRect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return JNI.callPPPPPPPPPPPPI(__functionAddress, command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, int[] ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadBufferRect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return JNI.callPPPPPPPPPPPPI(__functionAddress, command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, float[] ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadBufferRect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return JNI.callPPPPPPPPPPPPI(__functionAddress, command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, double[] ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadBufferRect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return JNI.callPPPPPPPPPPPPI(__functionAddress, command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, short[] ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBufferRect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return JNI.callPPPPPPPPPPPPI(__functionAddress, command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, int[] ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBufferRect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return JNI.callPPPPPPPPPPPPI(__functionAddress, command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, float[] ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBufferRect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return JNI.callPPPPPPPPPPPPI(__functionAddress, command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, double[] ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBufferRect;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return JNI.callPPPPPPPPPPPPI(__functionAddress, command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static long clCreateUserEvent(long context, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateUserEvent;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
            if (errcode_ret != null) {
                Checks.checkBuffer(errcode_ret, 1);
            }
        }
        return JNI.callPPP(__functionAddress, context, errcode_ret);
    }
}

