/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import org.joml.Matrix3d;
import org.joml.Matrix3f;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4x3d;
import org.joml.Matrix4x3f;
import sun.misc.Unsafe;

abstract class MemUtil {
    static final MemUtil INSTANCE = MemUtil.createInstance();

    MemUtil() {
    }

    private static final MemUtil createInstance() {
        MemUtil accessor;
        try {
            accessor = new MemUtilUnsafe();
        }
        catch (UnsupportedOperationException e) {
            accessor = new MemUtilNIO();
        }
        return accessor;
    }

    abstract void put(Matrix4f var1, int var2, FloatBuffer var3);

    abstract void put(Matrix4f var1, int var2, ByteBuffer var3);

    abstract void put(Matrix4x3f var1, int var2, FloatBuffer var3);

    abstract void put(Matrix4x3f var1, int var2, ByteBuffer var3);

    abstract void put4x4(Matrix4x3f var1, int var2, FloatBuffer var3);

    abstract void put4x4(Matrix4x3f var1, int var2, ByteBuffer var3);

    abstract void putTransposed(Matrix4f var1, int var2, FloatBuffer var3);

    abstract void putTransposed(Matrix4f var1, int var2, ByteBuffer var3);

    abstract void put4x3Transposed(Matrix4f var1, int var2, FloatBuffer var3);

    abstract void put4x3Transposed(Matrix4f var1, int var2, ByteBuffer var3);

    abstract void putTransposed(Matrix4x3f var1, int var2, FloatBuffer var3);

    abstract void putTransposed(Matrix4x3f var1, int var2, ByteBuffer var3);

    abstract void put(Matrix4d var1, int var2, DoubleBuffer var3);

    abstract void put(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void put(Matrix4x3d var1, int var2, DoubleBuffer var3);

    abstract void put(Matrix4x3d var1, int var2, ByteBuffer var3);

    abstract void putf(Matrix4d var1, int var2, FloatBuffer var3);

    abstract void putf(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void putf(Matrix4x3d var1, int var2, FloatBuffer var3);

    abstract void putf(Matrix4x3d var1, int var2, ByteBuffer var3);

    abstract void putTransposed(Matrix4d var1, int var2, DoubleBuffer var3);

    abstract void putTransposed(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void put4x3Transposed(Matrix4d var1, int var2, DoubleBuffer var3);

    abstract void put4x3Transposed(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void putTransposed(Matrix4x3d var1, int var2, DoubleBuffer var3);

    abstract void putTransposed(Matrix4x3d var1, int var2, ByteBuffer var3);

    abstract void putfTransposed(Matrix4d var1, int var2, FloatBuffer var3);

    abstract void putfTransposed(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void putfTransposed(Matrix4x3d var1, int var2, FloatBuffer var3);

    abstract void putfTransposed(Matrix4x3d var1, int var2, ByteBuffer var3);

    abstract void put(Matrix3f var1, int var2, FloatBuffer var3);

    abstract void put(Matrix3f var1, int var2, ByteBuffer var3);

    abstract void put(Matrix3d var1, int var2, DoubleBuffer var3);

    abstract void put(Matrix3d var1, int var2, ByteBuffer var3);

    abstract void putf(Matrix3d var1, int var2, FloatBuffer var3);

    abstract void putf(Matrix3d var1, int var2, ByteBuffer var3);

    abstract void get(Matrix4f var1, int var2, FloatBuffer var3);

    abstract void get(Matrix4f var1, int var2, ByteBuffer var3);

    abstract void get(Matrix4x3f var1, int var2, FloatBuffer var3);

    abstract void get(Matrix4x3f var1, int var2, ByteBuffer var3);

    abstract void get(Matrix4d var1, int var2, DoubleBuffer var3);

    abstract void get(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void get(Matrix4x3d var1, int var2, DoubleBuffer var3);

    abstract void get(Matrix4x3d var1, int var2, ByteBuffer var3);

    abstract void getf(Matrix4d var1, int var2, FloatBuffer var3);

    abstract void getf(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void getf(Matrix4x3d var1, int var2, FloatBuffer var3);

    abstract void getf(Matrix4x3d var1, int var2, ByteBuffer var3);

    abstract void get(Matrix3f var1, int var2, FloatBuffer var3);

    abstract void get(Matrix3f var1, int var2, ByteBuffer var3);

    abstract void get(Matrix3d var1, int var2, DoubleBuffer var3);

    abstract void get(Matrix3d var1, int var2, ByteBuffer var3);

    abstract void getf(Matrix3d var1, int var2, FloatBuffer var3);

    abstract void getf(Matrix3d var1, int var2, ByteBuffer var3);

    static final class MemUtilUnsafe
    extends MemUtil {
        private final Unsafe UNSAFE = MemUtilUnsafe.getUnsafeInstance();
        private final long ADDRESS;

        MemUtilUnsafe() throws UnsupportedOperationException {
            try {
                this.ADDRESS = this.UNSAFE.objectFieldOffset(MemUtilUnsafe.getDeclaredField(Buffer.class, "address"));
            }
            catch (NoSuchFieldException e) {
                throw new UnsupportedOperationException();
            }
        }

        private static final Field getDeclaredField(Class root, String fieldName) throws NoSuchFieldException {
            Class type = root;
            do {
                try {
                    Field field = type.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    type = type.getSuperclass();
                }
                catch (SecurityException e) {
                    type = type.getSuperclass();
                }
            } while (type != null);
            throw new NoSuchFieldException(fieldName + " does not exist in " + root.getName() + " or any of its superclasses.");
        }

        private static final Unsafe getUnsafeInstance() throws SecurityException {
            Field[] fields = Unsafe.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                int modifiers;
                Field field = fields[i];
                if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
                field.setAccessible(true);
                try {
                    return (Unsafe)field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    break;
                }
            }
            throw new UnsupportedOperationException();
        }

        private final long addressOf(Buffer buffer) {
            return this.UNSAFE.getLong(buffer, this.ADDRESS);
        }

        private final void memPutFloat(long ptr, float value) {
            this.UNSAFE.putFloat(ptr, value);
        }

        private final void memPutDouble(long ptr, double value) {
            this.UNSAFE.putDouble(ptr, value);
        }

        private final float memGetFloat(long ptr) {
            return this.UNSAFE.getFloat(ptr);
        }

        private final double memGetDouble(long ptr) {
            return this.UNSAFE.getDouble(ptr);
        }

        private final void put(Matrix4f m, long destAddr) {
            this.memPutFloat(destAddr, m.m00());
            this.memPutFloat(destAddr + 4L, m.m01());
            this.memPutFloat(destAddr + 8L, m.m02());
            this.memPutFloat(destAddr + 12L, m.m03());
            this.memPutFloat(destAddr + 16L, m.m10());
            this.memPutFloat(destAddr + 20L, m.m11());
            this.memPutFloat(destAddr + 24L, m.m12());
            this.memPutFloat(destAddr + 28L, m.m13());
            this.memPutFloat(destAddr + 32L, m.m20());
            this.memPutFloat(destAddr + 36L, m.m21());
            this.memPutFloat(destAddr + 40L, m.m22());
            this.memPutFloat(destAddr + 44L, m.m23());
            this.memPutFloat(destAddr + 48L, m.m30());
            this.memPutFloat(destAddr + 52L, m.m31());
            this.memPutFloat(destAddr + 56L, m.m32());
            this.memPutFloat(destAddr + 60L, m.m33());
        }

        private final void put(Matrix4x3f m, long destAddr) {
            this.memPutFloat(destAddr, m.m00());
            this.memPutFloat(destAddr + 4L, m.m01());
            this.memPutFloat(destAddr + 8L, m.m02());
            this.memPutFloat(destAddr + 12L, m.m10());
            this.memPutFloat(destAddr + 16L, m.m11());
            this.memPutFloat(destAddr + 20L, m.m12());
            this.memPutFloat(destAddr + 24L, m.m20());
            this.memPutFloat(destAddr + 28L, m.m21());
            this.memPutFloat(destAddr + 32L, m.m22());
            this.memPutFloat(destAddr + 36L, m.m30());
            this.memPutFloat(destAddr + 40L, m.m31());
            this.memPutFloat(destAddr + 44L, m.m32());
        }

        private final void put4x4(Matrix4x3f m, long destAddr) {
            this.memPutFloat(destAddr, m.m00());
            this.memPutFloat(destAddr + 4L, m.m01());
            this.memPutFloat(destAddr + 8L, m.m02());
            this.memPutFloat(destAddr + 12L, 0.0f);
            this.memPutFloat(destAddr + 16L, m.m10());
            this.memPutFloat(destAddr + 20L, m.m11());
            this.memPutFloat(destAddr + 24L, m.m12());
            this.memPutFloat(destAddr + 28L, 0.0f);
            this.memPutFloat(destAddr + 32L, m.m20());
            this.memPutFloat(destAddr + 36L, m.m21());
            this.memPutFloat(destAddr + 40L, m.m22());
            this.memPutFloat(destAddr + 44L, 0.0f);
            this.memPutFloat(destAddr + 48L, m.m30());
            this.memPutFloat(destAddr + 52L, m.m31());
            this.memPutFloat(destAddr + 56L, m.m32());
            this.memPutFloat(destAddr + 60L, 1.0f);
        }

        private final void putTransposed(Matrix4f m, long destAddr) {
            this.memPutFloat(destAddr, m.m00());
            this.memPutFloat(destAddr + 4L, m.m10());
            this.memPutFloat(destAddr + 8L, m.m20());
            this.memPutFloat(destAddr + 12L, m.m30());
            this.memPutFloat(destAddr + 16L, m.m01());
            this.memPutFloat(destAddr + 20L, m.m11());
            this.memPutFloat(destAddr + 24L, m.m21());
            this.memPutFloat(destAddr + 28L, m.m31());
            this.memPutFloat(destAddr + 32L, m.m02());
            this.memPutFloat(destAddr + 36L, m.m12());
            this.memPutFloat(destAddr + 40L, m.m22());
            this.memPutFloat(destAddr + 44L, m.m32());
            this.memPutFloat(destAddr + 48L, m.m03());
            this.memPutFloat(destAddr + 52L, m.m13());
            this.memPutFloat(destAddr + 56L, m.m23());
            this.memPutFloat(destAddr + 60L, m.m33());
        }

        private final void put4x3Transposed(Matrix4f m, long destAddr) {
            this.memPutFloat(destAddr, m.m00());
            this.memPutFloat(destAddr + 4L, m.m10());
            this.memPutFloat(destAddr + 8L, m.m20());
            this.memPutFloat(destAddr + 12L, m.m30());
            this.memPutFloat(destAddr + 16L, m.m01());
            this.memPutFloat(destAddr + 20L, m.m11());
            this.memPutFloat(destAddr + 24L, m.m21());
            this.memPutFloat(destAddr + 28L, m.m31());
            this.memPutFloat(destAddr + 32L, m.m02());
            this.memPutFloat(destAddr + 36L, m.m12());
            this.memPutFloat(destAddr + 40L, m.m22());
            this.memPutFloat(destAddr + 44L, m.m32());
        }

        private final void putTransposed(Matrix4x3f m, long destAddr) {
            this.memPutFloat(destAddr, m.m00());
            this.memPutFloat(destAddr + 4L, m.m10());
            this.memPutFloat(destAddr + 8L, m.m20());
            this.memPutFloat(destAddr + 12L, m.m30());
            this.memPutFloat(destAddr + 16L, m.m01());
            this.memPutFloat(destAddr + 20L, m.m11());
            this.memPutFloat(destAddr + 24L, m.m21());
            this.memPutFloat(destAddr + 28L, m.m31());
            this.memPutFloat(destAddr + 32L, m.m02());
            this.memPutFloat(destAddr + 36L, m.m12());
            this.memPutFloat(destAddr + 40L, m.m22());
            this.memPutFloat(destAddr + 44L, m.m32());
        }

        private final void put(Matrix4d m, long destAddr) {
            this.memPutDouble(destAddr, m.m00());
            this.memPutDouble(destAddr + 8L, m.m01());
            this.memPutDouble(destAddr + 16L, m.m02());
            this.memPutDouble(destAddr + 24L, m.m03());
            this.memPutDouble(destAddr + 32L, m.m10());
            this.memPutDouble(destAddr + 40L, m.m11());
            this.memPutDouble(destAddr + 48L, m.m12());
            this.memPutDouble(destAddr + 56L, m.m13());
            this.memPutDouble(destAddr + 64L, m.m20());
            this.memPutDouble(destAddr + 72L, m.m21());
            this.memPutDouble(destAddr + 80L, m.m22());
            this.memPutDouble(destAddr + 88L, m.m23());
            this.memPutDouble(destAddr + 96L, m.m30());
            this.memPutDouble(destAddr + 104L, m.m31());
            this.memPutDouble(destAddr + 112L, m.m32());
            this.memPutDouble(destAddr + 120L, m.m33());
        }

        private final void put(Matrix4x3d m, long destAddr) {
            this.memPutDouble(destAddr, m.m00());
            this.memPutDouble(destAddr + 8L, m.m01());
            this.memPutDouble(destAddr + 16L, m.m02());
            this.memPutDouble(destAddr + 24L, m.m10());
            this.memPutDouble(destAddr + 32L, m.m11());
            this.memPutDouble(destAddr + 40L, m.m12());
            this.memPutDouble(destAddr + 48L, m.m20());
            this.memPutDouble(destAddr + 56L, m.m21());
            this.memPutDouble(destAddr + 64L, m.m22());
            this.memPutDouble(destAddr + 72L, m.m30());
            this.memPutDouble(destAddr + 80L, m.m31());
            this.memPutDouble(destAddr + 88L, m.m32());
        }

        private final void putTransposed(Matrix4d m, long destAddr) {
            this.memPutDouble(destAddr, m.m00());
            this.memPutDouble(destAddr + 8L, m.m10());
            this.memPutDouble(destAddr + 16L, m.m20());
            this.memPutDouble(destAddr + 24L, m.m30());
            this.memPutDouble(destAddr + 32L, m.m01());
            this.memPutDouble(destAddr + 40L, m.m11());
            this.memPutDouble(destAddr + 48L, m.m21());
            this.memPutDouble(destAddr + 56L, m.m31());
            this.memPutDouble(destAddr + 64L, m.m02());
            this.memPutDouble(destAddr + 72L, m.m12());
            this.memPutDouble(destAddr + 80L, m.m22());
            this.memPutDouble(destAddr + 88L, m.m32());
            this.memPutDouble(destAddr + 96L, m.m03());
            this.memPutDouble(destAddr + 104L, m.m13());
            this.memPutDouble(destAddr + 112L, m.m23());
            this.memPutDouble(destAddr + 120L, m.m33());
        }

        private final void putfTransposed(Matrix4d m, long destAddr) {
            this.memPutFloat(destAddr, (float)m.m00());
            this.memPutFloat(destAddr + 4L, (float)m.m10());
            this.memPutFloat(destAddr + 8L, (float)m.m20());
            this.memPutFloat(destAddr + 12L, (float)m.m30());
            this.memPutFloat(destAddr + 16L, (float)m.m01());
            this.memPutFloat(destAddr + 20L, (float)m.m11());
            this.memPutFloat(destAddr + 24L, (float)m.m21());
            this.memPutFloat(destAddr + 28L, (float)m.m31());
            this.memPutFloat(destAddr + 32L, (float)m.m02());
            this.memPutFloat(destAddr + 36L, (float)m.m12());
            this.memPutFloat(destAddr + 40L, (float)m.m22());
            this.memPutFloat(destAddr + 44L, (float)m.m32());
            this.memPutFloat(destAddr + 48L, (float)m.m03());
            this.memPutFloat(destAddr + 52L, (float)m.m13());
            this.memPutFloat(destAddr + 56L, (float)m.m23());
            this.memPutFloat(destAddr + 60L, (float)m.m33());
        }

        private final void put4x3Transposed(Matrix4d m, long destAddr) {
            this.memPutDouble(destAddr, m.m00());
            this.memPutDouble(destAddr + 8L, m.m10());
            this.memPutDouble(destAddr + 16L, m.m20());
            this.memPutDouble(destAddr + 24L, m.m30());
            this.memPutDouble(destAddr + 32L, m.m01());
            this.memPutDouble(destAddr + 40L, m.m11());
            this.memPutDouble(destAddr + 48L, m.m21());
            this.memPutDouble(destAddr + 56L, m.m31());
            this.memPutDouble(destAddr + 64L, m.m02());
            this.memPutDouble(destAddr + 72L, m.m12());
            this.memPutDouble(destAddr + 80L, m.m22());
            this.memPutDouble(destAddr + 88L, m.m32());
        }

        private final void putTransposed(Matrix4x3d m, long destAddr) {
            this.memPutDouble(destAddr, m.m00());
            this.memPutDouble(destAddr + 8L, m.m10());
            this.memPutDouble(destAddr + 16L, m.m20());
            this.memPutDouble(destAddr + 24L, m.m30());
            this.memPutDouble(destAddr + 32L, m.m01());
            this.memPutDouble(destAddr + 40L, m.m11());
            this.memPutDouble(destAddr + 48L, m.m21());
            this.memPutDouble(destAddr + 56L, m.m31());
            this.memPutDouble(destAddr + 64L, m.m02());
            this.memPutDouble(destAddr + 72L, m.m12());
            this.memPutDouble(destAddr + 80L, m.m22());
            this.memPutDouble(destAddr + 88L, m.m32());
        }

        private final void putfTransposed(Matrix4x3d m, long destAddr) {
            this.memPutFloat(destAddr, (float)m.m00());
            this.memPutFloat(destAddr + 4L, (float)m.m10());
            this.memPutFloat(destAddr + 8L, (float)m.m20());
            this.memPutFloat(destAddr + 12L, (float)m.m30());
            this.memPutFloat(destAddr + 16L, (float)m.m01());
            this.memPutFloat(destAddr + 20L, (float)m.m11());
            this.memPutFloat(destAddr + 24L, (float)m.m21());
            this.memPutFloat(destAddr + 28L, (float)m.m31());
            this.memPutFloat(destAddr + 32L, (float)m.m02());
            this.memPutFloat(destAddr + 36L, (float)m.m12());
            this.memPutFloat(destAddr + 40L, (float)m.m22());
            this.memPutFloat(destAddr + 44L, (float)m.m32());
        }

        private final void putf(Matrix4d m, long destAddr) {
            this.memPutFloat(destAddr, (float)m.m00());
            this.memPutFloat(destAddr + 4L, (float)m.m01());
            this.memPutFloat(destAddr + 8L, (float)m.m02());
            this.memPutFloat(destAddr + 12L, (float)m.m03());
            this.memPutFloat(destAddr + 16L, (float)m.m10());
            this.memPutFloat(destAddr + 20L, (float)m.m11());
            this.memPutFloat(destAddr + 24L, (float)m.m12());
            this.memPutFloat(destAddr + 28L, (float)m.m13());
            this.memPutFloat(destAddr + 32L, (float)m.m20());
            this.memPutFloat(destAddr + 36L, (float)m.m21());
            this.memPutFloat(destAddr + 40L, (float)m.m22());
            this.memPutFloat(destAddr + 44L, (float)m.m23());
            this.memPutFloat(destAddr + 48L, (float)m.m30());
            this.memPutFloat(destAddr + 52L, (float)m.m31());
            this.memPutFloat(destAddr + 56L, (float)m.m32());
            this.memPutFloat(destAddr + 60L, (float)m.m33());
        }

        private final void putf(Matrix4x3d m, long destAddr) {
            this.memPutFloat(destAddr, (float)m.m00());
            this.memPutFloat(destAddr + 4L, (float)m.m01());
            this.memPutFloat(destAddr + 8L, (float)m.m02());
            this.memPutFloat(destAddr + 12L, (float)m.m10());
            this.memPutFloat(destAddr + 16L, (float)m.m11());
            this.memPutFloat(destAddr + 20L, (float)m.m12());
            this.memPutFloat(destAddr + 24L, (float)m.m20());
            this.memPutFloat(destAddr + 28L, (float)m.m21());
            this.memPutFloat(destAddr + 32L, (float)m.m22());
            this.memPutFloat(destAddr + 36L, (float)m.m30());
            this.memPutFloat(destAddr + 40L, (float)m.m31());
            this.memPutFloat(destAddr + 44L, (float)m.m32());
        }

        private final void put(Matrix3f m, long destAddr) {
            this.memPutFloat(destAddr, m.m00);
            this.memPutFloat(destAddr + 4L, m.m01);
            this.memPutFloat(destAddr + 8L, m.m02);
            this.memPutFloat(destAddr + 12L, m.m10);
            this.memPutFloat(destAddr + 16L, m.m11);
            this.memPutFloat(destAddr + 20L, m.m12);
            this.memPutFloat(destAddr + 24L, m.m20);
            this.memPutFloat(destAddr + 28L, m.m21);
            this.memPutFloat(destAddr + 32L, m.m22);
        }

        private final void put(Matrix3d m, long destAddr) {
            this.memPutDouble(destAddr, m.m00);
            this.memPutDouble(destAddr + 8L, m.m01);
            this.memPutDouble(destAddr + 16L, m.m02);
            this.memPutDouble(destAddr + 24L, m.m10);
            this.memPutDouble(destAddr + 32L, m.m11);
            this.memPutDouble(destAddr + 40L, m.m12);
            this.memPutDouble(destAddr + 48L, m.m20);
            this.memPutDouble(destAddr + 56L, m.m21);
            this.memPutDouble(destAddr + 64L, m.m22);
        }

        private final void putf(Matrix3d m, long destAddr) {
            this.memPutFloat(destAddr, (float)m.m00);
            this.memPutFloat(destAddr + 4L, (float)m.m01);
            this.memPutFloat(destAddr + 8L, (float)m.m02);
            this.memPutFloat(destAddr + 12L, (float)m.m10);
            this.memPutFloat(destAddr + 16L, (float)m.m11);
            this.memPutFloat(destAddr + 20L, (float)m.m12);
            this.memPutFloat(destAddr + 24L, (float)m.m20);
            this.memPutFloat(destAddr + 28L, (float)m.m21);
            this.memPutFloat(destAddr + 32L, (float)m.m22);
        }

        private final void get(Matrix4f m, long srcAddr) {
            m.m00(this.memGetFloat(srcAddr));
            m.m01(this.memGetFloat(srcAddr + 4L));
            m.m02(this.memGetFloat(srcAddr + 8L));
            m.m03(this.memGetFloat(srcAddr + 12L));
            m.m10(this.memGetFloat(srcAddr + 16L));
            m.m11(this.memGetFloat(srcAddr + 20L));
            m.m12(this.memGetFloat(srcAddr + 24L));
            m.m13(this.memGetFloat(srcAddr + 28L));
            m.m20(this.memGetFloat(srcAddr + 32L));
            m.m21(this.memGetFloat(srcAddr + 36L));
            m.m22(this.memGetFloat(srcAddr + 40L));
            m.m23(this.memGetFloat(srcAddr + 44L));
            m.m30(this.memGetFloat(srcAddr + 48L));
            m.m31(this.memGetFloat(srcAddr + 52L));
            m.m32(this.memGetFloat(srcAddr + 56L));
            m.m33(this.memGetFloat(srcAddr + 60L));
        }

        private final void get(Matrix4x3f m, long srcAddr) {
            m.m00(this.memGetFloat(srcAddr));
            m.m01(this.memGetFloat(srcAddr + 4L));
            m.m02(this.memGetFloat(srcAddr + 8L));
            m.m10(this.memGetFloat(srcAddr + 12L));
            m.m11(this.memGetFloat(srcAddr + 16L));
            m.m12(this.memGetFloat(srcAddr + 20L));
            m.m20(this.memGetFloat(srcAddr + 24L));
            m.m21(this.memGetFloat(srcAddr + 28L));
            m.m22(this.memGetFloat(srcAddr + 32L));
            m.m30(this.memGetFloat(srcAddr + 36L));
            m.m31(this.memGetFloat(srcAddr + 40L));
            m.m32(this.memGetFloat(srcAddr + 44L));
        }

        private final void get(Matrix4d m, long srcAddr) {
            m.m00(this.memGetDouble(srcAddr));
            m.m01(this.memGetDouble(srcAddr + 8L));
            m.m02(this.memGetDouble(srcAddr + 16L));
            m.m03(this.memGetDouble(srcAddr + 24L));
            m.m10(this.memGetDouble(srcAddr + 32L));
            m.m11(this.memGetDouble(srcAddr + 40L));
            m.m12(this.memGetDouble(srcAddr + 48L));
            m.m13(this.memGetDouble(srcAddr + 56L));
            m.m20(this.memGetDouble(srcAddr + 64L));
            m.m21(this.memGetDouble(srcAddr + 72L));
            m.m22(this.memGetDouble(srcAddr + 80L));
            m.m23(this.memGetDouble(srcAddr + 88L));
            m.m30(this.memGetDouble(srcAddr + 96L));
            m.m31(this.memGetDouble(srcAddr + 104L));
            m.m32(this.memGetDouble(srcAddr + 112L));
            m.m33(this.memGetDouble(srcAddr + 120L));
        }

        private final void get(Matrix4x3d m, long srcAddr) {
            m.m00(this.memGetDouble(srcAddr));
            m.m01(this.memGetDouble(srcAddr + 8L));
            m.m02(this.memGetDouble(srcAddr + 16L));
            m.m10(this.memGetDouble(srcAddr + 24L));
            m.m11(this.memGetDouble(srcAddr + 32L));
            m.m12(this.memGetDouble(srcAddr + 40L));
            m.m20(this.memGetDouble(srcAddr + 48L));
            m.m21(this.memGetDouble(srcAddr + 56L));
            m.m22(this.memGetDouble(srcAddr + 64L));
            m.m30(this.memGetDouble(srcAddr + 72L));
            m.m31(this.memGetDouble(srcAddr + 80L));
            m.m32(this.memGetDouble(srcAddr + 88L));
        }

        private final void getf(Matrix4d m, long srcAddr) {
            m.m00(this.memGetFloat(srcAddr));
            m.m01(this.memGetFloat(srcAddr + 4L));
            m.m02(this.memGetFloat(srcAddr + 8L));
            m.m03(this.memGetFloat(srcAddr + 12L));
            m.m10(this.memGetFloat(srcAddr + 16L));
            m.m11(this.memGetFloat(srcAddr + 20L));
            m.m12(this.memGetFloat(srcAddr + 24L));
            m.m13(this.memGetFloat(srcAddr + 28L));
            m.m20(this.memGetFloat(srcAddr + 32L));
            m.m21(this.memGetFloat(srcAddr + 36L));
            m.m22(this.memGetFloat(srcAddr + 40L));
            m.m23(this.memGetFloat(srcAddr + 44L));
            m.m30(this.memGetFloat(srcAddr + 48L));
            m.m31(this.memGetFloat(srcAddr + 52L));
            m.m32(this.memGetFloat(srcAddr + 56L));
            m.m33(this.memGetFloat(srcAddr + 60L));
        }

        private final void getf(Matrix4x3d m, long srcAddr) {
            m.m00(this.memGetFloat(srcAddr));
            m.m01(this.memGetFloat(srcAddr + 4L));
            m.m02(this.memGetFloat(srcAddr + 8L));
            m.m10(this.memGetFloat(srcAddr + 12L));
            m.m11(this.memGetFloat(srcAddr + 16L));
            m.m12(this.memGetFloat(srcAddr + 20L));
            m.m20(this.memGetFloat(srcAddr + 24L));
            m.m21(this.memGetFloat(srcAddr + 28L));
            m.m22(this.memGetFloat(srcAddr + 32L));
            m.m30(this.memGetFloat(srcAddr + 36L));
            m.m31(this.memGetFloat(srcAddr + 40L));
            m.m32(this.memGetFloat(srcAddr + 44L));
        }

        private final void get(Matrix3f m, long srcAddr) {
            m.m00 = this.memGetFloat(srcAddr);
            m.m01 = this.memGetFloat(srcAddr + 4L);
            m.m02 = this.memGetFloat(srcAddr + 8L);
            m.m10 = this.memGetFloat(srcAddr + 12L);
            m.m11 = this.memGetFloat(srcAddr + 16L);
            m.m12 = this.memGetFloat(srcAddr + 20L);
            m.m20 = this.memGetFloat(srcAddr + 24L);
            m.m21 = this.memGetFloat(srcAddr + 28L);
            m.m22 = this.memGetFloat(srcAddr + 32L);
        }

        private final void get(Matrix3d m, long srcAddr) {
            m.m00 = this.memGetDouble(srcAddr);
            m.m01 = this.memGetDouble(srcAddr + 8L);
            m.m02 = this.memGetDouble(srcAddr + 16L);
            m.m10 = this.memGetDouble(srcAddr + 24L);
            m.m11 = this.memGetDouble(srcAddr + 32L);
            m.m12 = this.memGetDouble(srcAddr + 40L);
            m.m20 = this.memGetDouble(srcAddr + 48L);
            m.m21 = this.memGetDouble(srcAddr + 56L);
            m.m22 = this.memGetDouble(srcAddr + 64L);
        }

        private final void getf(Matrix3d m, long srcAddr) {
            m.m00 = this.memGetFloat(srcAddr);
            m.m01 = this.memGetFloat(srcAddr + 4L);
            m.m02 = this.memGetFloat(srcAddr + 8L);
            m.m10 = this.memGetFloat(srcAddr + 12L);
            m.m11 = this.memGetFloat(srcAddr + 16L);
            m.m12 = this.memGetFloat(srcAddr + 20L);
            m.m20 = this.memGetFloat(srcAddr + 24L);
            m.m21 = this.memGetFloat(srcAddr + 28L);
            m.m22 = this.memGetFloat(srcAddr + 32L);
        }

        @Override
        final void put(Matrix4f m, int offset, FloatBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 2));
        }

        @Override
        final void put(Matrix4f m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void put(Matrix4x3f m, int offset, FloatBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 2));
        }

        @Override
        final void put(Matrix4x3f m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void put4x4(Matrix4x3f m, int offset, FloatBuffer dest) {
            this.put4x4(m, this.addressOf(dest) + (long)(offset << 2));
        }

        @Override
        final void put4x4(Matrix4x3f m, int offset, ByteBuffer dest) {
            this.put4x4(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void putTransposed(Matrix4f m, int offset, FloatBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        @Override
        final void putTransposed(Matrix4f m, int offset, ByteBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void put4x3Transposed(Matrix4f m, int offset, FloatBuffer dest) {
            this.put4x3Transposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        @Override
        final void put4x3Transposed(Matrix4f m, int offset, ByteBuffer dest) {
            this.put4x3Transposed(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void putTransposed(Matrix4x3f m, int offset, FloatBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        @Override
        final void putTransposed(Matrix4x3f m, int offset, ByteBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void put(Matrix4d m, int offset, DoubleBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 3));
        }

        @Override
        final void put(Matrix4d m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void put(Matrix4x3d m, int offset, DoubleBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 3));
        }

        @Override
        final void put(Matrix4x3d m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void putf(Matrix4d m, int offset, FloatBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)(offset << 2));
        }

        @Override
        final void putf(Matrix4d m, int offset, ByteBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void putf(Matrix4x3d m, int offset, FloatBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)(offset << 2));
        }

        @Override
        final void putf(Matrix4x3d m, int offset, ByteBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void putTransposed(Matrix4d m, int offset, DoubleBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)(offset << 3));
        }

        @Override
        final void putTransposed(Matrix4d m, int offset, ByteBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void put4x3Transposed(Matrix4d m, int offset, DoubleBuffer dest) {
            this.put4x3Transposed(m, this.addressOf(dest) + (long)(offset << 3));
        }

        @Override
        final void put4x3Transposed(Matrix4d m, int offset, ByteBuffer dest) {
            this.put4x3Transposed(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void putTransposed(Matrix4x3d m, int offset, DoubleBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)(offset << 3));
        }

        @Override
        final void putTransposed(Matrix4x3d m, int offset, ByteBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void putfTransposed(Matrix4d m, int offset, FloatBuffer dest) {
            this.putfTransposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        @Override
        final void putfTransposed(Matrix4d m, int offset, ByteBuffer dest) {
            this.putfTransposed(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void putfTransposed(Matrix4x3d m, int offset, FloatBuffer dest) {
            this.putfTransposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        @Override
        final void putfTransposed(Matrix4x3d m, int offset, ByteBuffer dest) {
            this.putfTransposed(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void put(Matrix3f m, int offset, FloatBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 2));
        }

        @Override
        final void put(Matrix3f m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void put(Matrix3d m, int offset, DoubleBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 3));
        }

        @Override
        final void put(Matrix3d m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void putf(Matrix3d m, int offset, FloatBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)(offset << 2));
        }

        @Override
        final void putf(Matrix3d m, int offset, ByteBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)offset);
        }

        @Override
        final void get(Matrix4f m, int offset, FloatBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 2));
        }

        @Override
        final void get(Matrix4f m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        @Override
        final void get(Matrix4x3f m, int offset, FloatBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 2));
        }

        @Override
        final void get(Matrix4x3f m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        @Override
        final void get(Matrix4d m, int offset, DoubleBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 3));
        }

        @Override
        final void get(Matrix4d m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        @Override
        final void get(Matrix4x3d m, int offset, DoubleBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 3));
        }

        @Override
        final void get(Matrix4x3d m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        @Override
        final void getf(Matrix4d m, int offset, FloatBuffer src) {
            this.getf(m, this.addressOf(src) + (long)(offset << 2));
        }

        @Override
        final void getf(Matrix4d m, int offset, ByteBuffer src) {
            this.getf(m, this.addressOf(src) + (long)offset);
        }

        @Override
        final void getf(Matrix4x3d m, int offset, FloatBuffer src) {
            this.getf(m, this.addressOf(src) + (long)(offset << 2));
        }

        @Override
        final void getf(Matrix4x3d m, int offset, ByteBuffer src) {
            this.getf(m, this.addressOf(src) + (long)offset);
        }

        @Override
        final void get(Matrix3f m, int offset, FloatBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 2));
        }

        @Override
        final void get(Matrix3f m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        @Override
        final void get(Matrix3d m, int offset, DoubleBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 3));
        }

        @Override
        final void get(Matrix3d m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        @Override
        final void getf(Matrix3d m, int offset, FloatBuffer src) {
            this.getf(m, this.addressOf(src) + (long)(offset << 2));
        }

        @Override
        final void getf(Matrix3d m, int offset, ByteBuffer src) {
            this.getf(m, this.addressOf(src) + (long)offset);
        }
    }

    static final class MemUtilNIO
    extends MemUtil {
        MemUtilNIO() {
        }

        @Override
        final void put(Matrix4f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00());
            dest.put(offset + 1, m.m01());
            dest.put(offset + 2, m.m02());
            dest.put(offset + 3, m.m03());
            dest.put(offset + 4, m.m10());
            dest.put(offset + 5, m.m11());
            dest.put(offset + 6, m.m12());
            dest.put(offset + 7, m.m13());
            dest.put(offset + 8, m.m20());
            dest.put(offset + 9, m.m21());
            dest.put(offset + 10, m.m22());
            dest.put(offset + 11, m.m23());
            dest.put(offset + 12, m.m30());
            dest.put(offset + 13, m.m31());
            dest.put(offset + 14, m.m32());
            dest.put(offset + 15, m.m33());
        }

        @Override
        final void put(Matrix4f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00());
            dest.putFloat(offset + 4, m.m01());
            dest.putFloat(offset + 8, m.m02());
            dest.putFloat(offset + 12, m.m03());
            dest.putFloat(offset + 16, m.m10());
            dest.putFloat(offset + 20, m.m11());
            dest.putFloat(offset + 24, m.m12());
            dest.putFloat(offset + 28, m.m13());
            dest.putFloat(offset + 32, m.m20());
            dest.putFloat(offset + 36, m.m21());
            dest.putFloat(offset + 40, m.m22());
            dest.putFloat(offset + 44, m.m23());
            dest.putFloat(offset + 48, m.m30());
            dest.putFloat(offset + 52, m.m31());
            dest.putFloat(offset + 56, m.m32());
            dest.putFloat(offset + 60, m.m33());
        }

        @Override
        final void put(Matrix4x3f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00());
            dest.put(offset + 1, m.m01());
            dest.put(offset + 2, m.m02());
            dest.put(offset + 3, m.m10());
            dest.put(offset + 4, m.m11());
            dest.put(offset + 5, m.m12());
            dest.put(offset + 6, m.m20());
            dest.put(offset + 7, m.m21());
            dest.put(offset + 8, m.m22());
            dest.put(offset + 9, m.m30());
            dest.put(offset + 10, m.m31());
            dest.put(offset + 11, m.m32());
        }

        @Override
        final void put(Matrix4x3f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00());
            dest.putFloat(offset + 4, m.m01());
            dest.putFloat(offset + 8, m.m02());
            dest.putFloat(offset + 12, m.m10());
            dest.putFloat(offset + 16, m.m11());
            dest.putFloat(offset + 20, m.m12());
            dest.putFloat(offset + 24, m.m20());
            dest.putFloat(offset + 28, m.m21());
            dest.putFloat(offset + 32, m.m22());
            dest.putFloat(offset + 36, m.m30());
            dest.putFloat(offset + 40, m.m31());
            dest.putFloat(offset + 44, m.m32());
        }

        @Override
        final void put4x4(Matrix4x3f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00());
            dest.put(offset + 1, m.m01());
            dest.put(offset + 2, m.m02());
            dest.put(offset + 3, 0.0f);
            dest.put(offset + 4, m.m10());
            dest.put(offset + 5, m.m11());
            dest.put(offset + 6, m.m12());
            dest.put(offset + 7, 0.0f);
            dest.put(offset + 8, m.m20());
            dest.put(offset + 9, m.m21());
            dest.put(offset + 10, m.m22());
            dest.put(offset + 11, 0.0f);
            dest.put(offset + 12, m.m30());
            dest.put(offset + 13, m.m31());
            dest.put(offset + 14, m.m32());
            dest.put(offset + 15, 1.0f);
        }

        @Override
        final void put4x4(Matrix4x3f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00());
            dest.putFloat(offset + 4, m.m01());
            dest.putFloat(offset + 8, m.m02());
            dest.putFloat(offset + 12, 0.0f);
            dest.putFloat(offset + 16, m.m10());
            dest.putFloat(offset + 20, m.m11());
            dest.putFloat(offset + 24, m.m12());
            dest.putFloat(offset + 28, 0.0f);
            dest.putFloat(offset + 32, m.m20());
            dest.putFloat(offset + 36, m.m21());
            dest.putFloat(offset + 40, m.m22());
            dest.putFloat(offset + 44, 0.0f);
            dest.putFloat(offset + 48, m.m30());
            dest.putFloat(offset + 52, m.m31());
            dest.putFloat(offset + 56, m.m32());
            dest.putFloat(offset + 60, 1.0f);
        }

        @Override
        final void putTransposed(Matrix4f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00());
            dest.put(offset + 1, m.m10());
            dest.put(offset + 2, m.m20());
            dest.put(offset + 3, m.m30());
            dest.put(offset + 4, m.m01());
            dest.put(offset + 5, m.m11());
            dest.put(offset + 6, m.m21());
            dest.put(offset + 7, m.m31());
            dest.put(offset + 8, m.m02());
            dest.put(offset + 9, m.m12());
            dest.put(offset + 10, m.m22());
            dest.put(offset + 11, m.m32());
            dest.put(offset + 12, m.m03());
            dest.put(offset + 13, m.m13());
            dest.put(offset + 14, m.m23());
            dest.put(offset + 15, m.m33());
        }

        @Override
        final void putTransposed(Matrix4f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00());
            dest.putFloat(offset + 4, m.m10());
            dest.putFloat(offset + 8, m.m20());
            dest.putFloat(offset + 12, m.m30());
            dest.putFloat(offset + 16, m.m01());
            dest.putFloat(offset + 20, m.m11());
            dest.putFloat(offset + 24, m.m21());
            dest.putFloat(offset + 28, m.m31());
            dest.putFloat(offset + 32, m.m02());
            dest.putFloat(offset + 36, m.m12());
            dest.putFloat(offset + 40, m.m22());
            dest.putFloat(offset + 44, m.m32());
            dest.putFloat(offset + 48, m.m03());
            dest.putFloat(offset + 52, m.m13());
            dest.putFloat(offset + 56, m.m23());
            dest.putFloat(offset + 60, m.m33());
        }

        @Override
        final void put4x3Transposed(Matrix4f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00());
            dest.put(offset + 1, m.m10());
            dest.put(offset + 2, m.m20());
            dest.put(offset + 3, m.m30());
            dest.put(offset + 4, m.m01());
            dest.put(offset + 5, m.m11());
            dest.put(offset + 6, m.m21());
            dest.put(offset + 7, m.m31());
            dest.put(offset + 8, m.m02());
            dest.put(offset + 9, m.m12());
            dest.put(offset + 10, m.m22());
            dest.put(offset + 11, m.m32());
        }

        @Override
        final void put4x3Transposed(Matrix4f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00());
            dest.putFloat(offset + 4, m.m10());
            dest.putFloat(offset + 8, m.m20());
            dest.putFloat(offset + 12, m.m30());
            dest.putFloat(offset + 16, m.m01());
            dest.putFloat(offset + 20, m.m11());
            dest.putFloat(offset + 24, m.m21());
            dest.putFloat(offset + 28, m.m31());
            dest.putFloat(offset + 32, m.m02());
            dest.putFloat(offset + 36, m.m12());
            dest.putFloat(offset + 40, m.m22());
            dest.putFloat(offset + 44, m.m32());
        }

        @Override
        final void putTransposed(Matrix4x3f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00());
            dest.put(offset + 1, m.m10());
            dest.put(offset + 2, m.m20());
            dest.put(offset + 3, m.m30());
            dest.put(offset + 4, m.m01());
            dest.put(offset + 5, m.m11());
            dest.put(offset + 6, m.m21());
            dest.put(offset + 7, m.m31());
            dest.put(offset + 8, m.m02());
            dest.put(offset + 9, m.m12());
            dest.put(offset + 10, m.m22());
            dest.put(offset + 11, m.m32());
        }

        @Override
        final void putTransposed(Matrix4x3f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00());
            dest.putFloat(offset + 4, m.m10());
            dest.putFloat(offset + 8, m.m20());
            dest.putFloat(offset + 12, m.m30());
            dest.putFloat(offset + 16, m.m01());
            dest.putFloat(offset + 20, m.m11());
            dest.putFloat(offset + 24, m.m21());
            dest.putFloat(offset + 28, m.m31());
            dest.putFloat(offset + 32, m.m02());
            dest.putFloat(offset + 36, m.m12());
            dest.putFloat(offset + 40, m.m22());
            dest.putFloat(offset + 44, m.m32());
        }

        @Override
        final void put(Matrix4d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00());
            dest.put(offset + 1, m.m01());
            dest.put(offset + 2, m.m02());
            dest.put(offset + 3, m.m03());
            dest.put(offset + 4, m.m10());
            dest.put(offset + 5, m.m11());
            dest.put(offset + 6, m.m12());
            dest.put(offset + 7, m.m13());
            dest.put(offset + 8, m.m20());
            dest.put(offset + 9, m.m21());
            dest.put(offset + 10, m.m22());
            dest.put(offset + 11, m.m23());
            dest.put(offset + 12, m.m30());
            dest.put(offset + 13, m.m31());
            dest.put(offset + 14, m.m32());
            dest.put(offset + 15, m.m33());
        }

        @Override
        final void put(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00());
            dest.putDouble(offset + 4, m.m01());
            dest.putDouble(offset + 8, m.m02());
            dest.putDouble(offset + 12, m.m03());
            dest.putDouble(offset + 16, m.m10());
            dest.putDouble(offset + 20, m.m11());
            dest.putDouble(offset + 24, m.m12());
            dest.putDouble(offset + 28, m.m13());
            dest.putDouble(offset + 32, m.m20());
            dest.putDouble(offset + 36, m.m21());
            dest.putDouble(offset + 40, m.m22());
            dest.putDouble(offset + 44, m.m23());
            dest.putDouble(offset + 48, m.m30());
            dest.putDouble(offset + 52, m.m31());
            dest.putDouble(offset + 56, m.m32());
            dest.putDouble(offset + 60, m.m33());
        }

        @Override
        final void put(Matrix4x3d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00());
            dest.put(offset + 1, m.m01());
            dest.put(offset + 2, m.m02());
            dest.put(offset + 3, m.m10());
            dest.put(offset + 4, m.m11());
            dest.put(offset + 5, m.m12());
            dest.put(offset + 6, m.m20());
            dest.put(offset + 7, m.m21());
            dest.put(offset + 8, m.m22());
            dest.put(offset + 9, m.m30());
            dest.put(offset + 10, m.m31());
            dest.put(offset + 11, m.m32());
        }

        @Override
        final void put(Matrix4x3d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00());
            dest.putDouble(offset + 4, m.m01());
            dest.putDouble(offset + 8, m.m02());
            dest.putDouble(offset + 12, m.m10());
            dest.putDouble(offset + 16, m.m11());
            dest.putDouble(offset + 20, m.m12());
            dest.putDouble(offset + 24, m.m20());
            dest.putDouble(offset + 28, m.m21());
            dest.putDouble(offset + 32, m.m22());
            dest.putDouble(offset + 36, m.m30());
            dest.putDouble(offset + 40, m.m31());
            dest.putDouble(offset + 44, m.m32());
        }

        @Override
        final void putf(Matrix4d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00());
            dest.put(offset + 1, (float)m.m01());
            dest.put(offset + 2, (float)m.m02());
            dest.put(offset + 3, (float)m.m03());
            dest.put(offset + 4, (float)m.m10());
            dest.put(offset + 5, (float)m.m11());
            dest.put(offset + 6, (float)m.m12());
            dest.put(offset + 7, (float)m.m13());
            dest.put(offset + 8, (float)m.m20());
            dest.put(offset + 9, (float)m.m21());
            dest.put(offset + 10, (float)m.m22());
            dest.put(offset + 11, (float)m.m23());
            dest.put(offset + 12, (float)m.m30());
            dest.put(offset + 13, (float)m.m31());
            dest.put(offset + 14, (float)m.m32());
            dest.put(offset + 15, (float)m.m33());
        }

        @Override
        final void putf(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00());
            dest.putFloat(offset + 4, (float)m.m01());
            dest.putFloat(offset + 8, (float)m.m02());
            dest.putFloat(offset + 12, (float)m.m03());
            dest.putFloat(offset + 16, (float)m.m10());
            dest.putFloat(offset + 20, (float)m.m11());
            dest.putFloat(offset + 24, (float)m.m12());
            dest.putFloat(offset + 28, (float)m.m13());
            dest.putFloat(offset + 32, (float)m.m20());
            dest.putFloat(offset + 36, (float)m.m21());
            dest.putFloat(offset + 40, (float)m.m22());
            dest.putFloat(offset + 44, (float)m.m23());
            dest.putFloat(offset + 48, (float)m.m30());
            dest.putFloat(offset + 52, (float)m.m31());
            dest.putFloat(offset + 56, (float)m.m32());
            dest.putFloat(offset + 60, (float)m.m33());
        }

        @Override
        final void putf(Matrix4x3d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00());
            dest.put(offset + 1, (float)m.m01());
            dest.put(offset + 2, (float)m.m02());
            dest.put(offset + 3, (float)m.m10());
            dest.put(offset + 4, (float)m.m11());
            dest.put(offset + 5, (float)m.m12());
            dest.put(offset + 6, (float)m.m20());
            dest.put(offset + 7, (float)m.m21());
            dest.put(offset + 8, (float)m.m22());
            dest.put(offset + 9, (float)m.m30());
            dest.put(offset + 10, (float)m.m31());
            dest.put(offset + 11, (float)m.m32());
        }

        @Override
        final void putf(Matrix4x3d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00());
            dest.putFloat(offset + 4, (float)m.m01());
            dest.putFloat(offset + 8, (float)m.m02());
            dest.putFloat(offset + 12, (float)m.m10());
            dest.putFloat(offset + 16, (float)m.m11());
            dest.putFloat(offset + 20, (float)m.m12());
            dest.putFloat(offset + 24, (float)m.m20());
            dest.putFloat(offset + 28, (float)m.m21());
            dest.putFloat(offset + 32, (float)m.m22());
            dest.putFloat(offset + 36, (float)m.m30());
            dest.putFloat(offset + 40, (float)m.m31());
            dest.putFloat(offset + 44, (float)m.m32());
        }

        @Override
        final void putTransposed(Matrix4d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00());
            dest.put(offset + 1, m.m10());
            dest.put(offset + 2, m.m20());
            dest.put(offset + 3, m.m30());
            dest.put(offset + 4, m.m01());
            dest.put(offset + 5, m.m11());
            dest.put(offset + 6, m.m21());
            dest.put(offset + 7, m.m31());
            dest.put(offset + 8, m.m02());
            dest.put(offset + 9, m.m12());
            dest.put(offset + 10, m.m22());
            dest.put(offset + 11, m.m32());
            dest.put(offset + 12, m.m03());
            dest.put(offset + 13, m.m13());
            dest.put(offset + 14, m.m23());
            dest.put(offset + 15, m.m33());
        }

        @Override
        final void putTransposed(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00());
            dest.putDouble(offset + 8, m.m10());
            dest.putDouble(offset + 16, m.m20());
            dest.putDouble(offset + 24, m.m30());
            dest.putDouble(offset + 32, m.m01());
            dest.putDouble(offset + 40, m.m11());
            dest.putDouble(offset + 48, m.m21());
            dest.putDouble(offset + 56, m.m31());
            dest.putDouble(offset + 64, m.m02());
            dest.putDouble(offset + 72, m.m12());
            dest.putDouble(offset + 80, m.m22());
            dest.putDouble(offset + 88, m.m32());
            dest.putDouble(offset + 96, m.m03());
            dest.putDouble(offset + 104, m.m13());
            dest.putDouble(offset + 112, m.m23());
            dest.putDouble(offset + 120, m.m33());
        }

        @Override
        final void put4x3Transposed(Matrix4d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00());
            dest.put(offset + 1, m.m10());
            dest.put(offset + 2, m.m20());
            dest.put(offset + 3, m.m30());
            dest.put(offset + 4, m.m01());
            dest.put(offset + 5, m.m11());
            dest.put(offset + 6, m.m21());
            dest.put(offset + 7, m.m31());
            dest.put(offset + 8, m.m02());
            dest.put(offset + 9, m.m12());
            dest.put(offset + 10, m.m22());
            dest.put(offset + 11, m.m32());
        }

        @Override
        final void put4x3Transposed(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00());
            dest.putDouble(offset + 8, m.m10());
            dest.putDouble(offset + 16, m.m20());
            dest.putDouble(offset + 24, m.m30());
            dest.putDouble(offset + 32, m.m01());
            dest.putDouble(offset + 40, m.m11());
            dest.putDouble(offset + 48, m.m21());
            dest.putDouble(offset + 56, m.m31());
            dest.putDouble(offset + 64, m.m02());
            dest.putDouble(offset + 72, m.m12());
            dest.putDouble(offset + 80, m.m22());
            dest.putDouble(offset + 88, m.m32());
        }

        @Override
        final void putTransposed(Matrix4x3d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00());
            dest.put(offset + 1, m.m10());
            dest.put(offset + 2, m.m20());
            dest.put(offset + 3, m.m30());
            dest.put(offset + 4, m.m01());
            dest.put(offset + 5, m.m11());
            dest.put(offset + 6, m.m21());
            dest.put(offset + 7, m.m31());
            dest.put(offset + 8, m.m02());
            dest.put(offset + 9, m.m12());
            dest.put(offset + 10, m.m22());
            dest.put(offset + 11, m.m32());
        }

        @Override
        final void putTransposed(Matrix4x3d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00());
            dest.putDouble(offset + 4, m.m10());
            dest.putDouble(offset + 8, m.m20());
            dest.putDouble(offset + 12, m.m30());
            dest.putDouble(offset + 16, m.m01());
            dest.putDouble(offset + 20, m.m11());
            dest.putDouble(offset + 24, m.m21());
            dest.putDouble(offset + 28, m.m31());
            dest.putDouble(offset + 32, m.m02());
            dest.putDouble(offset + 36, m.m12());
            dest.putDouble(offset + 40, m.m22());
            dest.putDouble(offset + 44, m.m32());
        }

        @Override
        final void putfTransposed(Matrix4x3d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00());
            dest.put(offset + 1, (float)m.m10());
            dest.put(offset + 2, (float)m.m20());
            dest.put(offset + 3, (float)m.m30());
            dest.put(offset + 4, (float)m.m01());
            dest.put(offset + 5, (float)m.m11());
            dest.put(offset + 6, (float)m.m21());
            dest.put(offset + 7, (float)m.m31());
            dest.put(offset + 8, (float)m.m02());
            dest.put(offset + 9, (float)m.m12());
            dest.put(offset + 10, (float)m.m22());
            dest.put(offset + 11, (float)m.m32());
        }

        @Override
        final void putfTransposed(Matrix4x3d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00());
            dest.putFloat(offset + 4, (float)m.m10());
            dest.putFloat(offset + 8, (float)m.m20());
            dest.putFloat(offset + 12, (float)m.m30());
            dest.putFloat(offset + 16, (float)m.m01());
            dest.putFloat(offset + 20, (float)m.m11());
            dest.putFloat(offset + 24, (float)m.m21());
            dest.putFloat(offset + 28, (float)m.m31());
            dest.putFloat(offset + 32, (float)m.m02());
            dest.putFloat(offset + 36, (float)m.m12());
            dest.putFloat(offset + 40, (float)m.m22());
            dest.putFloat(offset + 44, (float)m.m32());
        }

        @Override
        final void putfTransposed(Matrix4d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00());
            dest.put(offset + 1, (float)m.m10());
            dest.put(offset + 2, (float)m.m20());
            dest.put(offset + 3, (float)m.m30());
            dest.put(offset + 4, (float)m.m01());
            dest.put(offset + 5, (float)m.m11());
            dest.put(offset + 6, (float)m.m21());
            dest.put(offset + 7, (float)m.m31());
            dest.put(offset + 8, (float)m.m02());
            dest.put(offset + 9, (float)m.m12());
            dest.put(offset + 10, (float)m.m22());
            dest.put(offset + 11, (float)m.m32());
            dest.put(offset + 12, (float)m.m03());
            dest.put(offset + 13, (float)m.m13());
            dest.put(offset + 14, (float)m.m23());
            dest.put(offset + 15, (float)m.m33());
        }

        @Override
        final void putfTransposed(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00());
            dest.putFloat(offset + 4, (float)m.m10());
            dest.putFloat(offset + 8, (float)m.m20());
            dest.putFloat(offset + 12, (float)m.m30());
            dest.putFloat(offset + 16, (float)m.m01());
            dest.putFloat(offset + 20, (float)m.m11());
            dest.putFloat(offset + 24, (float)m.m21());
            dest.putFloat(offset + 28, (float)m.m31());
            dest.putFloat(offset + 32, (float)m.m02());
            dest.putFloat(offset + 36, (float)m.m12());
            dest.putFloat(offset + 40, (float)m.m22());
            dest.putFloat(offset + 44, (float)m.m32());
            dest.putFloat(offset + 48, (float)m.m03());
            dest.putFloat(offset + 52, (float)m.m13());
            dest.putFloat(offset + 56, (float)m.m23());
            dest.putFloat(offset + 60, (float)m.m33());
        }

        @Override
        final void put(Matrix3f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m10);
            dest.put(offset + 4, m.m11);
            dest.put(offset + 5, m.m12);
            dest.put(offset + 6, m.m20);
            dest.put(offset + 7, m.m21);
            dest.put(offset + 8, m.m22);
        }

        @Override
        final void put(Matrix3f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m01);
            dest.putFloat(offset + 8, m.m02);
            dest.putFloat(offset + 12, m.m10);
            dest.putFloat(offset + 16, m.m11);
            dest.putFloat(offset + 20, m.m12);
            dest.putFloat(offset + 24, m.m20);
            dest.putFloat(offset + 28, m.m21);
            dest.putFloat(offset + 32, m.m22);
        }

        @Override
        final void put(Matrix3d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m10);
            dest.put(offset + 4, m.m11);
            dest.put(offset + 5, m.m12);
            dest.put(offset + 6, m.m20);
            dest.put(offset + 7, m.m21);
            dest.put(offset + 8, m.m22);
        }

        @Override
        final void put(Matrix3d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 8, m.m01);
            dest.putDouble(offset + 16, m.m02);
            dest.putDouble(offset + 24, m.m10);
            dest.putDouble(offset + 32, m.m11);
            dest.putDouble(offset + 40, m.m12);
            dest.putDouble(offset + 48, m.m20);
            dest.putDouble(offset + 56, m.m21);
            dest.putDouble(offset + 64, m.m22);
        }

        @Override
        final void putf(Matrix3d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00);
            dest.put(offset + 1, (float)m.m01);
            dest.put(offset + 2, (float)m.m02);
            dest.put(offset + 3, (float)m.m10);
            dest.put(offset + 4, (float)m.m11);
            dest.put(offset + 5, (float)m.m12);
            dest.put(offset + 6, (float)m.m20);
            dest.put(offset + 7, (float)m.m21);
            dest.put(offset + 8, (float)m.m22);
        }

        @Override
        final void putf(Matrix3d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00);
            dest.putFloat(offset + 4, (float)m.m01);
            dest.putFloat(offset + 8, (float)m.m02);
            dest.putFloat(offset + 12, (float)m.m10);
            dest.putFloat(offset + 16, (float)m.m11);
            dest.putFloat(offset + 20, (float)m.m12);
            dest.putFloat(offset + 24, (float)m.m20);
            dest.putFloat(offset + 28, (float)m.m21);
            dest.putFloat(offset + 32, (float)m.m22);
        }

        @Override
        final void get(Matrix4f m, int offset, FloatBuffer src) {
            m.m00(src.get(offset));
            m.m01(src.get(offset + 1));
            m.m02(src.get(offset + 2));
            m.m03(src.get(offset + 3));
            m.m10(src.get(offset + 4));
            m.m11(src.get(offset + 5));
            m.m12(src.get(offset + 6));
            m.m13(src.get(offset + 7));
            m.m20(src.get(offset + 8));
            m.m21(src.get(offset + 9));
            m.m22(src.get(offset + 10));
            m.m23(src.get(offset + 11));
            m.m30(src.get(offset + 12));
            m.m31(src.get(offset + 13));
            m.m32(src.get(offset + 14));
            m.m33(src.get(offset + 15));
        }

        @Override
        final void get(Matrix4f m, int offset, ByteBuffer src) {
            m.m00(src.getFloat(offset));
            m.m01(src.getFloat(offset + 4));
            m.m02(src.getFloat(offset + 8));
            m.m03(src.getFloat(offset + 12));
            m.m10(src.getFloat(offset + 16));
            m.m11(src.getFloat(offset + 20));
            m.m12(src.getFloat(offset + 24));
            m.m13(src.getFloat(offset + 28));
            m.m20(src.getFloat(offset + 32));
            m.m21(src.getFloat(offset + 36));
            m.m22(src.getFloat(offset + 40));
            m.m23(src.getFloat(offset + 44));
            m.m30(src.getFloat(offset + 48));
            m.m31(src.getFloat(offset + 52));
            m.m32(src.getFloat(offset + 56));
            m.m33(src.getFloat(offset + 60));
        }

        @Override
        final void get(Matrix4x3f m, int offset, FloatBuffer src) {
            m.m00(src.get(offset));
            m.m01(src.get(offset + 1));
            m.m02(src.get(offset + 2));
            m.m10(src.get(offset + 3));
            m.m11(src.get(offset + 4));
            m.m12(src.get(offset + 5));
            m.m20(src.get(offset + 6));
            m.m21(src.get(offset + 7));
            m.m22(src.get(offset + 8));
            m.m30(src.get(offset + 9));
            m.m31(src.get(offset + 10));
            m.m32(src.get(offset + 11));
        }

        @Override
        final void get(Matrix4x3f m, int offset, ByteBuffer src) {
            m.m00(src.getFloat(offset));
            m.m01(src.getFloat(offset + 4));
            m.m02(src.getFloat(offset + 8));
            m.m10(src.getFloat(offset + 12));
            m.m11(src.getFloat(offset + 16));
            m.m12(src.getFloat(offset + 20));
            m.m20(src.getFloat(offset + 24));
            m.m21(src.getFloat(offset + 28));
            m.m22(src.getFloat(offset + 32));
            m.m30(src.getFloat(offset + 36));
            m.m31(src.getFloat(offset + 40));
            m.m32(src.getFloat(offset + 44));
        }

        @Override
        final void get(Matrix4d m, int offset, DoubleBuffer src) {
            m.m00(src.get(offset));
            m.m01(src.get(offset + 1));
            m.m02(src.get(offset + 2));
            m.m03(src.get(offset + 3));
            m.m10(src.get(offset + 4));
            m.m11(src.get(offset + 5));
            m.m12(src.get(offset + 6));
            m.m13(src.get(offset + 7));
            m.m20(src.get(offset + 8));
            m.m21(src.get(offset + 9));
            m.m22(src.get(offset + 10));
            m.m23(src.get(offset + 11));
            m.m30(src.get(offset + 12));
            m.m31(src.get(offset + 13));
            m.m32(src.get(offset + 14));
            m.m33(src.get(offset + 15));
        }

        @Override
        final void get(Matrix4d m, int offset, ByteBuffer src) {
            m.m00(src.getDouble(offset));
            m.m01(src.getDouble(offset + 8));
            m.m02(src.getDouble(offset + 16));
            m.m03(src.getDouble(offset + 24));
            m.m10(src.getDouble(offset + 32));
            m.m11(src.getDouble(offset + 40));
            m.m12(src.getDouble(offset + 48));
            m.m13(src.getDouble(offset + 56));
            m.m20(src.getDouble(offset + 64));
            m.m21(src.getDouble(offset + 72));
            m.m22(src.getDouble(offset + 80));
            m.m23(src.getDouble(offset + 88));
            m.m30(src.getDouble(offset + 96));
            m.m31(src.getDouble(offset + 104));
            m.m32(src.getDouble(offset + 112));
            m.m33(src.getDouble(offset + 120));
        }

        @Override
        final void get(Matrix4x3d m, int offset, DoubleBuffer src) {
            m.m00(src.get(offset));
            m.m01(src.get(offset + 1));
            m.m02(src.get(offset + 2));
            m.m10(src.get(offset + 3));
            m.m11(src.get(offset + 4));
            m.m12(src.get(offset + 5));
            m.m20(src.get(offset + 6));
            m.m21(src.get(offset + 7));
            m.m22(src.get(offset + 8));
            m.m30(src.get(offset + 9));
            m.m31(src.get(offset + 10));
            m.m32(src.get(offset + 11));
        }

        @Override
        final void get(Matrix4x3d m, int offset, ByteBuffer src) {
            m.m00(src.getDouble(offset));
            m.m01(src.getDouble(offset + 8));
            m.m02(src.getDouble(offset + 16));
            m.m10(src.getDouble(offset + 24));
            m.m11(src.getDouble(offset + 32));
            m.m12(src.getDouble(offset + 40));
            m.m20(src.getDouble(offset + 48));
            m.m21(src.getDouble(offset + 56));
            m.m22(src.getDouble(offset + 64));
            m.m30(src.getDouble(offset + 72));
            m.m31(src.getDouble(offset + 80));
            m.m32(src.getDouble(offset + 88));
        }

        @Override
        final void getf(Matrix4d m, int offset, FloatBuffer src) {
            m.m00(src.get(offset));
            m.m01(src.get(offset + 1));
            m.m02(src.get(offset + 2));
            m.m03(src.get(offset + 3));
            m.m10(src.get(offset + 4));
            m.m11(src.get(offset + 5));
            m.m12(src.get(offset + 6));
            m.m13(src.get(offset + 7));
            m.m20(src.get(offset + 8));
            m.m21(src.get(offset + 9));
            m.m22(src.get(offset + 10));
            m.m23(src.get(offset + 11));
            m.m30(src.get(offset + 12));
            m.m31(src.get(offset + 13));
            m.m32(src.get(offset + 14));
            m.m33(src.get(offset + 15));
        }

        @Override
        final void getf(Matrix4d m, int offset, ByteBuffer src) {
            m.m00(src.getFloat(offset));
            m.m01(src.getFloat(offset + 4));
            m.m02(src.getFloat(offset + 8));
            m.m03(src.getFloat(offset + 12));
            m.m10(src.getFloat(offset + 16));
            m.m11(src.getFloat(offset + 20));
            m.m12(src.getFloat(offset + 24));
            m.m13(src.getFloat(offset + 28));
            m.m20(src.getFloat(offset + 32));
            m.m21(src.getFloat(offset + 36));
            m.m22(src.getFloat(offset + 40));
            m.m23(src.getFloat(offset + 44));
            m.m30(src.getFloat(offset + 48));
            m.m31(src.getFloat(offset + 52));
            m.m32(src.getFloat(offset + 56));
            m.m33(src.getFloat(offset + 60));
        }

        @Override
        final void getf(Matrix4x3d m, int offset, FloatBuffer src) {
            m.m00(src.get(offset));
            m.m01(src.get(offset + 1));
            m.m02(src.get(offset + 2));
            m.m10(src.get(offset + 3));
            m.m11(src.get(offset + 4));
            m.m12(src.get(offset + 5));
            m.m20(src.get(offset + 6));
            m.m21(src.get(offset + 7));
            m.m22(src.get(offset + 8));
            m.m30(src.get(offset + 9));
            m.m31(src.get(offset + 10));
            m.m32(src.get(offset + 11));
        }

        @Override
        final void getf(Matrix4x3d m, int offset, ByteBuffer src) {
            m.m00(src.getFloat(offset));
            m.m01(src.getFloat(offset + 4));
            m.m02(src.getFloat(offset + 8));
            m.m10(src.getFloat(offset + 12));
            m.m11(src.getFloat(offset + 16));
            m.m12(src.getFloat(offset + 20));
            m.m20(src.getFloat(offset + 24));
            m.m21(src.getFloat(offset + 28));
            m.m22(src.getFloat(offset + 32));
            m.m30(src.getFloat(offset + 36));
            m.m31(src.getFloat(offset + 40));
            m.m32(src.getFloat(offset + 44));
        }

        @Override
        final void get(Matrix3f m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
        }

        @Override
        final void get(Matrix3f m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m10 = src.getFloat(offset + 12);
            m.m11 = src.getFloat(offset + 16);
            m.m12 = src.getFloat(offset + 20);
            m.m20 = src.getFloat(offset + 24);
            m.m21 = src.getFloat(offset + 28);
            m.m22 = src.getFloat(offset + 32);
        }

        @Override
        final void get(Matrix3d m, int offset, DoubleBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
        }

        @Override
        final void get(Matrix3d m, int offset, ByteBuffer src) {
            m.m00 = src.getDouble(offset);
            m.m01 = src.getDouble(offset + 8);
            m.m02 = src.getDouble(offset + 16);
            m.m10 = src.getDouble(offset + 24);
            m.m11 = src.getDouble(offset + 32);
            m.m12 = src.getDouble(offset + 40);
            m.m20 = src.getDouble(offset + 48);
            m.m21 = src.getDouble(offset + 56);
            m.m22 = src.getDouble(offset + 64);
        }

        @Override
        final void getf(Matrix3d m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
        }

        @Override
        final void getf(Matrix3d m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m10 = src.getFloat(offset + 12);
            m.m11 = src.getFloat(offset + 16);
            m.m12 = src.getFloat(offset + 20);
            m.m20 = src.getFloat(offset + 24);
            m.m21 = src.getFloat(offset + 28);
            m.m22 = src.getFloat(offset + 32);
        }
    }
}

