/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkSurfaceCapabilitiesKHR
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MINIMAGECOUNT;
    public static final int MAXIMAGECOUNT;
    public static final int CURRENTEXTENT;
    public static final int MINIMAGEEXTENT;
    public static final int MAXIMAGEEXTENT;
    public static final int MAXIMAGEARRAYLAYERS;
    public static final int SUPPORTEDTRANSFORMS;
    public static final int CURRENTTRANSFORM;
    public static final int SUPPORTEDCOMPOSITEALPHA;
    public static final int SUPPORTEDUSAGEFLAGS;

    VkSurfaceCapabilitiesKHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSurfaceCapabilitiesKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSurfaceCapabilitiesKHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int minImageCount() {
        return VkSurfaceCapabilitiesKHR.nminImageCount(this.address());
    }

    public int maxImageCount() {
        return VkSurfaceCapabilitiesKHR.nmaxImageCount(this.address());
    }

    public VkExtent2D currentExtent() {
        return VkSurfaceCapabilitiesKHR.ncurrentExtent(this.address());
    }

    public VkExtent2D minImageExtent() {
        return VkSurfaceCapabilitiesKHR.nminImageExtent(this.address());
    }

    public VkExtent2D maxImageExtent() {
        return VkSurfaceCapabilitiesKHR.nmaxImageExtent(this.address());
    }

    public int maxImageArrayLayers() {
        return VkSurfaceCapabilitiesKHR.nmaxImageArrayLayers(this.address());
    }

    public int supportedTransforms() {
        return VkSurfaceCapabilitiesKHR.nsupportedTransforms(this.address());
    }

    public int currentTransform() {
        return VkSurfaceCapabilitiesKHR.ncurrentTransform(this.address());
    }

    public int supportedCompositeAlpha() {
        return VkSurfaceCapabilitiesKHR.nsupportedCompositeAlpha(this.address());
    }

    public int supportedUsageFlags() {
        return VkSurfaceCapabilitiesKHR.nsupportedUsageFlags(this.address());
    }

    public static VkSurfaceCapabilitiesKHR malloc() {
        return VkSurfaceCapabilitiesKHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSurfaceCapabilitiesKHR calloc() {
        return VkSurfaceCapabilitiesKHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSurfaceCapabilitiesKHR create() {
        return new VkSurfaceCapabilitiesKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSurfaceCapabilitiesKHR create(long address) {
        return address == 0L ? null : new VkSurfaceCapabilitiesKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSurfaceCapabilitiesKHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSurfaceCapabilitiesKHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSurfaceCapabilitiesKHR mallocStack() {
        return VkSurfaceCapabilitiesKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSurfaceCapabilitiesKHR callocStack() {
        return VkSurfaceCapabilitiesKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSurfaceCapabilitiesKHR mallocStack(MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSurfaceCapabilitiesKHR callocStack(MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSurfaceCapabilitiesKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSurfaceCapabilitiesKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nminImageCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINIMAGECOUNT);
    }

    public static int nmaxImageCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXIMAGECOUNT);
    }

    public static VkExtent2D ncurrentExtent(long struct) {
        return VkExtent2D.create(struct + (long)CURRENTEXTENT);
    }

    public static VkExtent2D nminImageExtent(long struct) {
        return VkExtent2D.create(struct + (long)MINIMAGEEXTENT);
    }

    public static VkExtent2D nmaxImageExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXIMAGEEXTENT);
    }

    public static int nmaxImageArrayLayers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXIMAGEARRAYLAYERS);
    }

    public static int nsupportedTransforms(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDTRANSFORMS);
    }

    public static int ncurrentTransform(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURRENTTRANSFORM);
    }

    public static int nsupportedCompositeAlpha(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDCOMPOSITEALPHA);
    }

    public static int nsupportedUsageFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDUSAGEFLAGS);
    }

    static {
        Struct.Layout layout = VkSurfaceCapabilitiesKHR.__struct(VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MINIMAGECOUNT = layout.offsetof(0);
        MAXIMAGECOUNT = layout.offsetof(1);
        CURRENTEXTENT = layout.offsetof(2);
        MINIMAGEEXTENT = layout.offsetof(3);
        MAXIMAGEEXTENT = layout.offsetof(4);
        MAXIMAGEARRAYLAYERS = layout.offsetof(5);
        SUPPORTEDTRANSFORMS = layout.offsetof(6);
        CURRENTTRANSFORM = layout.offsetof(7);
        SUPPORTEDCOMPOSITEALPHA = layout.offsetof(8);
        SUPPORTEDUSAGEFLAGS = layout.offsetof(9);
    }

    public static final class Buffer
    extends StructBuffer<VkSurfaceCapabilitiesKHR, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSurfaceCapabilitiesKHR newInstance(long address) {
            return new VkSurfaceCapabilitiesKHR(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int minImageCount() {
            return VkSurfaceCapabilitiesKHR.nminImageCount(this.address());
        }

        public int maxImageCount() {
            return VkSurfaceCapabilitiesKHR.nmaxImageCount(this.address());
        }

        public VkExtent2D currentExtent() {
            return VkSurfaceCapabilitiesKHR.ncurrentExtent(this.address());
        }

        public VkExtent2D minImageExtent() {
            return VkSurfaceCapabilitiesKHR.nminImageExtent(this.address());
        }

        public VkExtent2D maxImageExtent() {
            return VkSurfaceCapabilitiesKHR.nmaxImageExtent(this.address());
        }

        public int maxImageArrayLayers() {
            return VkSurfaceCapabilitiesKHR.nmaxImageArrayLayers(this.address());
        }

        public int supportedTransforms() {
            return VkSurfaceCapabilitiesKHR.nsupportedTransforms(this.address());
        }

        public int currentTransform() {
            return VkSurfaceCapabilitiesKHR.ncurrentTransform(this.address());
        }

        public int supportedCompositeAlpha() {
            return VkSurfaceCapabilitiesKHR.nsupportedCompositeAlpha(this.address());
        }

        public int supportedUsageFlags() {
            return VkSurfaceCapabilitiesKHR.nsupportedUsageFlags(this.address());
        }
    }
}

