/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceSparseProperties
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESIDENCYSTANDARD2DBLOCKSHAPE;
    public static final int RESIDENCYSTANDARD2DMULTISAMPLEBLOCKSHAPE;
    public static final int RESIDENCYSTANDARD3DBLOCKSHAPE;
    public static final int RESIDENCYALIGNEDMIPSIZE;
    public static final int RESIDENCYNONRESIDENTSTRICT;

    VkPhysicalDeviceSparseProperties(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPhysicalDeviceSparseProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPhysicalDeviceSparseProperties.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int residencyStandard2DBlockShape() {
        return VkPhysicalDeviceSparseProperties.nresidencyStandard2DBlockShape(this.address());
    }

    public int residencyStandard2DMultisampleBlockShape() {
        return VkPhysicalDeviceSparseProperties.nresidencyStandard2DMultisampleBlockShape(this.address());
    }

    public int residencyStandard3DBlockShape() {
        return VkPhysicalDeviceSparseProperties.nresidencyStandard3DBlockShape(this.address());
    }

    public int residencyAlignedMipSize() {
        return VkPhysicalDeviceSparseProperties.nresidencyAlignedMipSize(this.address());
    }

    public int residencyNonResidentStrict() {
        return VkPhysicalDeviceSparseProperties.nresidencyNonResidentStrict(this.address());
    }

    public static VkPhysicalDeviceSparseProperties malloc() {
        return VkPhysicalDeviceSparseProperties.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPhysicalDeviceSparseProperties calloc() {
        return VkPhysicalDeviceSparseProperties.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPhysicalDeviceSparseProperties create() {
        return new VkPhysicalDeviceSparseProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPhysicalDeviceSparseProperties create(long address) {
        return address == 0L ? null : new VkPhysicalDeviceSparseProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceSparseProperties.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceSparseProperties.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPhysicalDeviceSparseProperties mallocStack() {
        return VkPhysicalDeviceSparseProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceSparseProperties callocStack() {
        return VkPhysicalDeviceSparseProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceSparseProperties mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceSparseProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceSparseProperties callocStack(MemoryStack stack) {
        return VkPhysicalDeviceSparseProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceSparseProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceSparseProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceSparseProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceSparseProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nresidencyStandard2DBlockShape(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESIDENCYSTANDARD2DBLOCKSHAPE);
    }

    public static int nresidencyStandard2DMultisampleBlockShape(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESIDENCYSTANDARD2DMULTISAMPLEBLOCKSHAPE);
    }

    public static int nresidencyStandard3DBlockShape(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESIDENCYSTANDARD3DBLOCKSHAPE);
    }

    public static int nresidencyAlignedMipSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESIDENCYALIGNEDMIPSIZE);
    }

    public static int nresidencyNonResidentStrict(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESIDENCYNONRESIDENTSTRICT);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceSparseProperties.__struct(VkPhysicalDeviceSparseProperties.__member(4), VkPhysicalDeviceSparseProperties.__member(4), VkPhysicalDeviceSparseProperties.__member(4), VkPhysicalDeviceSparseProperties.__member(4), VkPhysicalDeviceSparseProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESIDENCYSTANDARD2DBLOCKSHAPE = layout.offsetof(0);
        RESIDENCYSTANDARD2DMULTISAMPLEBLOCKSHAPE = layout.offsetof(1);
        RESIDENCYSTANDARD3DBLOCKSHAPE = layout.offsetof(2);
        RESIDENCYALIGNEDMIPSIZE = layout.offsetof(3);
        RESIDENCYNONRESIDENTSTRICT = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<VkPhysicalDeviceSparseProperties, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPhysicalDeviceSparseProperties newInstance(long address) {
            return new VkPhysicalDeviceSparseProperties(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int residencyStandard2DBlockShape() {
            return VkPhysicalDeviceSparseProperties.nresidencyStandard2DBlockShape(this.address());
        }

        public int residencyStandard2DMultisampleBlockShape() {
            return VkPhysicalDeviceSparseProperties.nresidencyStandard2DMultisampleBlockShape(this.address());
        }

        public int residencyStandard3DBlockShape() {
            return VkPhysicalDeviceSparseProperties.nresidencyStandard3DBlockShape(this.address());
        }

        public int residencyAlignedMipSize() {
            return VkPhysicalDeviceSparseProperties.nresidencyAlignedMipSize(this.address());
        }

        public int residencyNonResidentStrict() {
            return VkPhysicalDeviceSparseProperties.nresidencyNonResidentStrict(this.address());
        }
    }
}

