/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.DispatchableHandle;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VKCapabilities;
import org.lwjgl.vulkan.VKUtil;
import org.lwjgl.vulkan.VkApplicationInfo;
import org.lwjgl.vulkan.VkInstanceCreateInfo;

public class VkInstance
extends DispatchableHandle {
    public VkInstance(long handle, VkInstanceCreateInfo ci) {
        super(handle, VkInstance.getInstanceCapabilities(handle, ci));
    }

    private static VKCapabilities getInstanceCapabilities(long handle, VkInstanceCreateInfo ci) {
        VkApplicationInfo appInfo = ci.pApplicationInfo();
        int apiVersion = appInfo != null ? appInfo.apiVersion() : VKUtil.VK_MAKE_VERSION(1, 0, 0);
        long GetInstanceProcAddr = VK.getFunctionProvider().getFunctionAddress("vkGetInstanceProcAddr");
        if (GetInstanceProcAddr == 0L) {
            throw new IllegalStateException("A core Vulkan function is missing. Make sure that Vulkan is available.");
        }
        return new VKCapabilities(functionName -> {
            long address = VkInstance.GetInstanceProcAddr(GetInstanceProcAddr, handle, MemoryUtil.memAddress(functionName));
            if (address == 0L && (address = VK.getFunctionProvider().getFunctionAddress(functionName)) == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLog("Failed to locate address for VK instance function " + MemoryUtil.memASCII(functionName));
            }
            return address;
        }, apiVersion, VK.getEnabledExtensionSet(apiVersion, ci.ppEnabledExtensionNames()));
    }

    static long GetInstanceProcAddr(long __functionAddress, long handle, long functionName) {
        long address = JNI.callPPP(__functionAddress, handle, functionName);
        if (address == 0L) {
            address = JNI.callPPP(__functionAddress, 0L, functionName);
        }
        return address;
    }
}

