/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkComponentMapping;
import org.lwjgl.vulkan.VkImageSubresourceRange;

public class VkImageViewCreateInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int IMAGE;
    public static final int VIEWTYPE;
    public static final int FORMAT;
    public static final int COMPONENTS;
    public static final int SUBRESOURCERANGE;

    VkImageViewCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkImageViewCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageViewCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkImageViewCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkImageViewCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkImageViewCreateInfo.nflags(this.address());
    }

    public long image() {
        return VkImageViewCreateInfo.nimage(this.address());
    }

    public int viewType() {
        return VkImageViewCreateInfo.nviewType(this.address());
    }

    public int format() {
        return VkImageViewCreateInfo.nformat(this.address());
    }

    public VkComponentMapping components() {
        return VkImageViewCreateInfo.ncomponents(this.address());
    }

    public VkImageSubresourceRange subresourceRange() {
        return VkImageViewCreateInfo.nsubresourceRange(this.address());
    }

    public VkImageViewCreateInfo sType(int value) {
        VkImageViewCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo pNext(long value) {
        VkImageViewCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo flags(int value) {
        VkImageViewCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo image(long value) {
        VkImageViewCreateInfo.nimage(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo viewType(int value) {
        VkImageViewCreateInfo.nviewType(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo format(int value) {
        VkImageViewCreateInfo.nformat(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo components(VkComponentMapping value) {
        VkImageViewCreateInfo.ncomponents(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo subresourceRange(VkImageSubresourceRange value) {
        VkImageViewCreateInfo.nsubresourceRange(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo set(int sType, long pNext, int flags, long image, int viewType, int format, VkComponentMapping components, VkImageSubresourceRange subresourceRange) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.image(image);
        this.viewType(viewType);
        this.format(format);
        this.components(components);
        this.subresourceRange(subresourceRange);
        return this;
    }

    public VkImageViewCreateInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkImageViewCreateInfo set(VkImageViewCreateInfo src) {
        return this.nset(src.address());
    }

    public static VkImageViewCreateInfo malloc() {
        return VkImageViewCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkImageViewCreateInfo calloc() {
        return VkImageViewCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkImageViewCreateInfo create() {
        return new VkImageViewCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageViewCreateInfo create(long address) {
        return address == 0L ? null : new VkImageViewCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkImageViewCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageViewCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkImageViewCreateInfo mallocStack() {
        return VkImageViewCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageViewCreateInfo callocStack() {
        return VkImageViewCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkImageViewCreateInfo mallocStack(MemoryStack stack) {
        return VkImageViewCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageViewCreateInfo callocStack(MemoryStack stack) {
        return VkImageViewCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageViewCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageViewCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageViewCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageViewCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static int nviewType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIEWTYPE);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static VkComponentMapping ncomponents(long struct) {
        return VkComponentMapping.create(struct + (long)COMPONENTS);
    }

    public static VkImageSubresourceRange nsubresourceRange(long struct) {
        return VkImageSubresourceRange.create(struct + (long)SUBRESOURCERANGE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    public static void nviewType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VIEWTYPE, value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void ncomponents(long struct, VkComponentMapping value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COMPONENTS, VkComponentMapping.SIZEOF);
    }

    public static void nsubresourceRange(long struct, VkImageSubresourceRange value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SUBRESOURCERANGE, VkImageSubresourceRange.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageViewCreateInfo.__struct(VkImageViewCreateInfo.__member(4), VkImageViewCreateInfo.__member(POINTER_SIZE), VkImageViewCreateInfo.__member(4), VkImageViewCreateInfo.__member(8), VkImageViewCreateInfo.__member(4), VkImageViewCreateInfo.__member(4), VkImageViewCreateInfo.__member(VkComponentMapping.SIZEOF, VkComponentMapping.ALIGNOF), VkImageViewCreateInfo.__member(VkImageSubresourceRange.SIZEOF, VkImageSubresourceRange.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        IMAGE = layout.offsetof(3);
        VIEWTYPE = layout.offsetof(4);
        FORMAT = layout.offsetof(5);
        COMPONENTS = layout.offsetof(6);
        SUBRESOURCERANGE = layout.offsetof(7);
    }

    public static final class Buffer
    extends StructBuffer<VkImageViewCreateInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageViewCreateInfo newInstance(long address) {
            return new VkImageViewCreateInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkImageViewCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkImageViewCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkImageViewCreateInfo.nflags(this.address());
        }

        public long image() {
            return VkImageViewCreateInfo.nimage(this.address());
        }

        public int viewType() {
            return VkImageViewCreateInfo.nviewType(this.address());
        }

        public int format() {
            return VkImageViewCreateInfo.nformat(this.address());
        }

        public VkComponentMapping components() {
            return VkImageViewCreateInfo.ncomponents(this.address());
        }

        public VkImageSubresourceRange subresourceRange() {
            return VkImageViewCreateInfo.nsubresourceRange(this.address());
        }

        public Buffer sType(int value) {
            VkImageViewCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkImageViewCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkImageViewCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer image(long value) {
            VkImageViewCreateInfo.nimage(this.address(), value);
            return this;
        }

        public Buffer viewType(int value) {
            VkImageViewCreateInfo.nviewType(this.address(), value);
            return this;
        }

        public Buffer format(int value) {
            VkImageViewCreateInfo.nformat(this.address(), value);
            return this;
        }

        public Buffer components(VkComponentMapping value) {
            VkImageViewCreateInfo.ncomponents(this.address(), value);
            return this;
        }

        public Buffer subresourceRange(VkImageSubresourceRange value) {
            VkImageViewCreateInfo.nsubresourceRange(this.address(), value);
            return this;
        }
    }
}

