/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkDisplayPropertiesKHR
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DISPLAY;
    public static final int DISPLAYNAME;
    public static final int PHYSICALDIMENSIONS;
    public static final int PHYSICALRESOLUTION;
    public static final int SUPPORTEDTRANSFORMS;
    public static final int PLANEREORDERPOSSIBLE;
    public static final int PERSISTENTCONTENT;

    VkDisplayPropertiesKHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDisplayPropertiesKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDisplayPropertiesKHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long display() {
        return VkDisplayPropertiesKHR.ndisplay(this.address());
    }

    public ByteBuffer displayName() {
        return VkDisplayPropertiesKHR.ndisplayName(this.address());
    }

    public String displayNameString() {
        return VkDisplayPropertiesKHR.ndisplayNameString(this.address());
    }

    public VkExtent2D physicalDimensions() {
        return VkDisplayPropertiesKHR.nphysicalDimensions(this.address());
    }

    public VkExtent2D physicalResolution() {
        return VkDisplayPropertiesKHR.nphysicalResolution(this.address());
    }

    public int supportedTransforms() {
        return VkDisplayPropertiesKHR.nsupportedTransforms(this.address());
    }

    public int planeReorderPossible() {
        return VkDisplayPropertiesKHR.nplaneReorderPossible(this.address());
    }

    public int persistentContent() {
        return VkDisplayPropertiesKHR.npersistentContent(this.address());
    }

    public static VkDisplayPropertiesKHR malloc() {
        return VkDisplayPropertiesKHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDisplayPropertiesKHR calloc() {
        return VkDisplayPropertiesKHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDisplayPropertiesKHR create() {
        return new VkDisplayPropertiesKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDisplayPropertiesKHR create(long address) {
        return address == 0L ? null : new VkDisplayPropertiesKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDisplayPropertiesKHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDisplayPropertiesKHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDisplayPropertiesKHR mallocStack() {
        return VkDisplayPropertiesKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDisplayPropertiesKHR callocStack() {
        return VkDisplayPropertiesKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDisplayPropertiesKHR mallocStack(MemoryStack stack) {
        return VkDisplayPropertiesKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayPropertiesKHR callocStack(MemoryStack stack) {
        return VkDisplayPropertiesKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDisplayPropertiesKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDisplayPropertiesKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayPropertiesKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayPropertiesKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndisplay(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DISPLAY);
    }

    public static ByteBuffer ndisplayName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)DISPLAYNAME));
    }

    public static String ndisplayNameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)DISPLAYNAME));
    }

    public static VkExtent2D nphysicalDimensions(long struct) {
        return VkExtent2D.create(struct + (long)PHYSICALDIMENSIONS);
    }

    public static VkExtent2D nphysicalResolution(long struct) {
        return VkExtent2D.create(struct + (long)PHYSICALRESOLUTION);
    }

    public static int nsupportedTransforms(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDTRANSFORMS);
    }

    public static int nplaneReorderPossible(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PLANEREORDERPOSSIBLE);
    }

    public static int npersistentContent(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PERSISTENTCONTENT);
    }

    static {
        Struct.Layout layout = VkDisplayPropertiesKHR.__struct(VkDisplayPropertiesKHR.__member(8), VkDisplayPropertiesKHR.__member(POINTER_SIZE), VkDisplayPropertiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkDisplayPropertiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkDisplayPropertiesKHR.__member(4), VkDisplayPropertiesKHR.__member(4), VkDisplayPropertiesKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DISPLAY = layout.offsetof(0);
        DISPLAYNAME = layout.offsetof(1);
        PHYSICALDIMENSIONS = layout.offsetof(2);
        PHYSICALRESOLUTION = layout.offsetof(3);
        SUPPORTEDTRANSFORMS = layout.offsetof(4);
        PLANEREORDERPOSSIBLE = layout.offsetof(5);
        PERSISTENTCONTENT = layout.offsetof(6);
    }

    public static final class Buffer
    extends StructBuffer<VkDisplayPropertiesKHR, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDisplayPropertiesKHR newInstance(long address) {
            return new VkDisplayPropertiesKHR(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long display() {
            return VkDisplayPropertiesKHR.ndisplay(this.address());
        }

        public ByteBuffer displayName() {
            return VkDisplayPropertiesKHR.ndisplayName(this.address());
        }

        public String displayNameString() {
            return VkDisplayPropertiesKHR.ndisplayNameString(this.address());
        }

        public VkExtent2D physicalDimensions() {
            return VkDisplayPropertiesKHR.nphysicalDimensions(this.address());
        }

        public VkExtent2D physicalResolution() {
            return VkDisplayPropertiesKHR.nphysicalResolution(this.address());
        }

        public int supportedTransforms() {
            return VkDisplayPropertiesKHR.nsupportedTransforms(this.address());
        }

        public int planeReorderPossible() {
            return VkDisplayPropertiesKHR.nplaneReorderPossible(this.address());
        }

        public int persistentContent() {
            return VkDisplayPropertiesKHR.npersistentContent(this.address());
        }
    }
}

