/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.vulkan.VKCapabilities;
import org.lwjgl.vulkan.VKUtil;

public final class VK {
    private static FunctionProvider functionProvider;
    private static VKCapabilities globalCommands;

    private VK() {
    }

    public static void create() {
        SharedLibrary VK2;
        switch (Platform.get()) {
            case LINUX: {
                VK2 = Library.loadNative(Configuration.VULKAN_LIBRARY_NAME, "libvulkan.so.1");
                break;
            }
            case WINDOWS: {
                VK2 = Library.loadNative(Configuration.VULKAN_LIBRARY_NAME, "vulkan-1");
                break;
            }
            case MACOSX: {
                VK2 = Library.loadNative(Configuration.VULKAN_LIBRARY_NAME, new String[0]);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        VK.create(VK2);
    }

    public static void create(String libName) {
        VK.create(Library.loadNative(libName));
    }

    private static void create(SharedLibrary VULKAN) {
        try {
            VK.create((FunctionProvider)new SharedLibrary.Delegate(VULKAN){
                private final long GetInstanceProcAddr;
                {
                    this.GetInstanceProcAddr = this.library.getFunctionAddress("vkGetInstanceProcAddr");
                    if (this.GetInstanceProcAddr == 0L) {
                        throw new IllegalStateException("A core Vulkan function is missing. Make sure that Vulkan is available.");
                    }
                }

                @Override
                public long getFunctionAddress(ByteBuffer functionName) {
                    long address = JNI.callPPP(this.GetInstanceProcAddr, 0L, MemoryUtil.memAddress(functionName));
                    if (address == 0L && (address = this.library.getFunctionAddress(functionName)) == 0L && Checks.DEBUG_FUNCTIONS) {
                        APIUtil.apiLog("Failed to locate address for VK function " + MemoryUtil.memASCII(functionName));
                    }
                    return address;
                }
            });
        }
        catch (RuntimeException e) {
            VULKAN.free();
            throw e;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (VK.functionProvider != null) {
            throw new IllegalStateException("Vulkan has already been created.");
        }
        VK.functionProvider = functionProvider;
        globalCommands = new VKCapabilities(functionProvider, 0, Collections.emptySet());
        if (VK.globalCommands.vkCreateInstance == 0L || VK.globalCommands.vkEnumerateInstanceExtensionProperties == 0L || VK.globalCommands.vkEnumerateInstanceLayerProperties == 0L) {
            throw new IllegalStateException("Vulkan 1.0 is missing. Make sure that Vulkan is available.");
        }
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
        globalCommands = null;
    }

    public static FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    static VKCapabilities getGlobalCommands() {
        return globalCommands;
    }

    static Set<String> getEnabledExtensionSet(int apiVersion, PointerBuffer extensionNames) {
        HashSet<String> enabledExtensions = new HashSet<String>(16);
        int majorVersion = VKUtil.VK_VERSION_MAJOR(apiVersion);
        int minorVersion = VKUtil.VK_VERSION_MINOR(apiVersion);
        int[] VK_VERSIONS = new int[]{0};
        int maxMajor = Math.min(majorVersion, VK_VERSIONS.length);
        for (int M = 1; M <= maxMajor; ++M) {
            int maxMinor = VK_VERSIONS[M - 1];
            if (M == majorVersion) {
                maxMinor = Math.min(minorVersion, maxMinor);
            }
            for (int m = 0; m <= maxMinor; ++m) {
                enabledExtensions.add(String.format("Vulkan%d%d", M, m));
            }
        }
        if (extensionNames != null) {
            for (int i = extensionNames.position(); i < extensionNames.limit(); ++i) {
                enabledExtensions.add(extensionNames.getStringUTF8(i));
            }
        }
        return enabledExtensions;
    }

    static <T> T checkExtension(String extension, T functions) {
        if (functions != null) {
            return functions;
        }
        APIUtil.apiLog("[VK] " + extension + " was reported as available but an entry point is missing.");
        return null;
    }

    static {
        if (!Configuration.VULKAN_EXPLICIT_INIT.get(false).booleanValue()) {
            VK.create();
        }
    }
}

