/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.linux.Visual;

public class XVisualInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VISUAL;
    public static final int VISUALID;
    public static final int SCREEN;
    public static final int DEPTH;
    public static final int CLASS;
    public static final int RED_MASK;
    public static final int GREEN_MASK;
    public static final int BLUE_MASK;
    public static final int COLORMAP_SIZE;
    public static final int BITS_PER_RGB;

    XVisualInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public XVisualInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), XVisualInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public Visual visual() {
        return XVisualInfo.nvisual(this.address());
    }

    public long visualid() {
        return XVisualInfo.nvisualid(this.address());
    }

    public int screen() {
        return XVisualInfo.nscreen(this.address());
    }

    public int depth() {
        return XVisualInfo.ndepth(this.address());
    }

    public int class$() {
        return XVisualInfo.nclass$(this.address());
    }

    public long red_mask() {
        return XVisualInfo.nred_mask(this.address());
    }

    public long green_mask() {
        return XVisualInfo.ngreen_mask(this.address());
    }

    public long blue_mask() {
        return XVisualInfo.nblue_mask(this.address());
    }

    public int colormap_size() {
        return XVisualInfo.ncolormap_size(this.address());
    }

    public int bits_per_rgb() {
        return XVisualInfo.nbits_per_rgb(this.address());
    }

    public XVisualInfo visual(Visual value) {
        XVisualInfo.nvisual(this.address(), value);
        return this;
    }

    public XVisualInfo visualid(long value) {
        XVisualInfo.nvisualid(this.address(), value);
        return this;
    }

    public XVisualInfo screen(int value) {
        XVisualInfo.nscreen(this.address(), value);
        return this;
    }

    public XVisualInfo depth(int value) {
        XVisualInfo.ndepth(this.address(), value);
        return this;
    }

    public XVisualInfo class$(int value) {
        XVisualInfo.nclass$(this.address(), value);
        return this;
    }

    public XVisualInfo red_mask(long value) {
        XVisualInfo.nred_mask(this.address(), value);
        return this;
    }

    public XVisualInfo green_mask(long value) {
        XVisualInfo.ngreen_mask(this.address(), value);
        return this;
    }

    public XVisualInfo blue_mask(long value) {
        XVisualInfo.nblue_mask(this.address(), value);
        return this;
    }

    public XVisualInfo colormap_size(int value) {
        XVisualInfo.ncolormap_size(this.address(), value);
        return this;
    }

    public XVisualInfo bits_per_rgb(int value) {
        XVisualInfo.nbits_per_rgb(this.address(), value);
        return this;
    }

    public XVisualInfo set(Visual visual, long visualid, int screen, int depth, int class$, long red_mask, long green_mask, long blue_mask, int colormap_size, int bits_per_rgb) {
        this.visual(visual);
        this.visualid(visualid);
        this.screen(screen);
        this.depth(depth);
        this.class$(class$);
        this.red_mask(red_mask);
        this.green_mask(green_mask);
        this.blue_mask(blue_mask);
        this.colormap_size(colormap_size);
        this.bits_per_rgb(bits_per_rgb);
        return this;
    }

    public XVisualInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public XVisualInfo set(XVisualInfo src) {
        return this.nset(src.address());
    }

    public static XVisualInfo malloc() {
        return XVisualInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static XVisualInfo calloc() {
        return XVisualInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static XVisualInfo create() {
        return new XVisualInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static XVisualInfo create(long address) {
        return address == 0L ? null : new XVisualInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return XVisualInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XVisualInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static XVisualInfo mallocStack() {
        return XVisualInfo.mallocStack(MemoryStack.stackGet());
    }

    public static XVisualInfo callocStack() {
        return XVisualInfo.callocStack(MemoryStack.stackGet());
    }

    public static XVisualInfo mallocStack(MemoryStack stack) {
        return XVisualInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XVisualInfo callocStack(MemoryStack stack) {
        return XVisualInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return XVisualInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return XVisualInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XVisualInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XVisualInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static Visual nvisual(long struct) {
        return Visual.create(MemoryUtil.memGetAddress(struct + (long)VISUAL));
    }

    public static long nvisualid(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VISUALID);
    }

    public static int nscreen(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SCREEN);
    }

    public static int ndepth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTH);
    }

    public static int nclass$(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CLASS);
    }

    public static long nred_mask(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RED_MASK);
    }

    public static long ngreen_mask(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)GREEN_MASK);
    }

    public static long nblue_mask(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BLUE_MASK);
    }

    public static int ncolormap_size(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLORMAP_SIZE);
    }

    public static int nbits_per_rgb(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BITS_PER_RGB);
    }

    public static void nvisual(long struct, Visual value) {
        MemoryUtil.memPutAddress(struct + (long)VISUAL, value.address());
    }

    public static void nvisualid(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VISUALID, value);
    }

    public static void nscreen(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SCREEN, value);
    }

    public static void ndepth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTH, value);
    }

    public static void nclass$(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CLASS, value);
    }

    public static void nred_mask(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RED_MASK, value);
    }

    public static void ngreen_mask(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)GREEN_MASK, value);
    }

    public static void nblue_mask(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)BLUE_MASK, value);
    }

    public static void ncolormap_size(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COLORMAP_SIZE, value);
    }

    public static void nbits_per_rgb(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BITS_PER_RGB, value);
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)VISUAL));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            XVisualInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = XVisualInfo.__struct(XVisualInfo.__member(POINTER_SIZE), XVisualInfo.__member(POINTER_SIZE), XVisualInfo.__member(4), XVisualInfo.__member(4), XVisualInfo.__member(4), XVisualInfo.__member(POINTER_SIZE), XVisualInfo.__member(POINTER_SIZE), XVisualInfo.__member(POINTER_SIZE), XVisualInfo.__member(4), XVisualInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VISUAL = layout.offsetof(0);
        VISUALID = layout.offsetof(1);
        SCREEN = layout.offsetof(2);
        DEPTH = layout.offsetof(3);
        CLASS = layout.offsetof(4);
        RED_MASK = layout.offsetof(5);
        GREEN_MASK = layout.offsetof(6);
        BLUE_MASK = layout.offsetof(7);
        COLORMAP_SIZE = layout.offsetof(8);
        BITS_PER_RGB = layout.offsetof(9);
    }

    public static final class Buffer
    extends StructBuffer<XVisualInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected XVisualInfo newInstance(long address) {
            return new XVisualInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public Visual visual() {
            return XVisualInfo.nvisual(this.address());
        }

        public long visualid() {
            return XVisualInfo.nvisualid(this.address());
        }

        public int screen() {
            return XVisualInfo.nscreen(this.address());
        }

        public int depth() {
            return XVisualInfo.ndepth(this.address());
        }

        public int class$() {
            return XVisualInfo.nclass$(this.address());
        }

        public long red_mask() {
            return XVisualInfo.nred_mask(this.address());
        }

        public long green_mask() {
            return XVisualInfo.ngreen_mask(this.address());
        }

        public long blue_mask() {
            return XVisualInfo.nblue_mask(this.address());
        }

        public int colormap_size() {
            return XVisualInfo.ncolormap_size(this.address());
        }

        public int bits_per_rgb() {
            return XVisualInfo.nbits_per_rgb(this.address());
        }

        public Buffer visual(Visual value) {
            XVisualInfo.nvisual(this.address(), value);
            return this;
        }

        public Buffer visualid(long value) {
            XVisualInfo.nvisualid(this.address(), value);
            return this;
        }

        public Buffer screen(int value) {
            XVisualInfo.nscreen(this.address(), value);
            return this;
        }

        public Buffer depth(int value) {
            XVisualInfo.ndepth(this.address(), value);
            return this;
        }

        public Buffer class$(int value) {
            XVisualInfo.nclass$(this.address(), value);
            return this;
        }

        public Buffer red_mask(long value) {
            XVisualInfo.nred_mask(this.address(), value);
            return this;
        }

        public Buffer green_mask(long value) {
            XVisualInfo.ngreen_mask(this.address(), value);
            return this;
        }

        public Buffer blue_mask(long value) {
            XVisualInfo.nblue_mask(this.address(), value);
            return this;
        }

        public Buffer colormap_size(int value) {
            XVisualInfo.ncolormap_size(this.address(), value);
            return this;
        }

        public Buffer bits_per_rgb(int value) {
            XVisualInfo.nbits_per_rgb(this.address(), value);
            return this;
        }
    }
}

