/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class JAWTX11DrawingSurfaceInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DRAWABLE;
    public static final int DISPLAY;
    public static final int VISUALID;
    public static final int COLORMAPID;
    public static final int DEPTH;

    JAWTX11DrawingSurfaceInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public JAWTX11DrawingSurfaceInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), JAWTX11DrawingSurfaceInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long drawable() {
        return JAWTX11DrawingSurfaceInfo.ndrawable(this.address());
    }

    public long display() {
        return JAWTX11DrawingSurfaceInfo.ndisplay(this.address());
    }

    public long visualID() {
        return JAWTX11DrawingSurfaceInfo.nvisualID(this.address());
    }

    public long colormapID() {
        return JAWTX11DrawingSurfaceInfo.ncolormapID(this.address());
    }

    public int depth() {
        return JAWTX11DrawingSurfaceInfo.ndepth(this.address());
    }

    public static JAWTX11DrawingSurfaceInfo malloc() {
        return JAWTX11DrawingSurfaceInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static JAWTX11DrawingSurfaceInfo calloc() {
        return JAWTX11DrawingSurfaceInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static JAWTX11DrawingSurfaceInfo create() {
        return new JAWTX11DrawingSurfaceInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static JAWTX11DrawingSurfaceInfo create(long address) {
        return address == 0L ? null : new JAWTX11DrawingSurfaceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return JAWTX11DrawingSurfaceInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return JAWTX11DrawingSurfaceInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static JAWTX11DrawingSurfaceInfo mallocStack() {
        return JAWTX11DrawingSurfaceInfo.mallocStack(MemoryStack.stackGet());
    }

    public static JAWTX11DrawingSurfaceInfo callocStack() {
        return JAWTX11DrawingSurfaceInfo.callocStack(MemoryStack.stackGet());
    }

    public static JAWTX11DrawingSurfaceInfo mallocStack(MemoryStack stack) {
        return JAWTX11DrawingSurfaceInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static JAWTX11DrawingSurfaceInfo callocStack(MemoryStack stack) {
        return JAWTX11DrawingSurfaceInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return JAWTX11DrawingSurfaceInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return JAWTX11DrawingSurfaceInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return JAWTX11DrawingSurfaceInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return JAWTX11DrawingSurfaceInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndrawable(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DRAWABLE);
    }

    public static long ndisplay(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DISPLAY);
    }

    public static long nvisualID(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VISUALID);
    }

    public static long ncolormapID(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)COLORMAPID);
    }

    public static int ndepth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTH);
    }

    static {
        Struct.Layout layout = JAWTX11DrawingSurfaceInfo.__struct(JAWTX11DrawingSurfaceInfo.__member(POINTER_SIZE), JAWTX11DrawingSurfaceInfo.__member(POINTER_SIZE), JAWTX11DrawingSurfaceInfo.__member(POINTER_SIZE), JAWTX11DrawingSurfaceInfo.__member(POINTER_SIZE), JAWTX11DrawingSurfaceInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DRAWABLE = layout.offsetof(0);
        DISPLAY = layout.offsetof(1);
        VISUALID = layout.offsetof(2);
        COLORMAPID = layout.offsetof(3);
        DEPTH = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<JAWTX11DrawingSurfaceInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected JAWTX11DrawingSurfaceInfo newInstance(long address) {
            return new JAWTX11DrawingSurfaceInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long drawable() {
            return JAWTX11DrawingSurfaceInfo.ndrawable(this.address());
        }

        public long display() {
            return JAWTX11DrawingSurfaceInfo.ndisplay(this.address());
        }

        public long visualID() {
            return JAWTX11DrawingSurfaceInfo.nvisualID(this.address());
        }

        public long colormapID() {
            return JAWTX11DrawingSurfaceInfo.ncolormapID(this.address());
        }

        public int depth() {
            return JAWTX11DrawingSurfaceInfo.ndepth(this.address());
        }
    }
}

