/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Field;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.MemoryAccess;
import org.lwjgl.system.ThreadLocalState;
import sun.misc.Unsafe;

public final class ThreadLocalUtil {
    private static final State TLS = ThreadLocalUtil.getInstance();

    private ThreadLocalUtil() {
    }

    public static ThreadLocalState tlsGet() {
        return TLS.get();
    }

    private static State getInstance() {
        String tls = Configuration.THREAD_LOCAL_SPACE.get("unsafe");
        if ("unsafe".equals(tls)) {
            try {
                return new UnsafeState();
            }
            catch (Throwable t) {
                APIUtil.apiLog("[TLS] Failed to initialize unsafe implementation.");
                return new TLState();
            }
        }
        if ("ThreadLocal".equals(tls)) {
            return new TLState();
        }
        throw new IllegalStateException("Invalid " + Configuration.THREAD_LOCAL_SPACE.getProperty() + " specified.");
    }

    static {
        APIUtil.apiLog("ThreadLocalUtil state: " + TLS.getClass().getSimpleName());
    }

    private static class UnsafeState
    implements State {
        private static final Unsafe UNSAFE = MemoryAccess.getUnsafeInstance();
        private static final long TARGET;

        private UnsafeState() {
        }

        @Override
        public ThreadLocalState get() {
            Object target = UNSAFE.getObject(Thread.currentThread(), TARGET);
            return ThreadLocalState.class.isInstance(target) ? (ThreadLocalState)target : this.setInitialValue();
        }

        private ThreadLocalState setInitialValue() {
            ThreadLocalState tls = new ThreadLocalState();
            this.set(tls);
            return tls;
        }

        @Override
        public void set(ThreadLocalState value) {
            Thread t = Thread.currentThread();
            value.target = (Runnable)UNSAFE.getObject(t, TARGET);
            UNSAFE.putObject(t, TARGET, value);
        }

        static {
            try {
                Field field = Thread.class.getDeclaredField("target");
                if (!Runnable.class.isAssignableFrom(field.getType())) {
                    throw new IllegalStateException();
                }
                TARGET = UNSAFE.objectFieldOffset(field);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TLState
    implements State {
        private static final ThreadLocal<ThreadLocalState> STATE = new ThreadLocal<ThreadLocalState>(){

            @Override
            protected ThreadLocalState initialValue() {
                return new ThreadLocalState();
            }
        };

        private TLState() {
        }

        @Override
        public void set(ThreadLocalState value) {
            STATE.set(value);
        }

        @Override
        public ThreadLocalState get() {
            return STATE.get();
        }
    }

    private static interface State {
        public void set(ThreadLocalState var1);

        public ThreadLocalState get();
    }
}

