/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRVector2i
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    OVRVector2i(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRVector2i(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRVector2i.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int x() {
        return OVRVector2i.nx(this.address());
    }

    public int y() {
        return OVRVector2i.ny(this.address());
    }

    public OVRVector2i x(int value) {
        OVRVector2i.nx(this.address(), value);
        return this;
    }

    public OVRVector2i y(int value) {
        OVRVector2i.ny(this.address(), value);
        return this;
    }

    public OVRVector2i set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public OVRVector2i nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRVector2i set(OVRVector2i src) {
        return this.nset(src.address());
    }

    public static OVRVector2i malloc() {
        return OVRVector2i.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRVector2i calloc() {
        return OVRVector2i.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRVector2i create() {
        return new OVRVector2i(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRVector2i create(long address) {
        return address == 0L ? null : new OVRVector2i(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRVector2i.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRVector2i.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRVector2i mallocStack() {
        return OVRVector2i.mallocStack(MemoryStack.stackGet());
    }

    public static OVRVector2i callocStack() {
        return OVRVector2i.callocStack(MemoryStack.stackGet());
    }

    public static OVRVector2i mallocStack(MemoryStack stack) {
        return OVRVector2i.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRVector2i callocStack(MemoryStack stack) {
        return OVRVector2i.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRVector2i.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRVector2i.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRVector2i.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRVector2i.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = OVRVector2i.__struct(OVRVector2i.__member(4), OVRVector2i.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRVector2i, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRVector2i newInstance(long address) {
            return new OVRVector2i(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int x() {
            return OVRVector2i.nx(this.address());
        }

        public int y() {
            return OVRVector2i.ny(this.address());
        }

        public Buffer x(int value) {
            OVRVector2i.nx(this.address(), value);
            return this;
        }

        public Buffer y(int value) {
            OVRVector2i.ny(this.address(), value);
            return this;
        }
    }
}

