/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVViewportArray {
    public static final int GL_MAX_VIEWPORTS_NV = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS_NV = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE_NV = 33373;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX_NV = 33375;

    protected NVViewportArray() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glViewportArrayvNV, caps.glViewportIndexedfNV, caps.glViewportIndexedfvNV, caps.glScissorArrayvNV, caps.glScissorIndexedNV, caps.glScissorIndexedvNV, caps.glDepthRangeArrayfvNV, caps.glDepthRangeIndexedfNV, caps.glGetFloati_vNV, caps.glEnableiNV, caps.glDisableiNV, caps.glIsEnablediNV);
    }

    public static void nglViewportArrayvNV(int first, int count, long v) {
        long __functionAddress = GLES.getCapabilities().glViewportArrayvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, count, v);
    }

    public static void glViewportArrayvNV(int first, FloatBuffer v) {
        NVViewportArray.nglViewportArrayvNV(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static void glViewportIndexedfNV(int index, float x, float y, float w, float h) {
        long __functionAddress = GLES.getCapabilities().glViewportIndexedfNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, x, y, w, h);
    }

    public static void nglViewportIndexedfvNV(int index, long v) {
        long __functionAddress = GLES.getCapabilities().glViewportIndexedfvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glViewportIndexedfvNV(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        NVViewportArray.nglViewportIndexedfvNV(index, MemoryUtil.memAddress(v));
    }

    public static void nglScissorArrayvNV(int first, int count, long v) {
        long __functionAddress = GLES.getCapabilities().glScissorArrayvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, count, v);
    }

    public static void glScissorArrayvNV(int first, IntBuffer v) {
        NVViewportArray.nglScissorArrayvNV(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static void glScissorIndexedNV(int index, int left, int bottom, int width, int height) {
        long __functionAddress = GLES.getCapabilities().glScissorIndexedNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, left, bottom, width, height);
    }

    public static void nglScissorIndexedvNV(int index, long v) {
        long __functionAddress = GLES.getCapabilities().glScissorIndexedvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glScissorIndexedvNV(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        NVViewportArray.nglScissorIndexedvNV(index, MemoryUtil.memAddress(v));
    }

    public static void nglDepthRangeArrayfvNV(int first, int count, long v) {
        long __functionAddress = GLES.getCapabilities().glDepthRangeArrayfvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, count, v);
    }

    public static void glDepthRangeArrayfvNV(int first, FloatBuffer v) {
        NVViewportArray.nglDepthRangeArrayfvNV(first, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static void glDepthRangeIndexedfNV(int index, float n, float f) {
        long __functionAddress = GLES.getCapabilities().glDepthRangeIndexedfNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, n, f);
    }

    public static void nglGetFloati_vNV(int target, int index, long data) {
        long __functionAddress = GLES.getCapabilities().glGetFloati_vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }

    public static void glGetFloati_vNV(int target, int index, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        NVViewportArray.nglGetFloati_vNV(target, index, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetFloatiNV(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            NVViewportArray.nglGetFloati_vNV(target, index, MemoryUtil.memAddress(data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glEnableiNV(int target, int index) {
        long __functionAddress = GLES.getCapabilities().glEnableiNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, index);
    }

    public static void glDisableiNV(int target, int index) {
        long __functionAddress = GLES.getCapabilities().glDisableiNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, index);
    }

    public static boolean glIsEnablediNV(int target, int index) {
        long __functionAddress = GLES.getCapabilities().glIsEnablediNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, target, index);
    }

    public static void glViewportArrayvNV(int first, float[] v) {
        long __functionAddress = GLES.getCapabilities().glViewportArrayvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, v.length >> 2, v);
    }

    public static void glViewportIndexedfvNV(int index, float[] v) {
        long __functionAddress = GLES.getCapabilities().glViewportIndexedfvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glScissorArrayvNV(int first, int[] v) {
        long __functionAddress = GLES.getCapabilities().glScissorArrayvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, v.length >> 2, v);
    }

    public static void glScissorIndexedvNV(int index, int[] v) {
        long __functionAddress = GLES.getCapabilities().glScissorIndexedvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glDepthRangeArrayfvNV(int first, float[] v) {
        long __functionAddress = GLES.getCapabilities().glDepthRangeArrayfvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, v.length >> 1, v);
    }

    public static void glGetFloati_vNV(int target, int index, float[] data) {
        long __functionAddress = GLES.getCapabilities().glGetFloati_vNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(data, 1);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }
}

