/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ANGLETranslatedShaderSource {
    public static final int GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE = 37792;

    protected ANGLETranslatedShaderSource() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glGetTranslatedShaderSourceANGLE);
    }

    public static void nglGetTranslatedShaderSourceANGLE(int shader, int bufsize, long length, long source) {
        long __functionAddress = GLES.getCapabilities().glGetTranslatedShaderSourceANGLE;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, shader, bufsize, length, source);
    }

    public static void glGetTranslatedShaderSourceANGLE(int shader, IntBuffer length, ByteBuffer source) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ANGLETranslatedShaderSource.nglGetTranslatedShaderSourceANGLE(shader, source.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetTranslatedShaderSourceANGLE(int shader, int bufsize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc(bufsize);
        try {
            IntBuffer length = stack.ints(0);
            ANGLETranslatedShaderSource.nglGetTranslatedShaderSourceANGLE(shader, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(source));
            String string = MemoryUtil.memUTF8(source, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(source);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetTranslatedShaderSourceANGLE(int shader) {
        int bufsize = GLES20.glGetShaderi(shader, 37792);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc(bufsize);
        try {
            IntBuffer length = stack.ints(0);
            ANGLETranslatedShaderSource.nglGetTranslatedShaderSourceANGLE(shader, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(source));
            String string = MemoryUtil.memUTF8(source, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(source);
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetTranslatedShaderSourceANGLE(int shader, int[] length, ByteBuffer source) {
        long __functionAddress = GLES.getCapabilities().glGetTranslatedShaderSourceANGLE;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, shader, source.remaining(), length, MemoryUtil.memAddress(source));
    }
}

