/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ANGLEInstancedArrays {
    public static final int GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE = 35070;

    protected ANGLEInstancedArrays() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glDrawArraysInstancedANGLE, caps.glDrawElementsInstancedANGLE, caps.glVertexAttribDivisorANGLE);
    }

    public static void glDrawArraysInstancedANGLE(int mode, int first, int count, int primcount) {
        long __functionAddress = GLES.getCapabilities().glDrawArraysInstancedANGLE;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, mode, first, count, primcount);
    }

    public static void nglDrawElementsInstancedANGLE(int mode, int count, int type, long indices, int primcount) {
        long __functionAddress = GLES.getCapabilities().glDrawElementsInstancedANGLE;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstancedANGLE(int mode, int count, int type, long indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        ANGLEInstancedArrays.nglDrawElementsInstancedANGLE(mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstancedANGLE(int mode, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        ANGLEInstancedArrays.nglDrawElementsInstancedANGLE(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedANGLE(int mode, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        ANGLEInstancedArrays.nglDrawElementsInstancedANGLE(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedANGLE(int mode, ShortBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        ANGLEInstancedArrays.nglDrawElementsInstancedANGLE(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedANGLE(int mode, IntBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        ANGLEInstancedArrays.nglDrawElementsInstancedANGLE(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glVertexAttribDivisorANGLE(int index, int divisor) {
        long __functionAddress = GLES.getCapabilities().glVertexAttribDivisorANGLE;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, divisor);
    }
}

