/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class CL10GL {
    public static final int CL_INVALID_GL_OBJECT = -60;
    public static final int CL_INVALID_MIP_LEVEL = -62;
    public static final int CL_GL_OBJECT_BUFFER = 8192;
    public static final int CL_GL_OBJECT_TEXTURE2D = 8193;
    public static final int CL_GL_OBJECT_TEXTURE3D = 8194;
    public static final int CL_GL_OBJECT_RENDERBUFFER = 8195;
    public static final int CL_GL_TEXTURE_TARGET = 8196;
    public static final int CL_GL_MIPMAP_LEVEL = 8197;

    protected CL10GL() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clCreateFromGLBuffer, caps.clCreateFromGLTexture2D, caps.clCreateFromGLTexture3D, caps.clCreateFromGLRenderbuffer, caps.clGetGLObjectInfo, caps.clGetGLTextureInfo, caps.clEnqueueAcquireGLObjects, caps.clEnqueueReleaseGLObjects);
    }

    public static long nclCreateFromGLBuffer(long context, long flags, int bufobj, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return JNI.callPJPP(__functionAddress, context, flags, bufobj, errcode_ret);
    }

    public static long clCreateFromGLBuffer(long context, long flags, int bufobj, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLBuffer(context, flags, bufobj, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCreateFromGLTexture2D(long context, long flags, int texture_target, int miplevel, int texture, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLTexture2D;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return JNI.callPJPP(__functionAddress, context, flags, texture_target, miplevel, texture, errcode_ret);
    }

    public static long clCreateFromGLTexture2D(long context, long flags, int texture_target, int miplevel, int texture, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLTexture2D(context, flags, texture_target, miplevel, texture, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCreateFromGLTexture3D(long context, long flags, int texture_target, int miplevel, int texture, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLTexture3D;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return JNI.callPJPP(__functionAddress, context, flags, texture_target, miplevel, texture, errcode_ret);
    }

    public static long clCreateFromGLTexture3D(long context, long flags, int texture_target, int miplevel, int texture, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLTexture3D(context, flags, texture_target, miplevel, texture, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCreateFromGLRenderbuffer(long context, long flags, int renderbuffer, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLRenderbuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return JNI.callPJPP(__functionAddress, context, flags, renderbuffer, errcode_ret);
    }

    public static long clCreateFromGLRenderbuffer(long context, long flags, int renderbuffer, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLRenderbuffer(context, flags, renderbuffer, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclGetGLObjectInfo(long memobj, long gl_object_type, long gl_object_name) {
        long __functionAddress = CL.getICD().clGetGLObjectInfo;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(memobj);
        }
        return JNI.callPPPI(__functionAddress, memobj, gl_object_type, gl_object_name);
    }

    public static int clGetGLObjectInfo(long memobj, IntBuffer gl_object_type, IntBuffer gl_object_name) {
        return CL10GL.nclGetGLObjectInfo(memobj, MemoryUtil.memAddressSafe(gl_object_type), MemoryUtil.memAddressSafe(gl_object_name));
    }

    public static int nclGetGLTextureInfo(long memobj, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetGLTextureInfo;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(memobj);
        }
        return JNI.callPPPPI(__functionAddress, memobj, param_name, param_value_size, param_value, param_value_size_ret);
    }

    public static int clGetGLTextureInfo(long memobj, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10GL.nclGetGLTextureInfo(memobj, param_name, param_value == null ? 0 : param_value.remaining(), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetGLTextureInfo(long memobj, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10GL.nclGetGLTextureInfo(memobj, param_name, param_value == null ? 0 : param_value.remaining() << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int nclEnqueueAcquireGLObjects(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueAcquireGLObjects;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return JNI.callPPPPI(__functionAddress, command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueAcquireGLObjects(long command_queue, PointerBuffer mem_objects, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10GL.nclEnqueueAcquireGLObjects(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clEnqueueAcquireGLObjects(long command_queue, long mem_object, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer mem_objects = stack.pointers(mem_object);
            int n = CL10GL.nclEnqueueAcquireGLObjects(command_queue, 1, MemoryUtil.memAddress(mem_objects), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclEnqueueReleaseGLObjects(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueReleaseGLObjects;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return JNI.callPPPPI(__functionAddress, command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueReleaseGLObjects(long command_queue, PointerBuffer mem_objects, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10GL.nclEnqueueReleaseGLObjects(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clEnqueueReleaseGLObjects(long command_queue, long mem_object, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer mem_objects = stack.pointers(mem_object);
            int n = CL10GL.nclEnqueueReleaseGLObjects(command_queue, 1, MemoryUtil.memAddress(mem_objects), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long clCreateFromGLBuffer(long context, long flags, int bufobj, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
            if (errcode_ret != null) {
                Checks.checkBuffer(errcode_ret, 1);
            }
        }
        return JNI.callPJPP(__functionAddress, context, flags, bufobj, errcode_ret);
    }

    public static long clCreateFromGLTexture2D(long context, long flags, int texture_target, int miplevel, int texture, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLTexture2D;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
            if (errcode_ret != null) {
                Checks.checkBuffer(errcode_ret, 1);
            }
        }
        return JNI.callPJPP(__functionAddress, context, flags, texture_target, miplevel, texture, errcode_ret);
    }

    public static long clCreateFromGLTexture3D(long context, long flags, int texture_target, int miplevel, int texture, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLTexture3D;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
            if (errcode_ret != null) {
                Checks.checkBuffer(errcode_ret, 1);
            }
        }
        return JNI.callPJPP(__functionAddress, context, flags, texture_target, miplevel, texture, errcode_ret);
    }

    public static long clCreateFromGLRenderbuffer(long context, long flags, int renderbuffer, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromGLRenderbuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
            if (errcode_ret != null) {
                Checks.checkBuffer(errcode_ret, 1);
            }
        }
        return JNI.callPJPP(__functionAddress, context, flags, renderbuffer, errcode_ret);
    }

    public static int clGetGLObjectInfo(long memobj, int[] gl_object_type, int[] gl_object_name) {
        long __functionAddress = CL.getICD().clGetGLObjectInfo;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(memobj);
        }
        return JNI.callPPPI(__functionAddress, memobj, gl_object_type, gl_object_name);
    }

    public static int clGetGLTextureInfo(long memobj, int param_name, int[] param_value, PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetGLTextureInfo;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(memobj);
            if (param_value_size_ret != null) {
                Checks.checkBuffer(param_value_size_ret, 1);
            }
        }
        return JNI.callPPPPI(__functionAddress, memobj, param_name, (long)(param_value == null ? 0 : param_value.length << 2), param_value, MemoryUtil.memAddressSafe(param_value_size_ret));
    }
}

