package uk.ac.cam.cl.gfxintro.gd355.tick2;

import static org.lwjgl.opengl.GL11.*;
import static org.lwjgl.opengl.GL15.*;
import static org.lwjgl.opengl.GL20.*;
import static org.lwjgl.opengl.GL30.*;

public class RenderTarget {
	
	private int frameBuffer;
	private int width;
	private int height;
	private Texture colBuffer;
	
	public RenderTarget(int width, int height) throws Exception {
		this.width = width;
		this.height = height;
		colBuffer = new Texture();
		colBuffer.createDynamicTexture(width, height);
		
		frameBuffer = glGenFramebuffers();
		glBindFramebuffer(GL_FRAMEBUFFER, frameBuffer);
		glBindTexture(GL_TEXTURE_2D, colBuffer.getTexId());
		glFramebufferTexture2D(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_2D, colBuffer.getTexId(), 0);
		
		int depthBuffer = glGenRenderbuffers();
		glBindRenderbuffer(GL_RENDERBUFFER, depthBuffer);
		glRenderbufferStorage(GL_RENDERBUFFER, GL_DEPTH_COMPONENT, width, height);
		glFramebufferRenderbuffer(GL_FRAMEBUFFER, GL_DEPTH_ATTACHMENT, GL_RENDERBUFFER, depthBuffer);
		
		int buffers[] = { GL_COLOR_ATTACHMENT0, };
		glDrawBuffers(buffers);
		glReadBuffer(GL_NONE);
		int err = glCheckFramebufferStatus(GL_FRAMEBUFFER);
		if (err != GL_FRAMEBUFFER_COMPLETE)
		{
			throw new Exception("incomplete frame buffer");
		}

		glBindFramebuffer(GL_FRAMEBUFFER, 0);
	}
	
	private int oldWidth;
	private int oldHeight;
	
	public Texture getTargetColourTexture() {
		return colBuffer;
	}
	
	public void startUsing() {
		
		int[] viewPort = new int[4];
		glGetIntegerv(GL_VIEWPORT, viewPort);
		oldWidth = viewPort[2];
		oldHeight = viewPort[3];
		
		glBindFramebuffer(GL_FRAMEBUFFER, frameBuffer);
		glViewport(0, 0, width, height);
	}
	
	public void stopUsing() {
		glBindFramebuffer(GL_FRAMEBUFFER, 0);
		glViewport(0, 0, oldWidth, oldHeight);
	}

}
