package uk.ac.cam.cl.gfxintro.gd355.tick2;

import static org.lwjgl.opengl.GL20.GL_FRAGMENT_SHADER;
import static org.lwjgl.opengl.GL20.GL_VERTEX_SHADER;
import static org.lwjgl.opengl.GL20.glGetUniformLocation;
import static org.lwjgl.opengl.GL20.glUniform3f;

import org.joml.Vector3f;

public class Cube extends Mesh {
	
	// cube's colour
	Vector3f diffuseColour;
	
    // Filenames for vertex and fragment shader source code
    private final static String VSHADER_FN = "resources/cube_vertex_shader.glsl";
    private final static String FSHADER_FN = "resources/cube_fragment_shader.glsl";
    
    void setColour(Vector3f newCol) {
    	diffuseColour = newCol;
    }
	
	public Cube(Vector3f colour) {
		super(new ShaderProgram(new Shader(GL_VERTEX_SHADER, VSHADER_FN), new Shader(GL_FRAGMENT_SHADER, FSHADER_FN), "colour"));
		diffuseColour = colour;
	}

	@Override
	float[] initializeVertexPositions() {
		float[] vertPositions = new float[] {
				-2,  2, -2, -2,  2,  2,  2,  2, -2,
				-2,  2,  2,  2,  2,  2,  2,  2, -2,
				-2, -2,  2, -2, -2, -2,  2, -2,  2,
				-2, -2, -2,  2, -2, -2,  2, -2,  2,
				-2,  2,  2, -2, -2,  2,  2,  2,  2,
				-2, -2,  2,  2, -2,  2,  2,  2,  2,
				-2, -2, -2, -2,  2, -2,  2, -2, -2,
				-2,  2, -2,  2,  2, -2,  2, -2, -2,
				-2, -2, -2, -2, -2,  2, -2,  2, -2,
				-2, -2,  2, -2,  2,  2, -2,  2, -2,
				2,  2, -2,  2,  2,  2,  2, -2, -2,
				2,  2,  2,  2, -2,  2,  2, -2, -2
		};
		return vertPositions;
	}

	@Override
	int[] initializeVertexIndices() {

		int[] indices = new int[] {
				0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11,
				12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
				24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35
		};
		return indices;
	}

	@Override
	float[] initializeVertexNormals() {

		float[] vertNormals = new float[] {
				0,  1,  0,  0,  1,  0,  0,  1,  0,
				0,  1,  0,  0,  1,  0,  0,  1,  0,
				0, -1,  0,  0, -1,  0,  0, -1,  0,
				0, -1,  0,  0, -1,  0,  0, -1,  0,
				0,  0,  1,  0,  0,  1,  0,  0,  1,
				0,  0,  1,  0,  0,  1,  0,  0,  1,
				0,  0, -1,  0,  0, -1,  0,  0, -1,
				0,  0, -1,  0,  0, -1,  0,  0, -1,
				-1,  0,  0, -1,  0,  0, -1,  0,  0,
				-1,  0,  0, -1,  0,  0, -1,  0,  0,
				1,  0,  0,  1,  0,  0,  1,  0,  0,
				1,  0,  0,  1,  0,  0,  1,  0,  0
		};
		return vertNormals;
	}

	@Override
	float[] initializeTextureCoordinates() {
		float[] texCoors = new float[36];
		return texCoors;
	}

	@Override
	void preRender(Camera c) {
		// before we draw, we want to set  C_diff uniform to diffuseColour
		int colour_location = glGetUniformLocation(shaders.getHandle(), "C_diff");  // Note that glGetUniformLocation is expensive. This would normally be in the constructor!
		glUniform3f(colour_location, diffuseColour.x, diffuseColour.y, diffuseColour.z);
	}

	@Override
	void postRender(Camera c) {
	}

}
