#version 330

in vec3 position;		// vertex position in local space
in vec3 normal;			// vertex normal in local space
in vec2 texcoord;		// texture coordinate in texture space

out vec3 frag_normal;	// fragment normal in world space
out vec2 frag_texcoord;	// fragment normal in world space
out vec3 frag_worldPos; // fragment position in world space
out vec4 frag_reflPos; 

uniform mat4 mvp_matrix; // model-view-projection matrix
uniform mat4 m_matrix; // model matrix
uniform mat4 reflWorldViewProj; // reflection mvp

void main()
{
    // Typicaly normal is transformed by the model matrix
    // Since the model matrix is identity in our case, we do not modify normals
    frag_normal = normal;
    frag_texcoord = texcoord;

    // The position is projected to the screen coordinates using mvp_matrix
    gl_Position = mvp_matrix * vec4(position, 1.0);
    frag_reflPos = reflWorldViewProj * vec4(position, 1.0);
    
    frag_worldPos = (m_matrix * vec4(position, 1.0)).xyz;
    
}

