#version 140

in vec3 frag_normal;        // fragment normal in world space

out vec3 colour;

uniform vec3 C_diff;
uniform sampler2D tex;  // 2D texture sampler

void main()
{
    const vec3 I_a = vec3(0.2, 0.2, 0.2);       // Ambient light intensity (and colour)

    const float k_d = 0.8;                      // Diffuse light factor
    
	const vec3 I = vec3(0.941, 0.968, 1);   // Light intensity (and colour)
	vec3 L = normalize(vec3(2, 1.5, -0.5)); // The light direction as a unit vector
	vec3 N = frag_normal;                   // Normal in world coordinates

	colour = C_diff * I_a + C_diff * k_d * I * max(0, dot(N, L));
}

