/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineDynamicStateCreateInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DYNAMICSTATECOUNT;
    public static final int PDYNAMICSTATES;

    VkPipelineDynamicStateCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkPipelineDynamicStateCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkPipelineDynamicStateCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkPipelineDynamicStateCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkPipelineDynamicStateCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkPipelineDynamicStateCreateInfo.nflags(this.address());
    }

    public int dynamicStateCount() {
        return VkPipelineDynamicStateCreateInfo.ndynamicStateCount(this.address());
    }

    public IntBuffer pDynamicStates() {
        return VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address());
    }

    public VkPipelineDynamicStateCreateInfo sType(int value) {
        VkPipelineDynamicStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo pNext(long value) {
        VkPipelineDynamicStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo flags(int value) {
        VkPipelineDynamicStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo pDynamicStates(IntBuffer value) {
        VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo set(int sType, long pNext, int flags, IntBuffer pDynamicStates) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pDynamicStates(pDynamicStates);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo set(VkPipelineDynamicStateCreateInfo src) {
        return this.nset(src.address());
    }

    public static VkPipelineDynamicStateCreateInfo malloc() {
        return VkPipelineDynamicStateCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkPipelineDynamicStateCreateInfo calloc() {
        return VkPipelineDynamicStateCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkPipelineDynamicStateCreateInfo create() {
        return new VkPipelineDynamicStateCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkPipelineDynamicStateCreateInfo create(long address) {
        return address == 0L ? null : new VkPipelineDynamicStateCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineDynamicStateCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineDynamicStateCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkPipelineDynamicStateCreateInfo mallocStack() {
        return VkPipelineDynamicStateCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineDynamicStateCreateInfo callocStack() {
        return VkPipelineDynamicStateCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineDynamicStateCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineDynamicStateCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineDynamicStateCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineDynamicStateCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineDynamicStateCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineDynamicStateCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineDynamicStateCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineDynamicStateCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int ndynamicStateCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DYNAMICSTATECOUNT);
    }

    public static IntBuffer npDynamicStates(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PDYNAMICSTATES), VkPipelineDynamicStateCreateInfo.ndynamicStateCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void ndynamicStateCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DYNAMICSTATECOUNT, value);
    }

    public static void npDynamicStates(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDYNAMICSTATES, MemoryUtil.memAddress(value));
        VkPipelineDynamicStateCreateInfo.ndynamicStateCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PDYNAMICSTATES));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkPipelineDynamicStateCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkPipelineDynamicStateCreateInfo.__struct(VkPipelineDynamicStateCreateInfo.__member(4), VkPipelineDynamicStateCreateInfo.__member(POINTER_SIZE), VkPipelineDynamicStateCreateInfo.__member(4), VkPipelineDynamicStateCreateInfo.__member(4), VkPipelineDynamicStateCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DYNAMICSTATECOUNT = layout.offsetof(3);
        PDYNAMICSTATES = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<VkPipelineDynamicStateCreateInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkPipelineDynamicStateCreateInfo newInstance(long address) {
            return new VkPipelineDynamicStateCreateInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkPipelineDynamicStateCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkPipelineDynamicStateCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkPipelineDynamicStateCreateInfo.nflags(this.address());
        }

        public int dynamicStateCount() {
            return VkPipelineDynamicStateCreateInfo.ndynamicStateCount(this.address());
        }

        public IntBuffer pDynamicStates() {
            return VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address());
        }

        public Buffer sType(int value) {
            VkPipelineDynamicStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkPipelineDynamicStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkPipelineDynamicStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pDynamicStates(IntBuffer value) {
            VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address(), value);
            return this;
        }
    }
}

