/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkOffset3D
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    VkOffset3D(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkOffset3D(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkOffset3D.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int x() {
        return VkOffset3D.nx(this.address());
    }

    public int y() {
        return VkOffset3D.ny(this.address());
    }

    public int z() {
        return VkOffset3D.nz(this.address());
    }

    public VkOffset3D x(int value) {
        VkOffset3D.nx(this.address(), value);
        return this;
    }

    public VkOffset3D y(int value) {
        VkOffset3D.ny(this.address(), value);
        return this;
    }

    public VkOffset3D z(int value) {
        VkOffset3D.nz(this.address(), value);
        return this;
    }

    public VkOffset3D set(int x, int y, int z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public VkOffset3D nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkOffset3D set(VkOffset3D src) {
        return this.nset(src.address());
    }

    public static VkOffset3D malloc() {
        return VkOffset3D.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkOffset3D calloc() {
        return VkOffset3D.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkOffset3D create() {
        return new VkOffset3D(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkOffset3D create(long address) {
        return address == 0L ? null : new VkOffset3D(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkOffset3D.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkOffset3D.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkOffset3D mallocStack() {
        return VkOffset3D.mallocStack(MemoryStack.stackGet());
    }

    public static VkOffset3D callocStack() {
        return VkOffset3D.callocStack(MemoryStack.stackGet());
    }

    public static VkOffset3D mallocStack(MemoryStack stack) {
        return VkOffset3D.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkOffset3D callocStack(MemoryStack stack) {
        return VkOffset3D.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkOffset3D.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkOffset3D.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkOffset3D.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkOffset3D.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static int nz(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Z);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    public static void nz(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = VkOffset3D.__struct(VkOffset3D.__member(4), VkOffset3D.__member(4), VkOffset3D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<VkOffset3D, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkOffset3D newInstance(long address) {
            return new VkOffset3D(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int x() {
            return VkOffset3D.nx(this.address());
        }

        public int y() {
            return VkOffset3D.ny(this.address());
        }

        public int z() {
            return VkOffset3D.nz(this.address());
        }

        public Buffer x(int value) {
            VkOffset3D.nx(this.address(), value);
            return this;
        }

        public Buffer y(int value) {
            VkOffset3D.ny(this.address(), value);
            return this;
        }

        public Buffer z(int value) {
            VkOffset3D.nz(this.address(), value);
            return this;
        }
    }
}

