/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GL32 {
    public static final int GL_CONTEXT_PROFILE_MASK = 37158;
    public static final int GL_CONTEXT_CORE_PROFILE_BIT = 1;
    public static final int GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = 2;
    public static final int GL_MAX_VERTEX_OUTPUT_COMPONENTS = 37154;
    public static final int GL_MAX_GEOMETRY_INPUT_COMPONENTS = 37155;
    public static final int GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 37156;
    public static final int GL_MAX_FRAGMENT_INPUT_COMPONENTS = 37157;
    public static final int GL_FIRST_VERTEX_CONVENTION = 36429;
    public static final int GL_LAST_VERTEX_CONVENTION = 36430;
    public static final int GL_PROVOKING_VERTEX = 36431;
    public static final int GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 36428;
    public static final int GL_TEXTURE_CUBE_MAP_SEAMLESS = 34895;
    public static final int GL_SAMPLE_POSITION = 36432;
    public static final int GL_SAMPLE_MASK = 36433;
    public static final int GL_SAMPLE_MASK_VALUE = 36434;
    public static final int GL_TEXTURE_2D_MULTISAMPLE = 37120;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE = 37121;
    public static final int GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 37122;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 37123;
    public static final int GL_MAX_SAMPLE_MASK_WORDS = 36441;
    public static final int GL_MAX_COLOR_TEXTURE_SAMPLES = 37134;
    public static final int GL_MAX_DEPTH_TEXTURE_SAMPLES = 37135;
    public static final int GL_MAX_INTEGER_SAMPLES = 37136;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE = 37124;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 37125;
    public static final int GL_TEXTURE_SAMPLES = 37126;
    public static final int GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 37127;
    public static final int GL_SAMPLER_2D_MULTISAMPLE = 37128;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE = 37129;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 37130;
    public static final int GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 37131;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37132;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37133;
    public static final int GL_DEPTH_CLAMP = 34383;
    public static final int GL_GEOMETRY_SHADER = 36313;
    public static final int GL_GEOMETRY_VERTICES_OUT = 36314;
    public static final int GL_GEOMETRY_INPUT_TYPE = 36315;
    public static final int GL_GEOMETRY_OUTPUT_TYPE = 36316;
    public static final int GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 35881;
    public static final int GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 36319;
    public static final int GL_MAX_GEOMETRY_OUTPUT_VERTICES = 36320;
    public static final int GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 36321;
    public static final int GL_LINES_ADJACENCY = 10;
    public static final int GL_LINE_STRIP_ADJACENCY = 11;
    public static final int GL_TRIANGLES_ADJACENCY = 12;
    public static final int GL_TRIANGLE_STRIP_ADJACENCY = 13;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 36264;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 36263;
    public static final int GL_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final long GL_TIMEOUT_IGNORED = -1L;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;

    protected GL32() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glGetBufferParameteri64v, caps.glDrawElementsBaseVertex, caps.glDrawRangeElementsBaseVertex, caps.glDrawElementsInstancedBaseVertex, caps.glMultiDrawElementsBaseVertex, caps.glProvokingVertex, caps.glTexImage2DMultisample, caps.glTexImage3DMultisample, caps.glGetMultisamplefv, caps.glSampleMaski, caps.glFramebufferTexture, caps.glFenceSync, caps.glIsSync, caps.glDeleteSync, caps.glClientWaitSync, caps.glWaitSync, caps.glGetInteger64v, caps.glGetInteger64i_v, caps.glGetSynciv);
    }

    public static void nglGetBufferParameteri64v(int target, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetBufferParameteri64v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetBufferParameteri64v(int target, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL32.nglGetBufferParameteri64v(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetBufferParameteri64(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            GL32.nglGetBufferParameteri64v(target, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDrawElementsBaseVertex(int mode, int count, int type, long indices, int basevertex) {
        long __functionAddress = GL.getCapabilities().glDrawElementsBaseVertex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, int count, int type, long indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        GL32.nglDrawElementsBaseVertex(mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        long __functionAddress = GL.getCapabilities().glDrawRangeElementsBaseVertex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawElementsInstancedBaseVertex(int mode, int count, int type, long indices, int primcount, int basevertex) {
        long __functionAddress = GL.getCapabilities().glDrawElementsInstancedBaseVertex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int count, int type, long indices, int primcount, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        GL32.nglDrawElementsInstancedBaseVertex(mode, count, type, indices, primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int type, ByteBuffer indices, int primcount, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ByteBuffer indices, int primcount, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ShortBuffer indices, int primcount, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, IntBuffer indices, int primcount, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void nglMultiDrawElementsBaseVertex(int mode, long count, int type, long indices, int primcount, long basevertex) {
        long __functionAddress = GL.getCapabilities().glMultiDrawElementsBaseVertex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, mode, count, type, indices, primcount, basevertex);
    }

    public static void glMultiDrawElementsBaseVertex(int mode, IntBuffer count, int type, PointerBuffer indices, IntBuffer basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(indices, count.remaining());
            Checks.checkBuffer((Buffer)basevertex, count.remaining());
        }
        GL32.nglMultiDrawElementsBaseVertex(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), count.remaining(), MemoryUtil.memAddress(basevertex));
    }

    public static void glProvokingVertex(int mode) {
        long __functionAddress = GL.getCapabilities().glProvokingVertex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, mode);
    }

    public static void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        long __functionAddress = GL.getCapabilities().glTexImage2DMultisample;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, samples, internalformat, width, height, fixedsamplelocations);
    }

    public static void glTexImage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations) {
        long __functionAddress = GL.getCapabilities().glTexImage3DMultisample;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }

    public static void nglGetMultisamplefv(int pname, int index, long val) {
        long __functionAddress = GL.getCapabilities().glGetMultisamplefv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, pname, index, val);
    }

    public static void glGetMultisamplefv(int pname, int index, FloatBuffer val) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)val, 1);
        }
        GL32.nglGetMultisamplefv(pname, index, MemoryUtil.memAddress(val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetMultisamplef(int pname, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer val = stack.callocFloat(1);
            GL32.nglGetMultisamplefv(pname, index, MemoryUtil.memAddress(val));
            float f = val.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glSampleMaski(int index, int mask) {
        long __functionAddress = GL.getCapabilities().glSampleMaski;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, mask);
    }

    public static void glFramebufferTexture(int target, int attachment, int texture, int level) {
        long __functionAddress = GL.getCapabilities().glFramebufferTexture;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, attachment, texture, level);
    }

    public static long glFenceSync(int condition, int flags) {
        long __functionAddress = GL.getCapabilities().glFenceSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callP(__functionAddress, condition, flags);
    }

    public static boolean glIsSync(long sync) {
        long __functionAddress = GL.getCapabilities().glIsSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        return JNI.callPZ(__functionAddress, sync);
    }

    public static void glDeleteSync(long sync) {
        long __functionAddress = GL.getCapabilities().glDeleteSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        JNI.callPV(__functionAddress, sync);
    }

    public static int glClientWaitSync(long sync, int flags, long timeout) {
        long __functionAddress = GL.getCapabilities().glClientWaitSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        return JNI.callPJI(__functionAddress, sync, flags, timeout);
    }

    public static void glWaitSync(long sync, int flags, long timeout) {
        long __functionAddress = GL.getCapabilities().glWaitSync;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        JNI.callPJV(__functionAddress, sync, flags, timeout);
    }

    public static void nglGetInteger64v(int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetInteger64v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, pname, params);
    }

    public static void glGetInteger64v(int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL32.nglGetInteger64v(pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetInteger64(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            GL32.nglGetInteger64v(pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetInteger64i_v(int pname, int index, long params) {
        long __functionAddress = GL.getCapabilities().glGetInteger64i_v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, pname, index, params);
    }

    public static void glGetInteger64i_v(int pname, int index, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL32.nglGetInteger64i_v(pname, index, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetInteger64i(int pname, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            GL32.nglGetInteger64i_v(pname, index, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetSynciv(long sync, int pname, int bufSize, long length, long values) {
        long __functionAddress = GL.getCapabilities().glGetSynciv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        JNI.callPPPV(__functionAddress, sync, pname, bufSize, length, values);
    }

    public static void glGetSynciv(long sync, int pname, IntBuffer length, IntBuffer values) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL32.nglGetSynciv(sync, pname, values.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSynci(long sync, int pname, IntBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values = stack.callocInt(1);
            GL32.nglGetSynciv(sync, pname, 1, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
            int n = values.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetBufferParameteri64v(int target, int pname, long[] params) {
        long __functionAddress = GL.getCapabilities().glGetBufferParameteri64v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glMultiDrawElementsBaseVertex(int mode, int[] count, int type, PointerBuffer indices, int[] basevertex) {
        long __functionAddress = GL.getCapabilities().glMultiDrawElementsBaseVertex;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(indices, count.length);
            Checks.checkBuffer(basevertex, count.length);
        }
        JNI.callPPPV(__functionAddress, mode, count, type, MemoryUtil.memAddress(indices), count.length, basevertex);
    }

    public static void glGetMultisamplefv(int pname, int index, float[] val) {
        long __functionAddress = GL.getCapabilities().glGetMultisamplefv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(val, 1);
        }
        JNI.callPV(__functionAddress, pname, index, val);
    }

    public static void glGetInteger64v(int pname, long[] params) {
        long __functionAddress = GL.getCapabilities().glGetInteger64v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, pname, params);
    }

    public static void glGetInteger64i_v(int pname, int index, long[] params) {
        long __functionAddress = GL.getCapabilities().glGetInteger64i_v;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, pname, index, params);
    }

    public static void glGetSynciv(long sync, int pname, int[] length, int[] values) {
        long __functionAddress = GL.getCapabilities().glGetSynciv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPPV(__functionAddress, sync, pname, values.length, length, values);
    }
}

