/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTSeparateShaderObjects {
    public static final int GL_ACTIVE_PROGRAM_EXT = 35725;

    protected EXTSeparateShaderObjects() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glUseShaderProgramEXT, caps.glActiveProgramEXT, caps.glCreateShaderProgramEXT);
    }

    public static void glUseShaderProgramEXT(int type, int program) {
        long __functionAddress = GL.getCapabilities().glUseShaderProgramEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, type, program);
    }

    public static void glActiveProgramEXT(int program) {
        long __functionAddress = GL.getCapabilities().glActiveProgramEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program);
    }

    public static int nglCreateShaderProgramEXT(int type, long string) {
        long __functionAddress = GL.getCapabilities().glCreateShaderProgramEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, type, string);
    }

    public static int glCreateShaderProgramEXT(int type, ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.checkNT1(string);
        }
        return EXTSeparateShaderObjects.nglCreateShaderProgramEXT(type, MemoryUtil.memAddress(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramEXT(int type, CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer stringEncoded = stack.UTF8(string);
            int n = EXTSeparateShaderObjects.nglCreateShaderProgramEXT(type, MemoryUtil.memAddress(stringEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

