/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTDrawBuffers2 {
    protected EXTDrawBuffers2() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glColorMaskIndexedEXT, caps.glGetBooleanIndexedvEXT, caps.glGetIntegerIndexedvEXT, caps.glEnableIndexedEXT, caps.glDisableIndexedEXT, caps.glIsEnabledIndexedEXT);
    }

    public static void glColorMaskIndexedEXT(int index, boolean r, boolean g, boolean b, boolean a) {
        long __functionAddress = GL.getCapabilities().glColorMaskIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, index, r, g, b, a);
    }

    public static void nglGetBooleanIndexedvEXT(int target, int index, long data) {
        long __functionAddress = GL.getCapabilities().glGetBooleanIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }

    public static void glGetBooleanIndexedvEXT(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        EXTDrawBuffers2.nglGetBooleanIndexedvEXT(target, index, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte glGetBooleanIndexedEXT(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer data = stack.calloc(1);
            EXTDrawBuffers2.nglGetBooleanIndexedvEXT(target, index, MemoryUtil.memAddress(data));
            byte by = data.get(0);
            return by;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetIntegerIndexedvEXT(int target, int index, long data) {
        long __functionAddress = GL.getCapabilities().glGetIntegerIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }

    public static void glGetIntegerIndexedvEXT(int target, int index, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        EXTDrawBuffers2.nglGetIntegerIndexedvEXT(target, index, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetIntegerIndexedEXT(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            EXTDrawBuffers2.nglGetIntegerIndexedvEXT(target, index, MemoryUtil.memAddress(data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glEnableIndexedEXT(int target, int index) {
        long __functionAddress = GL.getCapabilities().glEnableIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, index);
    }

    public static void glDisableIndexedEXT(int target, int index) {
        long __functionAddress = GL.getCapabilities().glDisableIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, index);
    }

    public static boolean glIsEnabledIndexedEXT(int target, int index) {
        long __functionAddress = GL.getCapabilities().glIsEnabledIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, target, index);
    }

    public static void glGetIntegerIndexedvEXT(int target, int index, int[] data) {
        long __functionAddress = GL.getCapabilities().glGetIntegerIndexedvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(data, 1);
        }
        JNI.callPV(__functionAddress, target, index, data);
    }
}

