/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.EXTThreadLocalContext;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.ThreadLocalUtil;

public final class AL {
    private static FunctionProvider functionProvider;
    private static ALCapabilities processCaps;
    private static final CapabilitiesState capabilitiesState;

    private AL() {
    }

    static void init() {
        functionProvider = new FunctionProvider(){
            private final long alGetProcAddress = ALC.getFunctionProvider().getFunctionAddress("alGetProcAddress");

            @Override
            public long getFunctionAddress(ByteBuffer functionName) {
                long address = JNI.invokePP(this.alGetProcAddress, MemoryUtil.memAddress(functionName));
                if (address == 0L && Checks.DEBUG_FUNCTIONS) {
                    APIUtil.apiLog("Failed to locate address for AL function " + MemoryUtil.memASCII(functionName));
                }
                return address;
            }
        };
    }

    static void destroy() {
        if (functionProvider == null) {
            return;
        }
        AL.setCurrentProcess(null);
        functionProvider = null;
    }

    public static void setCurrentProcess(ALCapabilities caps) {
        processCaps = caps;
        capabilitiesState.set(null);
    }

    public static void setCurrentThread(ALCapabilities caps) {
        capabilitiesState.set(caps);
    }

    public static ALCapabilities getCurrentCapabilities() {
        ALCapabilities caps = capabilitiesState.get();
        return caps != null ? caps : processCaps;
    }

    public static ALCapabilities getCapabilities() {
        ALCapabilities current = AL.getCurrentCapabilities();
        if (current == null) {
            throw new IllegalStateException("No ALCapabilities instance set for the current thread or process. Possible solutions:\n\ta) Call AL.createCapabilities() after making a context current.\n\tb) Call AL.setCurrentProcess() or AL.setCurrentThread() if an ALCapabilities instance already exists.");
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ALCapabilities createCapabilities(ALCCapabilities alcCaps) {
        ALCapabilities aLCapabilities;
        ALCapabilities caps = null;
        try {
            long GetString = functionProvider.getFunctionAddress("alGetString");
            long GetError = functionProvider.getFunctionAddress("alGetError");
            long IsExtensionPresent = functionProvider.getFunctionAddress("alIsExtensionPresent");
            if (GetString == 0L || GetError == 0L || IsExtensionPresent == 0L) {
                throw new IllegalStateException("Core OpenAL functions could not be found. Make sure that the OpenAL library has been loaded correctly.");
            }
            long versionString = JNI.invokeP(GetString, 45058);
            if (versionString == 0L || JNI.callI(GetError) != 0) {
                throw new IllegalStateException("There is no OpenAL context current in the current thread or process.");
            }
            APIUtil.APIVersion apiVersion = APIUtil.apiParseVersion(MemoryUtil.memASCII(versionString));
            int majorVersion = apiVersion.major;
            int minorVersion = apiVersion.minor;
            int[][] AL_VERSIONS = new int[][]{{0, 1}};
            HashSet<String> supportedExtensions = new HashSet<String>(32);
            for (int major = 1; major <= AL_VERSIONS.length; ++major) {
                int[] minors;
                for (int minor : minors = AL_VERSIONS[major - 1]) {
                    if (major >= majorVersion && (major != majorVersion || minor > minorVersion)) continue;
                    supportedExtensions.add("OpenAL" + Integer.toString(major) + Integer.toString(minor));
                }
            }
            String extensionsString = MemoryUtil.memUTF8(Checks.checkPointer(JNI.invokeP(GetString, 45060)));
            MemoryStack stack = MemoryStack.stackGet();
            StringTokenizer tokenizer = new StringTokenizer(extensionsString);
            while (tokenizer.hasMoreTokens()) {
                String extName = tokenizer.nextToken();
                stack.push();
                try {
                    if (!JNI.invokePZ(IsExtensionPresent, MemoryUtil.memAddress(stack.ASCII(extName, true)))) continue;
                    supportedExtensions.add(extName);
                }
                finally {
                    stack.pop();
                }
            }
            if (alcCaps.ALC_EXT_EFX) {
                supportedExtensions.add("ALC_EXT_EFX");
            }
            aLCapabilities = caps = new ALCapabilities(functionProvider, supportedExtensions);
        }
        catch (Throwable throwable) {
            if (alcCaps.ALC_EXT_thread_local_context && EXTThreadLocalContext.alcGetThreadContext() != 0L) {
                AL.setCurrentThread(caps);
            } else {
                AL.setCurrentProcess(caps);
            }
            throw throwable;
        }
        if (alcCaps.ALC_EXT_thread_local_context && EXTThreadLocalContext.alcGetThreadContext() != 0L) {
            AL.setCurrentThread(caps);
        } else {
            AL.setCurrentProcess(caps);
        }
        return aLCapabilities;
    }

    static boolean checkExtension(String extension, boolean supported) {
        if (supported) {
            return true;
        }
        APIUtil.apiLog("[AL] " + extension + " was reported as available but an entry point is missing.");
        return false;
    }

    static {
        String capsStateType = Configuration.OPENAL_CAPABILITIES_STATE.get("ThreadLocal");
        if ("static".equals(capsStateType)) {
            capabilitiesState = new StaticCapabilitiesState();
        } else if ("ThreadLocal".equals(capsStateType)) {
            capabilitiesState = new TLCapabilitiesState();
        } else {
            throw new IllegalStateException("Invalid " + Configuration.OPENAL_CAPABILITIES_STATE.getProperty() + " specified.");
        }
    }

    private static class StaticCapabilitiesState
    implements CapabilitiesState {
        private static final List<Field> flags;
        private static final List<Field> funcs;
        private static ALCapabilities tempCaps;

        private StaticCapabilitiesState() {
        }

        @Override
        public void set(ALCapabilities caps) {
            if (Checks.DEBUG) {
                StaticCapabilitiesState.checkCapabilities(caps);
            }
            tempCaps = caps;
        }

        private static void checkCapabilities(ALCapabilities caps) {
            if (caps != null && tempCaps != null && !APIUtil.apiCompareCapabilities(flags, funcs, tempCaps, caps)) {
                APIUtil.apiLog("An OpenAL context with different functionality detected! The ThreadLocal capabilities state must be used.");
            }
        }

        @Override
        public ALCapabilities get() {
            return WriteOnce.caps;
        }

        static /* synthetic */ ALCapabilities access$300() {
            return tempCaps;
        }

        static {
            if (Checks.DEBUG) {
                Field[] fields = ALCapabilities.class.getFields();
                flags = new ArrayList<Field>(64);
                funcs = new ArrayList<Field>(16);
                for (Field f : fields) {
                    (f.getType() == Boolean.TYPE ? flags : funcs).add(f);
                }
            } else {
                flags = null;
                funcs = null;
            }
        }

        private static final class WriteOnce {
            private static final ALCapabilities caps = StaticCapabilitiesState.access$300();

            private WriteOnce() {
            }

            static {
                if (caps == null) {
                    throw new IllegalStateException("The static ALCapabilities instance is null");
                }
            }
        }
    }

    private static class TLCapabilitiesState
    implements CapabilitiesState {
        private TLCapabilitiesState() {
        }

        @Override
        public void set(ALCapabilities caps) {
            ThreadLocalUtil.tlsGet().capsAL = caps;
        }

        @Override
        public ALCapabilities get() {
            return ThreadLocalUtil.tlsGet().capsAL;
        }
    }

    private static interface CapabilitiesState {
        public void set(ALCapabilities var1);

        public ALCapabilities get();
    }
}

