\name{tapplydjw}
\title{A version of tapply which keeps track of NA factor levels}
\alias{tapplydjw}
\description{
Like \code{\link[base]{tapply}}, apply a function to each cell of a
ragged array, that is to each (non-empty) group of values given by a
unique combination of the levels of certain factors. Unlike
\code{tapply}, this version considers \code{NA} to be a distinct factor
level.
Furthermore, this version allows one to specify that an extra 'level'
should be reported for certain of the factors, called ALL, consisting of
all levels of that factor; this is useful for computing table margins.
}
\usage{
tapplydjw(X, INDEX, FUN = NULL, ..., ALL=numeric(0))
}
\arguments{
  \item{X, INDEX, FUN, ...}{as for \code{tapply}}
  \item{ALL}{a vector of integers, indicating for which indices we want
    aggregates computed}
  }
\author{DJW}
\seealso{\code{\link[base]{tapply}}; used by \code{\link{xxtabs}}}
\keyword{manip}
