\name{Surv-ops}
\alias{\%/\%.Surv}
\title{Division for censored data}
\description{
  Divide one censored vector by another
}
\usage{
\method{\%/\%}{Surv}(e1,e2)
}
\arguments{
  \item{e1,e2}{censored observations of class \code{\link[survival]{Surv}}}
  \item{...}{other arguments, ignored}
}
\details{
  Perform division, keeping track of censoring. For example, if
  \eqn{x\geq6}{x>=6} and \eqn{y\leq2}{y<=2} then \eqn{x/y\geq3}{x/y>=3}.
  \cr
  Note: this function only works for simple interval-censored data.
}
\value{
  A censored vector, of class \code{\link[survival]{Surv}}
}
\author{DJW}
\seealso{\code{\link[survival]{Surv}}}
\examples{
xs <- Surv(6,2) # x>=6
ys <- Surv(2,0) # y<=2
xs %/% ys
}
\keyword{arith}
