\name{squelch}
\alias{squelch}
\alias{squelch2}
\title{Aggregate a data frame by superimposing rows}
\description{
  Splits the rows of the data frame into subsets, and squelches together
the rows within each
  subset. When squelching, a non-missing value takes priority over a
  missing value.
}
\usage{
squelch(data, idvar, drop=character(0), FUN=squelch2, warn=TRUE)
squelch2(x,y,...,warn=TRUE)
}
\arguments{
  \item{data}{the data frame to be squelched}
  \item{idvar}{the column names which
    identify rows from a single individual; a character vector}
  \item{drop}{the column names which are to be dropped; a character
    vector}
  \item{FUN}{the function to use to squelch two rows together}
  \item{warn}{whether or not to issue warnings when non-missing values
    in one row overwrite non-missing values in the second row; for
    \code{squelch} this is logical, for \code{squelch2} it may be
    either logical or a string to be added to the warning message}
  \item{x,y}{two vectors to be squelched together: if \code{x} has
    missing values then these will be filled in from \code{y}}
    \item{...}{additional arguments, ignored}
}
\value{
  \code{squelch} returns a data frame, containing one row for each
  individual, identified by distinct value of the columns \code{idvar}.
  Multiple rows belonging to the same individual are squelched together
  using the function \code{squelch2} by default; it will take
  values from the topmost row for an individual, unless the value is
  missing, in which case it will look in the next row, etc.
  }
\author{DJW}
\keyword{manip}
