\name{order.slowfirst}
\title{Re-order a matrix so the first term varies slowest}
\alias{order.slowfirst}
\alias{order.fastfirst}
\description{The \code{\link[base]{expand.grid}} function returns a data
  frame in which the first index varies fastest. It may look prettier to
  make the first index vary slowest. The function \code{order.slowfirst}
  gives a permutation to put the data frame into this order.
}
\usage{
order.slowfirst(dims)
order.fastfirst(dims)
}
\arguments{
  \item{dims}{a vector of integers, giving the dimensions of a matrix}
}
\details{
  \code{order.slowfirst} can be used to reorder a data frame, produced
  from \code{expand.grid}, so that the
  first term varies slowest. Its counterpart \code{order.fastfirst} is useless.
}
\author{DJW}
\seealso{\code{\link{xxtabs}}}
\examples{
# If we turn an array into a data frame, then the first column varies fastest
m <- array(rnorm(6), dim=c(2,3), dimnames=list(fac1=c('a','b'), fac2=1:3))
df <- cbind(expand.grid(dimnames(m)), val=c(m))
df

# To make the first column vary slowest, reorder thus:
df[order.slowfirst(dim(m)),]
}
\keyword{manip}
