\name{showchanges}
\alias{sigstyle}
\alias{sigchar}
\alias{showchanges}
\alias{panel.groups.showchanges}
\alias{panel.showchanges}
\title{Dodgy plots for biologists}
\description{Plot lines, and arrows showing significance levels.
  For each group and panel, at each x coordinate, arrows are drawn
  to the y values from other groups. The arrows are colour-coded
  and labelled according to some specified p-value.
  See example usage.}
\usage{
showchanges(...,panel=panel.showchanges,panel.groups=panel.groups.showchanges)
panel.groups.showchanges(x,y,...,connect.line,arrowswidth)
panel.showchanges(x,y,groups,subscripts,...,sig,arrowswidth=.2,connect.line=TRUE,cex=.7,len=.1)
sigstyle(p)
sigchar(p)
}
\arguments{
  \item{panel, panel.groups}{panel arguments, as for
    \code{\link[lattice]{xyplot}}}
  \item{x,y}{x and y coordinates to plot}
  \item{sig}{a list of the same length as \code{x} and \code{y};
    each entry is a named vector of p-values to draw, where the names refer to groups}
  \item{groups,subscripts}{as for \code{\link[lattice]{xyplot}}}
  \item{connect.line}{boolean vector, indicating how the line for each
    group should be joined}
  \item{arrowswidth}{width of each step}
  \item{cex}{font size to use for p-value labels}
  \item{len}{arrow head argument, passed on to
    \code{\link[lattice]{larrows}}}
  \item{p}{a numeric vector of p values}
  \item{\dots}{other arguments, passed to \code{\link[lattice]{xyplot}}}
}
\details{
  The functions \code{sigstyle} and \code{sigchar} may be overwritten,
  to display the arrows differently. \code{sigstyle} should return a
  list with two elements, \code{lwd} and \code{lty}, each as long as \code{p}; \code{sigchar}
  should return a character vector of labels to draw.
  }
\author{DJW}
\examples{
df <- data.frame(day=rep(c(1,2,3,'AVERAGE'),each=2,times=2),
                  response=rnorm(16)+rep(c(1,2),each=8),
                  treat=rep(c('control','active'),each=8),
                  when=rep(c('ante','post'),times=8))
sig <- c(lapply(1:8, function(i) c('active'=rexp(1,rate=10))),
         lapply(1:8, function(i) NA))
 
showchanges(response~day|when, groups=treat, data=df, sig=sig, type='l',
             arrowswidth=.4, connect.line=c(TRUE,TRUE,FALSE,FALSE,TRUE,TRUE,FALSE,FALSE),
             panel=panel.showchanges, auto.key=TRUE
             )
}
