\name{short}
\alias{short}
\alias{short.summary.lme}
\alias{print.short.summary.lme}
\title{Print a short summary of an lme fit}
\description{The standard \code{summary} method for \code{\link[nlme]{lme}}
  objects prints out a big table of correlations between fixed
  effects. This method suppresses that table.}
\usage{
\method{short}{summary.lme}(x,\dots)
}
\arguments{
  \item{x}{a \code{summary.lme} object}
  \item{\dots}{other arguments, not used}
}
\seealso{
  \code{\link[nlme]{summary.lme}}
  }
\author{DJW}
\examples{
require(nlme)
data(Alfalfa)
fit <- lme(Yield ~ Variety+Block, random = ~1|Date, method='ML', data=Alfalfa)

# A long summary
summary(fit)

# A short summary
short(summary(fit))
}
  